package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CommitMeta}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommitMeta.builder()}.
 */
@Generated(from = "CommitMeta", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommitMeta extends CommitMeta {
  private final @Nullable String hash;
  private final @Nullable String committer;
  private final @Nullable String author;
  private final @Nullable String signedOffBy;
  private final String message;
  private final @Nullable Instant commitTime;
  private final @Nullable Instant authorTime;
  private final Map<String, String> properties;

  private ImmutableCommitMeta(
      @Nullable String hash,
      @Nullable String committer,
      @Nullable String author,
      @Nullable String signedOffBy,
      String message,
      @Nullable Instant commitTime,
      @Nullable Instant authorTime,
      Map<String, String> properties) {
    this.hash = hash;
    this.committer = committer;
    this.author = author;
    this.signedOffBy = signedOffBy;
    this.message = message;
    this.commitTime = commitTime;
    this.authorTime = authorTime;
    this.properties = properties;
  }

  /**
   * Hash of this commit.
   * <p>This is not known at creation time and is only valid when reading the log.
   */
  @JsonProperty("hash")
  @Override
  public @Nullable String getHash() {
    return hash;
  }

  /**
   * The entity performing this commit/transaction.
   * <p>This is the logged in user/account who performs this action. Populated on the server. Nessie
   * will return an error if this is populated by the client side.
   * <p>The committer should follow the git spec for names eg Committer Name
   * &lt;committer.name@example.com&gt; but this is not enforced. See
   * https://git-scm.com/docs/git-commit#Documentation/git-commit.txt---authorltauthorgt
   */
  @JsonProperty("committer")
  @Override
  public @Nullable String getCommitter() {
    return committer;
  }

  /**
   *The author of a commit. This is the original committer. 
   */
  @JsonProperty("author")
  @Override
  public @Nullable String getAuthor() {
    return author;
  }

  /**
   * Authorizer of this action.
   * <p>For example if the user who did the transaction is a service account this could be populated
   * by the person who started the job.
   */
  @JsonProperty("signedOffBy")
  @Override
  public @Nullable String getSignedOffBy() {
    return signedOffBy;
  }

  /**
   * Message describing this commit. Should conform to Git style.
   * <p>Like github if this message is in markdown it may be displayed cleanly in the UI.
   */
  @JsonProperty("message")
  @Override
  public String getMessage() {
    return message;
  }

  /**
   *Commit time in UTC. Set by the server. 
   */
  @JsonProperty("commitTime")
  @JsonSerialize(using = CommitMeta.InstantSerializer.class)
  @JsonDeserialize(using = CommitMeta.InstantDeserializer.class)
  @Override
  public @Nullable Instant getCommitTime() {
    return commitTime;
  }

  /**
   *Original commit time in UTC. Set by the server. 
   */
  @JsonProperty("authorTime")
  @JsonSerialize(using = CommitMeta.InstantSerializer.class)
  @JsonDeserialize(using = CommitMeta.InstantDeserializer.class)
  @Override
  public @Nullable Instant getAuthorTime() {
    return authorTime;
  }

  /**
   * Set of properties to help further identify this commit.
   * <p>examples are spark id, the client type (eg iceberg, delta etc), application or job names,
   * hostnames etc
   */
  @JsonProperty("properties")
  @Override
  public Map<String, String> getProperties() {
    return properties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitMeta#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitMeta withHash(@Nullable String value) {
    if (Objects.equals(this.hash, value)) return this;
    return new ImmutableCommitMeta(
        value,
        this.committer,
        this.author,
        this.signedOffBy,
        this.message,
        this.commitTime,
        this.authorTime,
        this.properties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitMeta#getCommitter() committer} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for committer (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitMeta withCommitter(@Nullable String value) {
    if (Objects.equals(this.committer, value)) return this;
    return new ImmutableCommitMeta(
        this.hash,
        value,
        this.author,
        this.signedOffBy,
        this.message,
        this.commitTime,
        this.authorTime,
        this.properties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitMeta#getAuthor() author} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for author (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitMeta withAuthor(@Nullable String value) {
    if (Objects.equals(this.author, value)) return this;
    return new ImmutableCommitMeta(
        this.hash,
        this.committer,
        value,
        this.signedOffBy,
        this.message,
        this.commitTime,
        this.authorTime,
        this.properties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitMeta#getSignedOffBy() signedOffBy} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for signedOffBy (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitMeta withSignedOffBy(@Nullable String value) {
    if (Objects.equals(this.signedOffBy, value)) return this;
    return new ImmutableCommitMeta(
        this.hash,
        this.committer,
        this.author,
        value,
        this.message,
        this.commitTime,
        this.authorTime,
        this.properties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitMeta#getMessage() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitMeta withMessage(String value) {
    String newValue = Objects.requireNonNull(value, "message");
    if (this.message.equals(newValue)) return this;
    return new ImmutableCommitMeta(
        this.hash,
        this.committer,
        this.author,
        this.signedOffBy,
        newValue,
        this.commitTime,
        this.authorTime,
        this.properties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitMeta#getCommitTime() commitTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitMeta withCommitTime(@Nullable Instant value) {
    if (this.commitTime == value) return this;
    return new ImmutableCommitMeta(
        this.hash,
        this.committer,
        this.author,
        this.signedOffBy,
        this.message,
        value,
        this.authorTime,
        this.properties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitMeta#getAuthorTime() authorTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for authorTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitMeta withAuthorTime(@Nullable Instant value) {
    if (this.authorTime == value) return this;
    return new ImmutableCommitMeta(
        this.hash,
        this.committer,
        this.author,
        this.signedOffBy,
        this.message,
        this.commitTime,
        value,
        this.properties);
  }

  /**
   * Copy the current immutable object by replacing the {@link CommitMeta#getProperties() properties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the properties map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitMeta withProperties(Map<String, ? extends String> entries) {
    if (this.properties == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableCommitMeta(
        this.hash,
        this.committer,
        this.author,
        this.signedOffBy,
        this.message,
        this.commitTime,
        this.authorTime,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommitMeta} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommitMeta
        && equalTo((ImmutableCommitMeta) another);
  }

  private boolean equalTo(ImmutableCommitMeta another) {
    return Objects.equals(hash, another.hash)
        && Objects.equals(committer, another.committer)
        && Objects.equals(author, another.author)
        && Objects.equals(signedOffBy, another.signedOffBy)
        && message.equals(another.message)
        && Objects.equals(commitTime, another.commitTime)
        && Objects.equals(authorTime, another.authorTime)
        && properties.equals(another.properties);
  }

  /**
   * Computes a hash code from attributes: {@code hash}, {@code committer}, {@code author}, {@code signedOffBy}, {@code message}, {@code commitTime}, {@code authorTime}, {@code properties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(hash);
    h += (h << 5) + Objects.hashCode(committer);
    h += (h << 5) + Objects.hashCode(author);
    h += (h << 5) + Objects.hashCode(signedOffBy);
    h += (h << 5) + message.hashCode();
    h += (h << 5) + Objects.hashCode(commitTime);
    h += (h << 5) + Objects.hashCode(authorTime);
    h += (h << 5) + properties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CommitMeta} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CommitMeta{"
        + "hash=" + hash
        + ", committer=" + committer
        + ", author=" + author
        + ", signedOffBy=" + signedOffBy
        + ", message=" + message
        + ", commitTime=" + commitTime
        + ", authorTime=" + authorTime
        + ", properties=" + properties
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CommitMeta", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends CommitMeta {
    @Nullable String hash;
    @Nullable String committer;
    @Nullable String author;
    @Nullable String signedOffBy;
    @Nullable String message;
    @Nullable Instant commitTime;
    @Nullable Instant authorTime;
    @Nullable Map<String, String> properties = Collections.emptyMap();
    @JsonProperty("hash")
    public void setHash(@Nullable String hash) {
      this.hash = hash;
    }
    @JsonProperty("committer")
    public void setCommitter(@Nullable String committer) {
      this.committer = committer;
    }
    @JsonProperty("author")
    public void setAuthor(@Nullable String author) {
      this.author = author;
    }
    @JsonProperty("signedOffBy")
    public void setSignedOffBy(@Nullable String signedOffBy) {
      this.signedOffBy = signedOffBy;
    }
    @JsonProperty("message")
    public void setMessage(String message) {
      this.message = message;
    }
    @JsonProperty("commitTime")
    @JsonSerialize(using = CommitMeta.InstantSerializer.class)
    @JsonDeserialize(using = CommitMeta.InstantDeserializer.class)
    public void setCommitTime(@Nullable Instant commitTime) {
      this.commitTime = commitTime;
    }
    @JsonProperty("authorTime")
    @JsonSerialize(using = CommitMeta.InstantSerializer.class)
    @JsonDeserialize(using = CommitMeta.InstantDeserializer.class)
    public void setAuthorTime(@Nullable Instant authorTime) {
      this.authorTime = authorTime;
    }
    @JsonProperty("properties")
    public void setProperties(Map<String, String> properties) {
      this.properties = properties;
    }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
    @Override
    public String getCommitter() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuthor() { throw new UnsupportedOperationException(); }
    @Override
    public String getSignedOffBy() { throw new UnsupportedOperationException(); }
    @Override
    public String getMessage() { throw new UnsupportedOperationException(); }
    @Override
    public Instant getCommitTime() { throw new UnsupportedOperationException(); }
    @Override
    public Instant getAuthorTime() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getProperties() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCommitMeta fromJson(Json json) {
    ImmutableCommitMeta.Builder builder = ImmutableCommitMeta.builder();
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    if (json.committer != null) {
      builder.committer(json.committer);
    }
    if (json.author != null) {
      builder.author(json.author);
    }
    if (json.signedOffBy != null) {
      builder.signedOffBy(json.signedOffBy);
    }
    if (json.message != null) {
      builder.message(json.message);
    }
    if (json.commitTime != null) {
      builder.commitTime(json.commitTime);
    }
    if (json.authorTime != null) {
      builder.authorTime(json.authorTime);
    }
    if (json.properties != null) {
      builder.putAllProperties(json.properties);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CommitMeta} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommitMeta instance
   */
  public static ImmutableCommitMeta copyOf(CommitMeta instance) {
    if (instance instanceof ImmutableCommitMeta) {
      return (ImmutableCommitMeta) instance;
    }
    return ImmutableCommitMeta.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommitMeta ImmutableCommitMeta}.
   * <pre>
   * ImmutableCommitMeta.builder()
   *    .hash(String | null) // nullable {@link CommitMeta#getHash() hash}
   *    .committer(String | null) // nullable {@link CommitMeta#getCommitter() committer}
   *    .author(String | null) // nullable {@link CommitMeta#getAuthor() author}
   *    .signedOffBy(String | null) // nullable {@link CommitMeta#getSignedOffBy() signedOffBy}
   *    .message(String) // required {@link CommitMeta#getMessage() message}
   *    .commitTime(java.time.Instant | null) // nullable {@link CommitMeta#getCommitTime() commitTime}
   *    .authorTime(java.time.Instant | null) // nullable {@link CommitMeta#getAuthorTime() authorTime}
   *    .putProperties|putAllProperties(String =&gt; String) // {@link CommitMeta#getProperties() properties} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableCommitMeta builder
   */
  public static ImmutableCommitMeta.Builder builder() {
    return new ImmutableCommitMeta.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommitMeta ImmutableCommitMeta}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommitMeta", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MESSAGE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String hash;
    private @Nullable String committer;
    private @Nullable String author;
    private @Nullable String signedOffBy;
    private @Nullable String message;
    private @Nullable Instant commitTime;
    private @Nullable Instant authorTime;
    private Map<String, String> properties = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CommitMeta} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CommitMeta instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String hashValue = instance.getHash();
      if (hashValue != null) {
        hash(hashValue);
      }
      @Nullable String committerValue = instance.getCommitter();
      if (committerValue != null) {
        committer(committerValue);
      }
      @Nullable String authorValue = instance.getAuthor();
      if (authorValue != null) {
        author(authorValue);
      }
      @Nullable String signedOffByValue = instance.getSignedOffBy();
      if (signedOffByValue != null) {
        signedOffBy(signedOffByValue);
      }
      message(instance.getMessage());
      @Nullable Instant commitTimeValue = instance.getCommitTime();
      if (commitTimeValue != null) {
        commitTime(commitTimeValue);
      }
      @Nullable Instant authorTimeValue = instance.getAuthorTime();
      if (authorTimeValue != null) {
        authorTime(authorTimeValue);
      }
      putAllProperties(instance.getProperties());
      return this;
    }

    /**
     * Initializes the value for the {@link CommitMeta#getHash() hash} attribute.
     * @param hash The value for hash (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hash")
    public final Builder hash(@Nullable String hash) {
      this.hash = hash;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitMeta#getCommitter() committer} attribute.
     * @param committer The value for committer (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("committer")
    public final Builder committer(@Nullable String committer) {
      this.committer = committer;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitMeta#getAuthor() author} attribute.
     * @param author The value for author (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("author")
    public final Builder author(@Nullable String author) {
      this.author = author;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitMeta#getSignedOffBy() signedOffBy} attribute.
     * @param signedOffBy The value for signedOffBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("signedOffBy")
    public final Builder signedOffBy(@Nullable String signedOffBy) {
      this.signedOffBy = signedOffBy;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitMeta#getMessage() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("message")
    public final Builder message(String message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitMeta#getCommitTime() commitTime} attribute.
     * @param commitTime The value for commitTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("commitTime")
    @JsonSerialize(using = CommitMeta.InstantSerializer.class)
    @JsonDeserialize(using = CommitMeta.InstantDeserializer.class)
    public final Builder commitTime(@Nullable Instant commitTime) {
      this.commitTime = commitTime;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitMeta#getAuthorTime() authorTime} attribute.
     * @param authorTime The value for authorTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("authorTime")
    @JsonSerialize(using = CommitMeta.InstantSerializer.class)
    @JsonDeserialize(using = CommitMeta.InstantDeserializer.class)
    public final Builder authorTime(@Nullable Instant authorTime) {
      this.authorTime = authorTime;
      return this;
    }

    /**
     * Put one entry to the {@link CommitMeta#getProperties() properties} map.
     * @param key The key in the properties map
     * @param value The associated value in the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putProperties(String key, String value) {
      this.properties.put(
          Objects.requireNonNull(key, "properties key"),
          Objects.requireNonNull(value, "properties value"));
      return this;
    }

    /**
     * Put one entry to the {@link CommitMeta#getProperties() properties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putProperties(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.properties.put(
          Objects.requireNonNull(k, "properties key"),
          Objects.requireNonNull(v, "properties value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CommitMeta#getProperties() properties} map. Nulls are not permitted
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("properties")
    public final Builder properties(Map<String, ? extends String> entries) {
      this.properties.clear();
      return putAllProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CommitMeta#getProperties() properties} map. Nulls are not permitted
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllProperties(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.properties.put(
            Objects.requireNonNull(k, "properties key"),
            Objects.requireNonNull(v, "properties value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommitMeta ImmutableCommitMeta}.
     * @return An immutable instance of CommitMeta
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommitMeta build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCommitMeta(
          hash,
          committer,
          author,
          signedOffBy,
          message,
          commitTime,
          authorTime,
          createUnmodifiableMap(false, false, properties));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      return "Cannot build CommitMeta, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
