package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MultiGetContentsResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMultiGetContentsResponse.builder()}.
 */
@Generated(from = "MultiGetContentsResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMultiGetContentsResponse
    implements MultiGetContentsResponse {
  private final List<MultiGetContentsResponse.ContentsWithKey> contents;

  private ImmutableMultiGetContentsResponse(List<MultiGetContentsResponse.ContentsWithKey> contents) {
    this.contents = contents;
  }

  /**
   * @return The value of the {@code contents} attribute
   */
  @JsonProperty("contents")
  @Override
  public List<MultiGetContentsResponse.ContentsWithKey> getContents() {
    return contents;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MultiGetContentsResponse#getContents() contents}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMultiGetContentsResponse withContents(MultiGetContentsResponse.ContentsWithKey... elements) {
    List<MultiGetContentsResponse.ContentsWithKey> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableMultiGetContentsResponse(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MultiGetContentsResponse#getContents() contents}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of contents elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMultiGetContentsResponse withContents(Iterable<? extends MultiGetContentsResponse.ContentsWithKey> elements) {
    if (this.contents == elements) return this;
    List<MultiGetContentsResponse.ContentsWithKey> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableMultiGetContentsResponse(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMultiGetContentsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMultiGetContentsResponse
        && equalTo((ImmutableMultiGetContentsResponse) another);
  }

  private boolean equalTo(ImmutableMultiGetContentsResponse another) {
    return contents.equals(another.contents);
  }

  /**
   * Computes a hash code from attributes: {@code contents}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + contents.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MultiGetContentsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MultiGetContentsResponse{"
        + "contents=" + contents
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "MultiGetContentsResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements MultiGetContentsResponse {
    @Nullable List<MultiGetContentsResponse.ContentsWithKey> contents = Collections.emptyList();
    @JsonProperty("contents")
    public void setContents(List<MultiGetContentsResponse.ContentsWithKey> contents) {
      this.contents = contents;
    }
    @Override
    public List<MultiGetContentsResponse.ContentsWithKey> getContents() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMultiGetContentsResponse fromJson(Json json) {
    ImmutableMultiGetContentsResponse.Builder builder = ImmutableMultiGetContentsResponse.builder();
    if (json.contents != null) {
      builder.addAllContents(json.contents);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link MultiGetContentsResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MultiGetContentsResponse instance
   */
  public static ImmutableMultiGetContentsResponse copyOf(MultiGetContentsResponse instance) {
    if (instance instanceof ImmutableMultiGetContentsResponse) {
      return (ImmutableMultiGetContentsResponse) instance;
    }
    return ImmutableMultiGetContentsResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMultiGetContentsResponse ImmutableMultiGetContentsResponse}.
   * <pre>
   * ImmutableMultiGetContentsResponse.builder()
   *    .addContents|addAllContents(org.projectnessie.model.MultiGetContentsResponse.ContentsWithKey) // {@link MultiGetContentsResponse#getContents() contents} elements
   *    .build();
   * </pre>
   * @return A new ImmutableMultiGetContentsResponse builder
   */
  public static ImmutableMultiGetContentsResponse.Builder builder() {
    return new ImmutableMultiGetContentsResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMultiGetContentsResponse ImmutableMultiGetContentsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MultiGetContentsResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<MultiGetContentsResponse.ContentsWithKey> contents = new ArrayList<MultiGetContentsResponse.ContentsWithKey>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MultiGetContentsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MultiGetContentsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllContents(instance.getContents());
      return this;
    }

    /**
     * Adds one element to {@link MultiGetContentsResponse#getContents() contents} list.
     * @param element A contents element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addContents(MultiGetContentsResponse.ContentsWithKey element) {
      this.contents.add(Objects.requireNonNull(element, "contents element"));
      return this;
    }

    /**
     * Adds elements to {@link MultiGetContentsResponse#getContents() contents} list.
     * @param elements An array of contents elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addContents(MultiGetContentsResponse.ContentsWithKey... elements) {
      for (MultiGetContentsResponse.ContentsWithKey element : elements) {
        this.contents.add(Objects.requireNonNull(element, "contents element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MultiGetContentsResponse#getContents() contents} list.
     * @param elements An iterable of contents elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("contents")
    public final Builder contents(Iterable<? extends MultiGetContentsResponse.ContentsWithKey> elements) {
      this.contents.clear();
      return addAllContents(elements);
    }

    /**
     * Adds elements to {@link MultiGetContentsResponse#getContents() contents} list.
     * @param elements An iterable of contents elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllContents(Iterable<? extends MultiGetContentsResponse.ContentsWithKey> elements) {
      for (MultiGetContentsResponse.ContentsWithKey element : elements) {
        this.contents.add(Objects.requireNonNull(element, "contents element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableMultiGetContentsResponse ImmutableMultiGetContentsResponse}.
     * @return An immutable instance of MultiGetContentsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMultiGetContentsResponse build() {
      return new ImmutableMultiGetContentsResponse(createUnmodifiableList(true, contents));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
