package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Operation.Put}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePut.builder()}.
 */
@Generated(from = "Operation.Put", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePut implements Operation.Put {
  private final ContentsKey key;
  private final Contents contents;
  private final @Nullable Contents expectedContents;

  private ImmutablePut(
      ContentsKey key,
      Contents contents,
      @Nullable Contents expectedContents) {
    this.key = key;
    this.contents = contents;
    this.expectedContents = expectedContents;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @JsonProperty("key")
  @Override
  public ContentsKey getKey() {
    return key;
  }

  /**
   * @return The value of the {@code contents} attribute
   */
  @JsonProperty("contents")
  @Override
  public Contents getContents() {
    return contents;
  }

  /**
   * @return The value of the {@code expectedContents} attribute
   */
  @JsonProperty("expectedContents")
  @Override
  public @Nullable Contents getExpectedContents() {
    return expectedContents;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Operation.Put#getKey() key} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePut withKey(ContentsKey value) {
    if (this.key == value) return this;
    ContentsKey newValue = Objects.requireNonNull(value, "key");
    return new ImmutablePut(newValue, this.contents, this.expectedContents);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Operation.Put#getContents() contents} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contents
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePut withContents(Contents value) {
    if (this.contents == value) return this;
    Contents newValue = Objects.requireNonNull(value, "contents");
    return new ImmutablePut(this.key, newValue, this.expectedContents);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Operation.Put#getExpectedContents() expectedContents} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expectedContents (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePut withExpectedContents(@Nullable Contents value) {
    if (this.expectedContents == value) return this;
    return new ImmutablePut(this.key, this.contents, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePut} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePut
        && equalTo((ImmutablePut) another);
  }

  private boolean equalTo(ImmutablePut another) {
    return key.equals(another.key)
        && contents.equals(another.contents)
        && Objects.equals(expectedContents, another.expectedContents);
  }

  /**
   * Computes a hash code from attributes: {@code key}, {@code contents}, {@code expectedContents}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + key.hashCode();
    h += (h << 5) + contents.hashCode();
    h += (h << 5) + Objects.hashCode(expectedContents);
    return h;
  }

  /**
   * Prints the immutable value {@code Put} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Put{"
        + "key=" + key
        + ", contents=" + contents
        + ", expectedContents=" + expectedContents
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Operation.Put", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Operation.Put {
    @Nullable ContentsKey key;
    @Nullable Contents contents;
    @Nullable Contents expectedContents;
    @JsonProperty("key")
    public void setKey(ContentsKey key) {
      this.key = key;
    }
    @JsonProperty("contents")
    public void setContents(Contents contents) {
      this.contents = contents;
    }
    @JsonProperty("expectedContents")
    public void setExpectedContents(@Nullable Contents expectedContents) {
      this.expectedContents = expectedContents;
    }
    @Override
    public ContentsKey getKey() { throw new UnsupportedOperationException(); }
    @Override
    public Contents getContents() { throw new UnsupportedOperationException(); }
    @Override
    public Contents getExpectedContents() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePut fromJson(Json json) {
    ImmutablePut.Builder builder = ImmutablePut.builder();
    if (json.key != null) {
      builder.key(json.key);
    }
    if (json.contents != null) {
      builder.contents(json.contents);
    }
    if (json.expectedContents != null) {
      builder.expectedContents(json.expectedContents);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Operation.Put} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Put instance
   */
  public static ImmutablePut copyOf(Operation.Put instance) {
    if (instance instanceof ImmutablePut) {
      return (ImmutablePut) instance;
    }
    return ImmutablePut.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePut ImmutablePut}.
   * <pre>
   * ImmutablePut.builder()
   *    .key(org.projectnessie.model.ContentsKey) // required {@link Operation.Put#getKey() key}
   *    .contents(org.projectnessie.model.Contents) // required {@link Operation.Put#getContents() contents}
   *    .expectedContents(org.projectnessie.model.Contents | null) // nullable {@link Operation.Put#getExpectedContents() expectedContents}
   *    .build();
   * </pre>
   * @return A new ImmutablePut builder
   */
  public static ImmutablePut.Builder builder() {
    return new ImmutablePut.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePut ImmutablePut}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Operation.Put", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private static final long INIT_BIT_CONTENTS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ContentsKey key;
    private @Nullable Contents contents;
    private @Nullable Contents expectedContents;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Operation} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Operation instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Operation.Put} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Operation.Put instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Operation) {
        Operation instance = (Operation) object;
        key(instance.getKey());
      }
      if (object instanceof Operation.Put) {
        Operation.Put instance = (Operation.Put) object;
        @Nullable Contents expectedContentsValue = instance.getExpectedContents();
        if (expectedContentsValue != null) {
          expectedContents(expectedContentsValue);
        }
        contents(instance.getContents());
      }
    }

    /**
     * Initializes the value for the {@link Operation.Put#getKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("key")
    public final Builder key(ContentsKey key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link Operation.Put#getContents() contents} attribute.
     * @param contents The value for contents 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("contents")
    public final Builder contents(Contents contents) {
      this.contents = Objects.requireNonNull(contents, "contents");
      initBits &= ~INIT_BIT_CONTENTS;
      return this;
    }

    /**
     * Initializes the value for the {@link Operation.Put#getExpectedContents() expectedContents} attribute.
     * @param expectedContents The value for expectedContents (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("expectedContents")
    public final Builder expectedContents(@Nullable Contents expectedContents) {
      this.expectedContents = expectedContents;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePut ImmutablePut}.
     * @return An immutable instance of Put
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePut build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePut(key, contents, expectedContents);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_CONTENTS) != 0) attributes.add("contents");
      return "Cannot build Put, some of required attributes are not set " + attributes;
    }
  }
}
