/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.error;

import java.util.Optional;
import java.util.function.Function;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieContentsNotFoundException;
import org.projectnessie.error.NessieError;
import org.projectnessie.error.NessieReferenceAlreadyExistsException;
import org.projectnessie.error.NessieReferenceConflictException;
import org.projectnessie.error.NessieReferenceNotFoundException;

public enum ErrorCode {
    UNKNOWN(null),
    REFERENCE_NOT_FOUND(NessieReferenceNotFoundException::new),
    REFERENCE_ALREADY_EXISTS(NessieReferenceAlreadyExistsException::new),
    CONTENTS_NOT_FOUND(NessieContentsNotFoundException::new),
    REFERENCE_CONFLICT(NessieReferenceConflictException::new);

    private final Function<NessieError, ? extends BaseNessieClientServerException> exceptionBuilder;

    private <T extends BaseNessieClientServerException> ErrorCode(Function<NessieError, T> exceptionBuilder) {
        this.exceptionBuilder = exceptionBuilder;
    }

    public static Optional<BaseNessieClientServerException> asException(NessieError error) {
        return Optional.ofNullable(error.getErrorCode()).flatMap(e -> Optional.ofNullable(e.exceptionBuilder)).map(b -> (BaseNessieClientServerException)b.apply(error));
    }
}

