/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableNamespace;

@JsonSerialize(as=ImmutableNamespace.class)
@JsonDeserialize(as=ImmutableNamespace.class)
@Value.Immutable
public abstract class Namespace {
    private static final String DOT = ".";
    static final String ERROR_MSG_TEMPLATE = "'%s' is not a valid namespace identifier (should not end with '.')";
    public static final Namespace EMPTY = ImmutableNamespace.builder().name("").build();

    @JsonValue
    @NotNull
    public abstract String name();

    @Value.Redacted
    public boolean isEmpty() {
        return this.name().isEmpty();
    }

    @Value.Redacted
    public String[] getElements() {
        return this.name().split("\\.");
    }

    public static Namespace of(String ... elements) {
        Objects.requireNonNull(elements, "elements must be non-null");
        if (elements.length == 0) {
            return EMPTY;
        }
        if (DOT.equals(elements[elements.length - 1])) {
            throw new IllegalArgumentException(String.format(ERROR_MSG_TEMPLATE, Arrays.toString(elements)));
        }
        String name = String.join((CharSequence)DOT, Arrays.asList(elements));
        return ImmutableNamespace.builder().name(name).build();
    }

    public static Namespace of(List<String> elements) {
        Objects.requireNonNull(elements, "elements must be non-null");
        return Namespace.of(elements.toArray(new String[0]));
    }

    public static Namespace parse(String identifier) {
        Objects.requireNonNull(identifier, "identifier must be non-null");
        if (identifier.isEmpty()) {
            return EMPTY;
        }
        if (identifier.endsWith(DOT)) {
            throw new IllegalArgumentException(String.format(ERROR_MSG_TEMPLATE, identifier));
        }
        return Namespace.of(identifier.split("\\."));
    }
}

