/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.DiscriminatorMapping;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.ImmutableDelete;
import org.projectnessie.model.ImmutablePut;
import org.projectnessie.model.ImmutableUnchanged;

@Schema(type=SchemaType.OBJECT, title="Operation", oneOf={Put.class, Unchanged.class, Delete.class}, discriminatorMapping={@DiscriminatorMapping(value="PUT", schema=Put.class), @DiscriminatorMapping(value="UNCHANGED", schema=Unchanged.class), @DiscriminatorMapping(value="DELETE", schema=Delete.class)}, discriminatorProperty="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Put.class), @JsonSubTypes.Type(value=Delete.class), @JsonSubTypes.Type(value=Unchanged.class)})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public interface Operation {
    @NotNull
    public ContentsKey getKey();

    @JsonSerialize(as=ImmutableUnchanged.class)
    @JsonDeserialize(as=ImmutableUnchanged.class)
    @JsonTypeName(value="UNCHANGED")
    @Value.Immutable
    public static interface Unchanged
    extends Operation {
        public static Unchanged of(ContentsKey key) {
            return ImmutableUnchanged.builder().key(key).build();
        }
    }

    @JsonSerialize(as=ImmutableDelete.class)
    @JsonDeserialize(as=ImmutableDelete.class)
    @JsonTypeName(value="DELETE")
    @Value.Immutable
    public static interface Delete
    extends Operation {
        public static Delete of(ContentsKey key) {
            return ImmutableDelete.builder().key(key).build();
        }
    }

    @Schema(type=SchemaType.OBJECT, title="Put-'Contents'-operation for a 'ContentsKey'.", description="Add or replace (put) a 'Contents' object for a 'ContentsKey'. If the actual table type tracks the 'global state' of individual tables (Iceberg as of today), every 'Put'-operation must contain a non-null value for 'expectedContents'.")
    @JsonSerialize(as=ImmutablePut.class)
    @JsonDeserialize(as=ImmutablePut.class)
    @JsonTypeName(value="PUT")
    @Value.Immutable
    public static interface Put
    extends Operation {
        @NotNull
        public Contents getContents();

        @Nullable
        public Contents getExpectedContents();

        public static Put of(ContentsKey key, Contents contents) {
            return ImmutablePut.builder().key(key).contents(contents).build();
        }

        public static Put of(ContentsKey key, Contents contents, Contents expectedContents) {
            return ImmutablePut.builder().key(key).contents(contents).expectedContents(expectedContents).build();
        }
    }
}

