package org.projectnessie.error;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NessieError}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNessieError.builder()}.
 */
@Generated(from = "NessieError", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNessieError implements NessieError {
  private final int status;
  private final String reason;
  private final String message;
  private final ErrorCode errorCode;
  private final @Nullable String serverStackTrace;
  private final @Nullable Exception clientProcessingException;

  private ImmutableNessieError(ImmutableNessieError.Builder builder) {
    this.status = builder.status;
    this.reason = builder.reason;
    this.serverStackTrace = builder.serverStackTrace;
    this.clientProcessingException = builder.clientProcessingException;
    if (builder.message != null) {
      initShim.message(builder.message);
    }
    if (builder.errorCode != null) {
      initShim.errorCode(builder.errorCode);
    }
    this.message = initShim.getMessage();
    this.errorCode = initShim.getErrorCode();
    this.initShim = null;
  }

  private ImmutableNessieError(
      int status,
      String reason,
      String message,
      ErrorCode errorCode,
      @Nullable String serverStackTrace,
      @Nullable Exception clientProcessingException) {
    this.status = status;
    this.reason = reason;
    this.message = message;
    this.errorCode = errorCode;
    this.serverStackTrace = serverStackTrace;
    this.clientProcessingException = clientProcessingException;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "NessieError", generator = "Immutables")
  private final class InitShim {
    private byte messageBuildStage = STAGE_UNINITIALIZED;
    private String message;

    String getMessage() {
      if (messageBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (messageBuildStage == STAGE_UNINITIALIZED) {
        messageBuildStage = STAGE_INITIALIZING;
        this.message = Objects.requireNonNull(getMessageInitialize(), "message");
        messageBuildStage = STAGE_INITIALIZED;
      }
      return this.message;
    }

    void message(String message) {
      this.message = message;
      messageBuildStage = STAGE_INITIALIZED;
    }

    private byte errorCodeBuildStage = STAGE_UNINITIALIZED;
    private ErrorCode errorCode;

    ErrorCode getErrorCode() {
      if (errorCodeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (errorCodeBuildStage == STAGE_UNINITIALIZED) {
        errorCodeBuildStage = STAGE_INITIALIZING;
        this.errorCode = Objects.requireNonNull(getErrorCodeInitialize(), "errorCode");
        errorCodeBuildStage = STAGE_INITIALIZED;
      }
      return this.errorCode;
    }

    void errorCode(ErrorCode errorCode) {
      this.errorCode = errorCode;
      errorCodeBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (messageBuildStage == STAGE_INITIALIZING) attributes.add("message");
      if (errorCodeBuildStage == STAGE_INITIALIZING) attributes.add("errorCode");
      return "Cannot build NessieError, attribute initializers form cycle " + attributes;
    }
  }

  private String getMessageInitialize() {
    return NessieError.super.getMessage();
  }

  private ErrorCode getErrorCodeInitialize() {
    return NessieError.super.getErrorCode();
  }

  /**
   *HTTP status code of this error. 
   */
  @JsonProperty("status")
  @Override
  public int getStatus() {
    return status;
  }

  /**
   *Reason phrase for the HTTP status code. 
   */
  @JsonProperty("reason")
  @Override
  public String getReason() {
    return reason;
  }

  /**
   *Nessie-specific Error message. 
   */
  @JsonProperty("message")
  @Override
  public String getMessage() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMessage()
        : this.message;
  }

  /**
   *Nessie-specific error code. 
   */
  @JsonProperty("errorCode")
  @Override
  public ErrorCode getErrorCode() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getErrorCode()
        : this.errorCode;
  }

  /**
   *Server-side exception stack trace related to this error (if available). 
   */
  @JsonProperty("serverStackTrace")
  @Override
  public @Nullable String getServerStackTrace() {
    return serverStackTrace;
  }

  /**
   * Client-side {@link Exception} related to the processing of the error response.
   * <p>This {@link Exception} generally represents any errors related to the decoding of the
   * payload returned by the server to describe the error.
   */
  @JsonProperty("clientProcessingException")
  @JsonIgnore
  @Override
  public @Nullable Exception getClientProcessingException() {
    return clientProcessingException;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NessieError#getStatus() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNessieError withStatus(int value) {
    if (this.status == value) return this;
    return new ImmutableNessieError(
        value,
        this.reason,
        this.message,
        this.errorCode,
        this.serverStackTrace,
        this.clientProcessingException);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NessieError#getReason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNessieError withReason(String value) {
    String newValue = Objects.requireNonNull(value, "reason");
    if (this.reason.equals(newValue)) return this;
    return new ImmutableNessieError(
        this.status,
        newValue,
        this.message,
        this.errorCode,
        this.serverStackTrace,
        this.clientProcessingException);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NessieError#getMessage() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNessieError withMessage(String value) {
    String newValue = Objects.requireNonNull(value, "message");
    if (this.message.equals(newValue)) return this;
    return new ImmutableNessieError(
        this.status,
        this.reason,
        newValue,
        this.errorCode,
        this.serverStackTrace,
        this.clientProcessingException);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NessieError#getErrorCode() errorCode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNessieError withErrorCode(ErrorCode value) {
    if (this.errorCode == value) return this;
    ErrorCode newValue = Objects.requireNonNull(value, "errorCode");
    if (this.errorCode.equals(newValue)) return this;
    return new ImmutableNessieError(
        this.status,
        this.reason,
        this.message,
        newValue,
        this.serverStackTrace,
        this.clientProcessingException);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NessieError#getServerStackTrace() serverStackTrace} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serverStackTrace (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNessieError withServerStackTrace(@Nullable String value) {
    if (Objects.equals(this.serverStackTrace, value)) return this;
    return new ImmutableNessieError(this.status, this.reason, this.message, this.errorCode, value, this.clientProcessingException);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NessieError#getClientProcessingException() clientProcessingException} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientProcessingException (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNessieError withClientProcessingException(@Nullable Exception value) {
    if (this.clientProcessingException == value) return this;
    return new ImmutableNessieError(this.status, this.reason, this.message, this.errorCode, this.serverStackTrace, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNessieError} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNessieError
        && equalTo((ImmutableNessieError) another);
  }

  private boolean equalTo(ImmutableNessieError another) {
    return status == another.status
        && reason.equals(another.reason)
        && message.equals(another.message)
        && errorCode.equals(another.errorCode)
        && Objects.equals(serverStackTrace, another.serverStackTrace);
  }

  /**
   * Computes a hash code from attributes: {@code status}, {@code reason}, {@code message}, {@code errorCode}, {@code serverStackTrace}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + status;
    h += (h << 5) + reason.hashCode();
    h += (h << 5) + message.hashCode();
    h += (h << 5) + errorCode.hashCode();
    h += (h << 5) + Objects.hashCode(serverStackTrace);
    return h;
  }

  /**
   * Prints the immutable value {@code NessieError} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NessieError{"
        + "status=" + status
        + ", reason=" + reason
        + ", message=" + message
        + ", errorCode=" + errorCode
        + ", serverStackTrace=" + serverStackTrace
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "NessieError", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements NessieError {
    int status;
    boolean statusIsSet;
    @Nullable String reason;
    @Nullable String message;
    @Nullable ErrorCode errorCode;
    @Nullable String serverStackTrace;
    @Nullable Exception clientProcessingException;
    @JsonProperty("status")
    public void setStatus(int status) {
      this.status = status;
      this.statusIsSet = true;
    }
    @JsonProperty("reason")
    public void setReason(String reason) {
      this.reason = reason;
    }
    @JsonProperty("message")
    public void setMessage(String message) {
      this.message = message;
    }
    @JsonProperty("errorCode")
    public void setErrorCode(ErrorCode errorCode) {
      this.errorCode = errorCode;
    }
    @JsonProperty("serverStackTrace")
    public void setServerStackTrace(@Nullable String serverStackTrace) {
      this.serverStackTrace = serverStackTrace;
    }
    @JsonProperty("clientProcessingException")
    @JsonIgnore
    public void setClientProcessingException(@Nullable Exception clientProcessingException) {
      this.clientProcessingException = clientProcessingException;
    }
    @Override
    public int getStatus() { throw new UnsupportedOperationException(); }
    @Override
    public String getReason() { throw new UnsupportedOperationException(); }
    @Override
    public String getMessage() { throw new UnsupportedOperationException(); }
    @Override
    public ErrorCode getErrorCode() { throw new UnsupportedOperationException(); }
    @Override
    public String getServerStackTrace() { throw new UnsupportedOperationException(); }
    @Override
    public Exception getClientProcessingException() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableNessieError fromJson(Json json) {
    ImmutableNessieError.Builder builder = ImmutableNessieError.builder();
    if (json.statusIsSet) {
      builder.status(json.status);
    }
    if (json.reason != null) {
      builder.reason(json.reason);
    }
    if (json.message != null) {
      builder.message(json.message);
    }
    if (json.errorCode != null) {
      builder.errorCode(json.errorCode);
    }
    if (json.serverStackTrace != null) {
      builder.serverStackTrace(json.serverStackTrace);
    }
    if (json.clientProcessingException != null) {
      builder.clientProcessingException(json.clientProcessingException);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link NessieError} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NessieError instance
   */
  public static ImmutableNessieError copyOf(NessieError instance) {
    if (instance instanceof ImmutableNessieError) {
      return (ImmutableNessieError) instance;
    }
    return ImmutableNessieError.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNessieError ImmutableNessieError}.
   * <pre>
   * ImmutableNessieError.builder()
   *    .status(int) // required {@link NessieError#getStatus() status}
   *    .reason(String) // required {@link NessieError#getReason() reason}
   *    .message(String) // optional {@link NessieError#getMessage() message}
   *    .errorCode(org.projectnessie.error.ErrorCode) // optional {@link NessieError#getErrorCode() errorCode}
   *    .serverStackTrace(String | null) // nullable {@link NessieError#getServerStackTrace() serverStackTrace}
   *    .clientProcessingException(Exception | null) // nullable {@link NessieError#getClientProcessingException() clientProcessingException}
   *    .build();
   * </pre>
   * @return A new ImmutableNessieError builder
   */
  public static ImmutableNessieError.Builder builder() {
    return new ImmutableNessieError.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNessieError ImmutableNessieError}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NessieError", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_STATUS = 0x1L;
    private static final long INIT_BIT_REASON = 0x2L;
    private long initBits = 0x3L;

    private int status;
    private @Nullable String reason;
    private @Nullable String message;
    private @Nullable ErrorCode errorCode;
    private @Nullable String serverStackTrace;
    private @Nullable Exception clientProcessingException;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NessieError} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NessieError instance) {
      Objects.requireNonNull(instance, "instance");
      status(instance.getStatus());
      reason(instance.getReason());
      message(instance.getMessage());
      errorCode(instance.getErrorCode());
      @Nullable String serverStackTraceValue = instance.getServerStackTrace();
      if (serverStackTraceValue != null) {
        serverStackTrace(serverStackTraceValue);
      }
      @Nullable Exception clientProcessingExceptionValue = instance.getClientProcessingException();
      if (clientProcessingExceptionValue != null) {
        clientProcessingException(clientProcessingExceptionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link NessieError#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("status")
    public final Builder status(int status) {
      this.status = status;
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the value for the {@link NessieError#getReason() reason} attribute.
     * @param reason The value for reason 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("reason")
    public final Builder reason(String reason) {
      this.reason = Objects.requireNonNull(reason, "reason");
      initBits &= ~INIT_BIT_REASON;
      return this;
    }

    /**
     * Initializes the value for the {@link NessieError#getMessage() message} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link NessieError#getMessage() message}.</em>
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("message")
    public final Builder message(String message) {
      this.message = Objects.requireNonNull(message, "message");
      return this;
    }

    /**
     * Initializes the value for the {@link NessieError#getErrorCode() errorCode} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link NessieError#getErrorCode() errorCode}.</em>
     * @param errorCode The value for errorCode 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("errorCode")
    public final Builder errorCode(ErrorCode errorCode) {
      this.errorCode = Objects.requireNonNull(errorCode, "errorCode");
      return this;
    }

    /**
     * Initializes the value for the {@link NessieError#getServerStackTrace() serverStackTrace} attribute.
     * @param serverStackTrace The value for serverStackTrace (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("serverStackTrace")
    public final Builder serverStackTrace(@Nullable String serverStackTrace) {
      this.serverStackTrace = serverStackTrace;
      return this;
    }

    /**
     * Initializes the value for the {@link NessieError#getClientProcessingException() clientProcessingException} attribute.
     * @param clientProcessingException The value for clientProcessingException (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("clientProcessingException")
    @JsonIgnore
    public final Builder clientProcessingException(@Nullable Exception clientProcessingException) {
      this.clientProcessingException = clientProcessingException;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNessieError ImmutableNessieError}.
     * @return An immutable instance of NessieError
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNessieError build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNessieError(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      if ((initBits & INIT_BIT_REASON) != 0) attributes.add("reason");
      return "Cannot build NessieError, some of required attributes are not set " + attributes;
    }
  }
}
