package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Branch}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBranch.builder()}.
 */
@Generated(from = "Branch", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBranch implements Branch {
  private final String name;
  private final @Nullable String hash;

  private ImmutableBranch(String name, @Nullable String hash) {
    this.name = name;
    this.hash = hash;
  }

  /**
   *Human readable reference name. 
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   *backend system id. Usually the 32-byte hash of the commit this reference points to. 
   */
  @JsonProperty("hash")
  @Override
  public @Nullable String getHash() {
    return hash;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Branch#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBranch withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return validate(new ImmutableBranch(newValue, this.hash));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Branch#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBranch withHash(@Nullable String value) {
    if (Objects.equals(this.hash, value)) return this;
    return validate(new ImmutableBranch(this.name, value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBranch} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBranch
        && equalTo((ImmutableBranch) another);
  }

  private boolean equalTo(ImmutableBranch another) {
    return name.equals(another.name)
        && Objects.equals(hash, another.hash);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code hash}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(hash);
    return h;
  }

  /**
   * Prints the immutable value {@code Branch} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Branch{"
        + "name=" + name
        + ", hash=" + hash
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Branch", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Branch {
    @Nullable String name;
    @Nullable String hash;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("hash")
    public void setHash(@Nullable String hash) {
      this.hash = hash;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableBranch fromJson(Json json) {
    ImmutableBranch.Builder builder = ImmutableBranch.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    return builder.build();
  }

  private static ImmutableBranch validate(ImmutableBranch instance) {
    instance.checkName();
    instance.checkHash();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Branch} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Branch instance
   */
  public static ImmutableBranch copyOf(Branch instance) {
    if (instance instanceof ImmutableBranch) {
      return (ImmutableBranch) instance;
    }
    return ImmutableBranch.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBranch ImmutableBranch}.
   * <pre>
   * ImmutableBranch.builder()
   *    .name(String) // required {@link Branch#getName() name}
   *    .hash(String | null) // nullable {@link Branch#getHash() hash}
   *    .build();
   * </pre>
   * @return A new ImmutableBranch builder
   */
  public static ImmutableBranch.Builder builder() {
    return new ImmutableBranch.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBranch ImmutableBranch}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Branch", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private @Nullable String hash;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Reference} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Reference instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Branch} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Branch instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Reference) {
        Reference instance = (Reference) object;
        name(instance.getName());
        @Nullable String hashValue = instance.getHash();
        if (hashValue != null) {
          hash(hashValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link Branch#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Branch#getHash() hash} attribute.
     * @param hash The value for hash (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hash")
    public final Builder hash(@Nullable String hash) {
      this.hash = hash;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBranch ImmutableBranch}.
     * @return An immutable instance of Branch
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBranch build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableBranch.validate(new ImmutableBranch(name, hash));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Branch, some of required attributes are not set " + attributes;
    }
  }
}
