/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.validation.constraints.Pattern;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;

public class CommitLogParams {
    @Nullable
    @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes")
    @Parameter(description="Hash on the given ref to start from (in chronological sense), the 'far' end of the commit log, returned 'late' in the result.", examples={@ExampleObject(ref="nullHash"), @ExampleObject(ref="hash")})
    @QueryParam(value="startHash")
    private @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String startHash;
    @Nullable
    @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes")
    @Parameter(description="Hash on the given ref to end at (in chronological sense), the 'near' end of the commit log, returned 'early' in the result.", examples={@ExampleObject(ref="nullHash"), @ExampleObject(ref="hash")})
    @QueryParam(value="endHash")
    private @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String endHash;
    @Parameter(description="maximum number of commit-log entries to return, just a hint for the server")
    @QueryParam(value="max")
    private Integer maxRecords;
    @Parameter(description="pagination continuation token, as returned in the previous LogResponse.token")
    @QueryParam(value="pageToken")
    private String pageToken;
    @Parameter(description="A Common Expression Language (CEL) expression. An intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\nUsable variables within the expression are 'commit.author' (string) / 'commit.committer' (string) / 'commit.commitTime' (timestamp) / 'commit.hash' (string) / 'commit.message' (string) / 'commit.properties' (map)", examples={@ExampleObject(ref="expr_by_commit_author"), @ExampleObject(ref="expr_by_commit_committer"), @ExampleObject(ref="expr_by_commitTime")})
    @QueryParam(value="query_expression")
    private String queryExpression;

    public CommitLogParams() {
    }

    private CommitLogParams(String startHash, String endHash, Integer maxRecords, String pageToken, String queryExpression) {
        this.startHash = startHash;
        this.endHash = endHash;
        this.maxRecords = maxRecords;
        this.pageToken = pageToken;
        this.queryExpression = queryExpression;
    }

    private CommitLogParams(Builder builder) {
        this(builder.startHash, builder.endHash, builder.maxRecords, builder.pageToken, builder.queryExpression);
    }

    @Nullable
    public String startHash() {
        return this.startHash;
    }

    @Nullable
    public String endHash() {
        return this.endHash;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public String queryExpression() {
        return this.queryExpression;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CommitLogParams empty() {
        return new Builder().build();
    }

    public String toString() {
        return new StringJoiner(", ", CommitLogParams.class.getSimpleName() + "[", "]").add("startHash='" + this.startHash + "'").add("endHash='" + this.endHash + "'").add("maxRecords=" + this.maxRecords).add("pageToken='" + this.pageToken + "'").add("queryExpression='" + this.queryExpression + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitLogParams that = (CommitLogParams)o;
        return Objects.equals(this.startHash, that.startHash) && Objects.equals(this.endHash, that.endHash) && Objects.equals(this.maxRecords, that.maxRecords) && Objects.equals(this.pageToken, that.pageToken) && Objects.equals(this.queryExpression, that.queryExpression);
    }

    public int hashCode() {
        return Objects.hash(this.startHash, this.endHash, this.maxRecords, this.pageToken, this.queryExpression);
    }

    public static class Builder {
        private String startHash;
        private String endHash;
        private Integer maxRecords;
        private String pageToken;
        private String queryExpression;

        private Builder() {
        }

        public Builder startHash(String startHash) {
            this.startHash = startHash;
            return this;
        }

        public Builder endHash(String endHash) {
            this.endHash = endHash;
            return this;
        }

        public Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public Builder expression(String queryExpression) {
            this.queryExpression = queryExpression;
            return this;
        }

        public Builder from(CommitLogParams params) {
            return this.startHash(params.startHash).endHash(params.endHash).maxRecords(params.maxRecords).pageToken(params.pageToken).expression(params.queryExpression);
        }

        private void validate() {
        }

        public CommitLogParams build() {
            this.validate();
            return new CommitLogParams(this);
        }
    }
}

