/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ImmutableIcebergTable;

@Schema(type=SchemaType.OBJECT, title="Iceberg table global state", description="Represents the global state of an Iceberg table in Nessie. An Iceberg table is globally identified via its unique 'Contents.id'.\n\nA Nessie commit-operation, performed via 'TreeApi.commitMultipleOperations', for Iceberg for Iceberg consists of a 'Operation.Put' with an 'IcebergTable' as in the 'contents' field and the previous value of 'IcebergTable' in the 'expectedContetns' field.\n\nDuring a commit-operation, Nessie checks whether the known global state of the Iceberg table is compatible (think: equal) to 'Operation.Put.expectedContents'.")
@JsonSerialize(as=ImmutableIcebergTable.class)
@JsonDeserialize(as=ImmutableIcebergTable.class)
@JsonTypeName(value="ICEBERG_TABLE")
@Value.Immutable
public abstract class IcebergTable
extends Contents {
    @NotNull
    @NotBlank
    public abstract String getMetadataLocation();

    public abstract String getIdGenerators();

    public static IcebergTable of(String metadataLocation, String idGenerators) {
        return ImmutableIcebergTable.builder().metadataLocation(metadataLocation).idGenerators(idGenerators).build();
    }

    public static IcebergTable of(String metadataLocation, String idGenerators, String contentsId) {
        return ImmutableIcebergTable.builder().metadataLocation(metadataLocation).idGenerators(idGenerators).id(contentsId).build();
    }
}

