package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EntriesResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEntriesResponse.builder()}.
 */
@Generated(from = "EntriesResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableEntriesResponse implements EntriesResponse {
  private final boolean isHasMore;
  private final @Nullable String token;
  private final List<EntriesResponse.Entry> entries;

  private ImmutableEntriesResponse(ImmutableEntriesResponse.Builder builder) {
    this.token = builder.token;
    this.entries = createUnmodifiableList(true, builder.entries);
    this.isHasMore = builder.isHasMoreIsSet()
        ? builder.isHasMore
        : EntriesResponse.super.isHasMore();
  }

  private ImmutableEntriesResponse(
      boolean isHasMore,
      @Nullable String token,
      List<EntriesResponse.Entry> entries) {
    this.isHasMore = isHasMore;
    this.token = token;
    this.entries = entries;
  }

  /**
   * Whether there are more result-items than returned by this response object.
   * <p>If there are more result-items, the value returned by {@link #getToken()} can be used in the
   * next invocation to get the next "page" of results.
   * @return {@code true}, if there are more result items.
   */
  @JsonProperty("hasMore")
  @Override
  public boolean isHasMore() {
    return isHasMore;
  }

  /**
   * Pass this value to the next invocation of the API function to get the next page of results.
   * <p>Paging tokens are opaque and the structure may change without prior notice even in patch
   * releases.
   * @return paging-token for the next invocation of an API function, if {@link #isHasMore()} is
   *     {@code true}. Undefined, if {@link #isHasMore()} is {@code false}.
   */
  @JsonProperty("token")
  @Override
  public @Nullable String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code entries} attribute
   */
  @JsonProperty("entries")
  @Override
  public List<EntriesResponse.Entry> getEntries() {
    return entries;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EntriesResponse#isHasMore() isHasMore} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isHasMore
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEntriesResponse withIsHasMore(boolean value) {
    if (this.isHasMore == value) return this;
    return new ImmutableEntriesResponse(value, this.token, this.entries);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EntriesResponse#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for token (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEntriesResponse withToken(@Nullable String value) {
    if (Objects.equals(this.token, value)) return this;
    return new ImmutableEntriesResponse(this.isHasMore, value, this.entries);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EntriesResponse#getEntries() entries}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEntriesResponse withEntries(EntriesResponse.Entry... elements) {
    List<EntriesResponse.Entry> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableEntriesResponse(this.isHasMore, this.token, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EntriesResponse#getEntries() entries}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of entries elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEntriesResponse withEntries(Iterable<? extends EntriesResponse.Entry> elements) {
    if (this.entries == elements) return this;
    List<EntriesResponse.Entry> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableEntriesResponse(this.isHasMore, this.token, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEntriesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEntriesResponse
        && equalTo((ImmutableEntriesResponse) another);
  }

  private boolean equalTo(ImmutableEntriesResponse another) {
    return isHasMore == another.isHasMore
        && Objects.equals(token, another.token)
        && entries.equals(another.entries);
  }

  /**
   * Computes a hash code from attributes: {@code isHasMore}, {@code token}, {@code entries}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Boolean.hashCode(isHasMore);
    h += (h << 5) + Objects.hashCode(token);
    h += (h << 5) + entries.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EntriesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EntriesResponse{"
        + "isHasMore=" + isHasMore
        + ", token=" + token
        + ", entries=" + entries
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "EntriesResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements EntriesResponse {
    boolean isHasMore;
    boolean isHasMoreIsSet;
    @Nullable String token;
    @Nullable List<EntriesResponse.Entry> entries = Collections.emptyList();
    @JsonProperty("hasMore")
    public void setIsHasMore(boolean isHasMore) {
      this.isHasMore = isHasMore;
      this.isHasMoreIsSet = true;
    }
    @JsonProperty("token")
    public void setToken(@Nullable String token) {
      this.token = token;
    }
    @JsonProperty("entries")
    public void setEntries(List<EntriesResponse.Entry> entries) {
      this.entries = entries;
    }
    @Override
    public boolean isHasMore() { throw new UnsupportedOperationException(); }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public List<EntriesResponse.Entry> getEntries() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableEntriesResponse fromJson(Json json) {
    ImmutableEntriesResponse.Builder builder = ImmutableEntriesResponse.builder();
    if (json.isHasMoreIsSet) {
      builder.isHasMore(json.isHasMore);
    }
    if (json.token != null) {
      builder.token(json.token);
    }
    if (json.entries != null) {
      builder.addAllEntries(json.entries);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link EntriesResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EntriesResponse instance
   */
  public static ImmutableEntriesResponse copyOf(EntriesResponse instance) {
    if (instance instanceof ImmutableEntriesResponse) {
      return (ImmutableEntriesResponse) instance;
    }
    return ImmutableEntriesResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEntriesResponse ImmutableEntriesResponse}.
   * <pre>
   * ImmutableEntriesResponse.builder()
   *    .isHasMore(boolean) // optional {@link EntriesResponse#isHasMore() isHasMore}
   *    .token(String | null) // nullable {@link EntriesResponse#getToken() token}
   *    .addEntries|addAllEntries(org.projectnessie.model.EntriesResponse.Entry) // {@link EntriesResponse#getEntries() entries} elements
   *    .build();
   * </pre>
   * @return A new ImmutableEntriesResponse builder
   */
  public static ImmutableEntriesResponse.Builder builder() {
    return new ImmutableEntriesResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEntriesResponse ImmutableEntriesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EntriesResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_IS_HAS_MORE = 0x1L;
    private long optBits;

    private boolean isHasMore;
    private @Nullable String token;
    private List<EntriesResponse.Entry> entries = new ArrayList<EntriesResponse.Entry>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.PaginatedResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PaginatedResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.EntriesResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(EntriesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedResponse) {
        PaginatedResponse instance = (PaginatedResponse) object;
        isHasMore(instance.isHasMore());
        @Nullable String tokenValue = instance.getToken();
        if (tokenValue != null) {
          token(tokenValue);
        }
      }
      if (object instanceof EntriesResponse) {
        EntriesResponse instance = (EntriesResponse) object;
        addAllEntries(instance.getEntries());
      }
    }

    /**
     * Initializes the value for the {@link EntriesResponse#isHasMore() isHasMore} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link EntriesResponse#isHasMore() isHasMore}.</em>
     * @param isHasMore The value for isHasMore 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hasMore")
    public final Builder isHasMore(boolean isHasMore) {
      this.isHasMore = isHasMore;
      optBits |= OPT_BIT_IS_HAS_MORE;
      return this;
    }

    /**
     * Initializes the value for the {@link EntriesResponse#getToken() token} attribute.
     * @param token The value for token (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("token")
    public final Builder token(@Nullable String token) {
      this.token = token;
      return this;
    }

    /**
     * Adds one element to {@link EntriesResponse#getEntries() entries} list.
     * @param element A entries element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEntries(EntriesResponse.Entry element) {
      this.entries.add(Objects.requireNonNull(element, "entries element"));
      return this;
    }

    /**
     * Adds elements to {@link EntriesResponse#getEntries() entries} list.
     * @param elements An array of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEntries(EntriesResponse.Entry... elements) {
      for (EntriesResponse.Entry element : elements) {
        this.entries.add(Objects.requireNonNull(element, "entries element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link EntriesResponse#getEntries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("entries")
    public final Builder entries(Iterable<? extends EntriesResponse.Entry> elements) {
      this.entries.clear();
      return addAllEntries(elements);
    }

    /**
     * Adds elements to {@link EntriesResponse#getEntries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllEntries(Iterable<? extends EntriesResponse.Entry> elements) {
      for (EntriesResponse.Entry element : elements) {
        this.entries.add(Objects.requireNonNull(element, "entries element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableEntriesResponse ImmutableEntriesResponse}.
     * @return An immutable instance of EntriesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEntriesResponse build() {
      return new ImmutableEntriesResponse(this);
    }

    private boolean isHasMoreIsSet() {
      return (optBits & OPT_BIT_IS_HAS_MORE) != 0;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
