package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GetMultipleContentsResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGetMultipleContentsResponse.builder()}.
 */
@Generated(from = "GetMultipleContentsResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGetMultipleContentsResponse
    implements GetMultipleContentsResponse {
  private final List<GetMultipleContentsResponse.ContentWithKey> contents;

  private ImmutableGetMultipleContentsResponse(List<GetMultipleContentsResponse.ContentWithKey> contents) {
    this.contents = contents;
  }

  /**
   * @return The value of the {@code contents} attribute
   */
  @JsonProperty("contents")
  @Override
  public List<GetMultipleContentsResponse.ContentWithKey> getContents() {
    return contents;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GetMultipleContentsResponse#getContents() contents}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetMultipleContentsResponse withContents(GetMultipleContentsResponse.ContentWithKey... elements) {
    List<GetMultipleContentsResponse.ContentWithKey> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableGetMultipleContentsResponse(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GetMultipleContentsResponse#getContents() contents}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of contents elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetMultipleContentsResponse withContents(Iterable<? extends GetMultipleContentsResponse.ContentWithKey> elements) {
    if (this.contents == elements) return this;
    List<GetMultipleContentsResponse.ContentWithKey> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableGetMultipleContentsResponse(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGetMultipleContentsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGetMultipleContentsResponse
        && equalTo((ImmutableGetMultipleContentsResponse) another);
  }

  private boolean equalTo(ImmutableGetMultipleContentsResponse another) {
    return contents.equals(another.contents);
  }

  /**
   * Computes a hash code from attributes: {@code contents}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + contents.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetMultipleContentsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetMultipleContentsResponse{"
        + "contents=" + contents
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "GetMultipleContentsResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements GetMultipleContentsResponse {
    @Nullable List<GetMultipleContentsResponse.ContentWithKey> contents = Collections.emptyList();
    @JsonProperty("contents")
    public void setContents(List<GetMultipleContentsResponse.ContentWithKey> contents) {
      this.contents = contents;
    }
    @Override
    public List<GetMultipleContentsResponse.ContentWithKey> getContents() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableGetMultipleContentsResponse fromJson(Json json) {
    ImmutableGetMultipleContentsResponse.Builder builder = ImmutableGetMultipleContentsResponse.builder();
    if (json.contents != null) {
      builder.addAllContents(json.contents);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link GetMultipleContentsResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GetMultipleContentsResponse instance
   */
  public static ImmutableGetMultipleContentsResponse copyOf(GetMultipleContentsResponse instance) {
    if (instance instanceof ImmutableGetMultipleContentsResponse) {
      return (ImmutableGetMultipleContentsResponse) instance;
    }
    return ImmutableGetMultipleContentsResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGetMultipleContentsResponse ImmutableGetMultipleContentsResponse}.
   * <pre>
   * ImmutableGetMultipleContentsResponse.builder()
   *    .addContents|addAllContents(org.projectnessie.model.GetMultipleContentsResponse.ContentWithKey) // {@link GetMultipleContentsResponse#getContents() contents} elements
   *    .build();
   * </pre>
   * @return A new ImmutableGetMultipleContentsResponse builder
   */
  public static ImmutableGetMultipleContentsResponse.Builder builder() {
    return new ImmutableGetMultipleContentsResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGetMultipleContentsResponse ImmutableGetMultipleContentsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GetMultipleContentsResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<GetMultipleContentsResponse.ContentWithKey> contents = new ArrayList<GetMultipleContentsResponse.ContentWithKey>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetMultipleContentsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GetMultipleContentsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllContents(instance.getContents());
      return this;
    }

    /**
     * Adds one element to {@link GetMultipleContentsResponse#getContents() contents} list.
     * @param element A contents element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addContents(GetMultipleContentsResponse.ContentWithKey element) {
      this.contents.add(Objects.requireNonNull(element, "contents element"));
      return this;
    }

    /**
     * Adds elements to {@link GetMultipleContentsResponse#getContents() contents} list.
     * @param elements An array of contents elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addContents(GetMultipleContentsResponse.ContentWithKey... elements) {
      for (GetMultipleContentsResponse.ContentWithKey element : elements) {
        this.contents.add(Objects.requireNonNull(element, "contents element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetMultipleContentsResponse#getContents() contents} list.
     * @param elements An iterable of contents elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("contents")
    public final Builder contents(Iterable<? extends GetMultipleContentsResponse.ContentWithKey> elements) {
      this.contents.clear();
      return addAllContents(elements);
    }

    /**
     * Adds elements to {@link GetMultipleContentsResponse#getContents() contents} list.
     * @param elements An iterable of contents elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllContents(Iterable<? extends GetMultipleContentsResponse.ContentWithKey> elements) {
      for (GetMultipleContentsResponse.ContentWithKey element : elements) {
        this.contents.add(Objects.requireNonNull(element, "contents element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableGetMultipleContentsResponse ImmutableGetMultipleContentsResponse}.
     * @return An immutable instance of GetMultipleContentsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGetMultipleContentsResponse build() {
      return new ImmutableGetMultipleContentsResponse(createUnmodifiableList(true, contents));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
