package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeltaLakeTable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeltaLakeTable.builder()}.
 */
@Generated(from = "DeltaLakeTable", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDeltaLakeTable extends DeltaLakeTable {
  private final String id;
  private final List<String> metadataLocationHistory;
  private final List<String> checkpointLocationHistory;
  private final @Nullable String lastCheckpoint;

  private ImmutableDeltaLakeTable(ImmutableDeltaLakeTable.Builder builder) {
    this.metadataLocationHistory = createUnmodifiableList(true, builder.metadataLocationHistory);
    this.checkpointLocationHistory = createUnmodifiableList(true, builder.checkpointLocationHistory);
    this.lastCheckpoint = builder.lastCheckpoint;
    this.id = builder.id != null
        ? builder.id
        : Objects.requireNonNull(super.getId(), "id");
  }

  private ImmutableDeltaLakeTable(
      String id,
      List<String> metadataLocationHistory,
      List<String> checkpointLocationHistory,
      @Nullable String lastCheckpoint) {
    this.id = id;
    this.metadataLocationHistory = metadataLocationHistory;
    this.checkpointLocationHistory = checkpointLocationHistory;
    this.lastCheckpoint = lastCheckpoint;
  }

  /**
   * Unique id for this object.
   * <p>This id is unique for the entire lifetime of this Content object and persists across
   * renames. Two content objects with the same key will have different id.
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code metadataLocationHistory} attribute
   */
  @JsonProperty("metadataLocationHistory")
  @Override
  public List<String> getMetadataLocationHistory() {
    return metadataLocationHistory;
  }

  /**
   * @return The value of the {@code checkpointLocationHistory} attribute
   */
  @JsonProperty("checkpointLocationHistory")
  @Override
  public List<String> getCheckpointLocationHistory() {
    return checkpointLocationHistory;
  }

  /**
   * @return The value of the {@code lastCheckpoint} attribute
   */
  @JsonProperty("lastCheckpoint")
  @Override
  public @Nullable String getLastCheckpoint() {
    return lastCheckpoint;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeltaLakeTable#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeltaLakeTable withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableDeltaLakeTable(newValue, this.metadataLocationHistory, this.checkpointLocationHistory, this.lastCheckpoint);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeltaLakeTable#getMetadataLocationHistory() metadataLocationHistory}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeltaLakeTable withMetadataLocationHistory(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDeltaLakeTable(this.id, newValue, this.checkpointLocationHistory, this.lastCheckpoint);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeltaLakeTable#getMetadataLocationHistory() metadataLocationHistory}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of metadataLocationHistory elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeltaLakeTable withMetadataLocationHistory(Iterable<String> elements) {
    if (this.metadataLocationHistory == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDeltaLakeTable(this.id, newValue, this.checkpointLocationHistory, this.lastCheckpoint);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeltaLakeTable#getCheckpointLocationHistory() checkpointLocationHistory}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeltaLakeTable withCheckpointLocationHistory(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDeltaLakeTable(this.id, this.metadataLocationHistory, newValue, this.lastCheckpoint);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeltaLakeTable#getCheckpointLocationHistory() checkpointLocationHistory}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of checkpointLocationHistory elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeltaLakeTable withCheckpointLocationHistory(Iterable<String> elements) {
    if (this.checkpointLocationHistory == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDeltaLakeTable(this.id, this.metadataLocationHistory, newValue, this.lastCheckpoint);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeltaLakeTable#getLastCheckpoint() lastCheckpoint} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lastCheckpoint (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeltaLakeTable withLastCheckpoint(@Nullable String value) {
    if (Objects.equals(this.lastCheckpoint, value)) return this;
    return new ImmutableDeltaLakeTable(this.id, this.metadataLocationHistory, this.checkpointLocationHistory, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeltaLakeTable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeltaLakeTable
        && equalTo((ImmutableDeltaLakeTable) another);
  }

  private boolean equalTo(ImmutableDeltaLakeTable another) {
    return id.equals(another.id)
        && metadataLocationHistory.equals(another.metadataLocationHistory)
        && checkpointLocationHistory.equals(another.checkpointLocationHistory)
        && Objects.equals(lastCheckpoint, another.lastCheckpoint);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code metadataLocationHistory}, {@code checkpointLocationHistory}, {@code lastCheckpoint}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + metadataLocationHistory.hashCode();
    h += (h << 5) + checkpointLocationHistory.hashCode();
    h += (h << 5) + Objects.hashCode(lastCheckpoint);
    return h;
  }

  /**
   * Prints the immutable value {@code DeltaLakeTable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeltaLakeTable{"
        + "id=" + id
        + ", metadataLocationHistory=" + metadataLocationHistory
        + ", checkpointLocationHistory=" + checkpointLocationHistory
        + ", lastCheckpoint=" + lastCheckpoint
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DeltaLakeTable", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends DeltaLakeTable {
    @Nullable String id;
    @Nullable List<String> metadataLocationHistory = Collections.emptyList();
    @Nullable List<String> checkpointLocationHistory = Collections.emptyList();
    @Nullable String lastCheckpoint;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("metadataLocationHistory")
    public void setMetadataLocationHistory(List<String> metadataLocationHistory) {
      this.metadataLocationHistory = metadataLocationHistory;
    }
    @JsonProperty("checkpointLocationHistory")
    public void setCheckpointLocationHistory(List<String> checkpointLocationHistory) {
      this.checkpointLocationHistory = checkpointLocationHistory;
    }
    @JsonProperty("lastCheckpoint")
    public void setLastCheckpoint(@Nullable String lastCheckpoint) {
      this.lastCheckpoint = lastCheckpoint;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getMetadataLocationHistory() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getCheckpointLocationHistory() { throw new UnsupportedOperationException(); }
    @Override
    public String getLastCheckpoint() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDeltaLakeTable fromJson(Json json) {
    ImmutableDeltaLakeTable.Builder builder = ImmutableDeltaLakeTable.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.metadataLocationHistory != null) {
      builder.addAllMetadataLocationHistory(json.metadataLocationHistory);
    }
    if (json.checkpointLocationHistory != null) {
      builder.addAllCheckpointLocationHistory(json.checkpointLocationHistory);
    }
    if (json.lastCheckpoint != null) {
      builder.lastCheckpoint(json.lastCheckpoint);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DeltaLakeTable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeltaLakeTable instance
   */
  public static ImmutableDeltaLakeTable copyOf(DeltaLakeTable instance) {
    if (instance instanceof ImmutableDeltaLakeTable) {
      return (ImmutableDeltaLakeTable) instance;
    }
    return ImmutableDeltaLakeTable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeltaLakeTable ImmutableDeltaLakeTable}.
   * <pre>
   * ImmutableDeltaLakeTable.builder()
   *    .id(String) // optional {@link DeltaLakeTable#getId() id}
   *    .addMetadataLocationHistory|addAllMetadataLocationHistory(String) // {@link DeltaLakeTable#getMetadataLocationHistory() metadataLocationHistory} elements
   *    .addCheckpointLocationHistory|addAllCheckpointLocationHistory(String) // {@link DeltaLakeTable#getCheckpointLocationHistory() checkpointLocationHistory} elements
   *    .lastCheckpoint(String | null) // nullable {@link DeltaLakeTable#getLastCheckpoint() lastCheckpoint}
   *    .build();
   * </pre>
   * @return A new ImmutableDeltaLakeTable builder
   */
  public static ImmutableDeltaLakeTable.Builder builder() {
    return new ImmutableDeltaLakeTable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeltaLakeTable ImmutableDeltaLakeTable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeltaLakeTable", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String id;
    private List<String> metadataLocationHistory = new ArrayList<String>();
    private List<String> checkpointLocationHistory = new ArrayList<String>();
    private @Nullable String lastCheckpoint;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.DeltaLakeTable} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DeltaLakeTable instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Content} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Content instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof DeltaLakeTable) {
        DeltaLakeTable instance = (DeltaLakeTable) object;
        addAllMetadataLocationHistory(instance.getMetadataLocationHistory());
        @Nullable String lastCheckpointValue = instance.getLastCheckpoint();
        if (lastCheckpointValue != null) {
          lastCheckpoint(lastCheckpointValue);
        }
        addAllCheckpointLocationHistory(instance.getCheckpointLocationHistory());
      }
      if (object instanceof Content) {
        Content instance = (Content) object;
        id(instance.getId());
      }
    }

    /**
     * Initializes the value for the {@link DeltaLakeTable#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DeltaLakeTable#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Adds one element to {@link DeltaLakeTable#getMetadataLocationHistory() metadataLocationHistory} list.
     * @param element A metadataLocationHistory element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMetadataLocationHistory(String element) {
      this.metadataLocationHistory.add(Objects.requireNonNull(element, "metadataLocationHistory element"));
      return this;
    }

    /**
     * Adds elements to {@link DeltaLakeTable#getMetadataLocationHistory() metadataLocationHistory} list.
     * @param elements An array of metadataLocationHistory elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMetadataLocationHistory(String... elements) {
      for (String element : elements) {
        this.metadataLocationHistory.add(Objects.requireNonNull(element, "metadataLocationHistory element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DeltaLakeTable#getMetadataLocationHistory() metadataLocationHistory} list.
     * @param elements An iterable of metadataLocationHistory elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("metadataLocationHistory")
    public final Builder metadataLocationHistory(Iterable<String> elements) {
      this.metadataLocationHistory.clear();
      return addAllMetadataLocationHistory(elements);
    }

    /**
     * Adds elements to {@link DeltaLakeTable#getMetadataLocationHistory() metadataLocationHistory} list.
     * @param elements An iterable of metadataLocationHistory elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMetadataLocationHistory(Iterable<String> elements) {
      for (String element : elements) {
        this.metadataLocationHistory.add(Objects.requireNonNull(element, "metadataLocationHistory element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link DeltaLakeTable#getCheckpointLocationHistory() checkpointLocationHistory} list.
     * @param element A checkpointLocationHistory element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCheckpointLocationHistory(String element) {
      this.checkpointLocationHistory.add(Objects.requireNonNull(element, "checkpointLocationHistory element"));
      return this;
    }

    /**
     * Adds elements to {@link DeltaLakeTable#getCheckpointLocationHistory() checkpointLocationHistory} list.
     * @param elements An array of checkpointLocationHistory elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCheckpointLocationHistory(String... elements) {
      for (String element : elements) {
        this.checkpointLocationHistory.add(Objects.requireNonNull(element, "checkpointLocationHistory element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DeltaLakeTable#getCheckpointLocationHistory() checkpointLocationHistory} list.
     * @param elements An iterable of checkpointLocationHistory elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("checkpointLocationHistory")
    public final Builder checkpointLocationHistory(Iterable<String> elements) {
      this.checkpointLocationHistory.clear();
      return addAllCheckpointLocationHistory(elements);
    }

    /**
     * Adds elements to {@link DeltaLakeTable#getCheckpointLocationHistory() checkpointLocationHistory} list.
     * @param elements An iterable of checkpointLocationHistory elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllCheckpointLocationHistory(Iterable<String> elements) {
      for (String element : elements) {
        this.checkpointLocationHistory.add(Objects.requireNonNull(element, "checkpointLocationHistory element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DeltaLakeTable#getLastCheckpoint() lastCheckpoint} attribute.
     * @param lastCheckpoint The value for lastCheckpoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("lastCheckpoint")
    public final Builder lastCheckpoint(@Nullable String lastCheckpoint) {
      this.lastCheckpoint = lastCheckpoint;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeltaLakeTable ImmutableDeltaLakeTable}.
     * @return An immutable instance of DeltaLakeTable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeltaLakeTable build() {
      return new ImmutableDeltaLakeTable(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
