package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DiffResponse.DiffEntry}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDiffEntry.builder()}.
 */
@Generated(from = "DiffResponse.DiffEntry", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDiffEntry implements DiffResponse.DiffEntry {
  private final ContentKey key;
  private final @Nullable Content from;
  private final @Nullable Content to;

  private ImmutableDiffEntry(
      ContentKey key,
      @Nullable Content from,
      @Nullable Content to) {
    this.key = key;
    this.from = from;
    this.to = to;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @JsonProperty("key")
  @Override
  public ContentKey key() {
    return key;
  }

  /**
   * @return The value of the {@code from} attribute
   */
  @JsonProperty("from")
  @Override
  public @Nullable Content from() {
    return from;
  }

  /**
   * @return The value of the {@code to} attribute
   */
  @JsonProperty("to")
  @Override
  public @Nullable Content to() {
    return to;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DiffResponse.DiffEntry#key() key} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiffEntry withKey(ContentKey value) {
    if (this.key == value) return this;
    ContentKey newValue = Objects.requireNonNull(value, "key");
    return new ImmutableDiffEntry(newValue, this.from, this.to);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DiffResponse.DiffEntry#from() from} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for from (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiffEntry withFrom(@Nullable Content value) {
    if (this.from == value) return this;
    return new ImmutableDiffEntry(this.key, value, this.to);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DiffResponse.DiffEntry#to() to} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for to (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiffEntry withTo(@Nullable Content value) {
    if (this.to == value) return this;
    return new ImmutableDiffEntry(this.key, this.from, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDiffEntry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDiffEntry
        && equalTo((ImmutableDiffEntry) another);
  }

  private boolean equalTo(ImmutableDiffEntry another) {
    return key.equals(another.key)
        && Objects.equals(from, another.from)
        && Objects.equals(to, another.to);
  }

  /**
   * Computes a hash code from attributes: {@code key}, {@code from}, {@code to}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + key.hashCode();
    h += (h << 5) + Objects.hashCode(from);
    h += (h << 5) + Objects.hashCode(to);
    return h;
  }

  /**
   * Prints the immutable value {@code DiffEntry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DiffEntry{"
        + "key=" + key
        + ", from=" + from
        + ", to=" + to
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DiffResponse.DiffEntry", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DiffResponse.DiffEntry {
    @Nullable ContentKey key;
    @Nullable Content from;
    @Nullable Content to;
    @JsonProperty("key")
    public void setKey(ContentKey key) {
      this.key = key;
    }
    @JsonProperty("from")
    public void setFrom(@Nullable Content from) {
      this.from = from;
    }
    @JsonProperty("to")
    public void setTo(@Nullable Content to) {
      this.to = to;
    }
    @Override
    public ContentKey key() { throw new UnsupportedOperationException(); }
    @Override
    public Content from() { throw new UnsupportedOperationException(); }
    @Override
    public Content to() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDiffEntry fromJson(Json json) {
    ImmutableDiffEntry.Builder builder = ImmutableDiffEntry.builder();
    if (json.key != null) {
      builder.key(json.key);
    }
    if (json.from != null) {
      builder.from(json.from);
    }
    if (json.to != null) {
      builder.to(json.to);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DiffResponse.DiffEntry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DiffEntry instance
   */
  public static ImmutableDiffEntry copyOf(DiffResponse.DiffEntry instance) {
    if (instance instanceof ImmutableDiffEntry) {
      return (ImmutableDiffEntry) instance;
    }
    return ImmutableDiffEntry.builder()
        .key(instance.key())
        .from(instance.from())
        .to(instance.to())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDiffEntry ImmutableDiffEntry}.
   * <pre>
   * ImmutableDiffEntry.builder()
   *    .key(org.projectnessie.model.ContentKey) // required {@link DiffResponse.DiffEntry#key() key}
   *    .from(org.projectnessie.model.Content | null) // nullable {@link DiffResponse.DiffEntry#from() from}
   *    .to(org.projectnessie.model.Content | null) // nullable {@link DiffResponse.DiffEntry#to() to}
   *    .build();
   * </pre>
   * @return A new ImmutableDiffEntry builder
   */
  public static ImmutableDiffEntry.Builder builder() {
    return new ImmutableDiffEntry.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDiffEntry ImmutableDiffEntry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DiffResponse.DiffEntry", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ContentKey key;
    private @Nullable Content from;
    private @Nullable Content to;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link DiffResponse.DiffEntry#key() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("key")
    public final Builder key(ContentKey key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link DiffResponse.DiffEntry#from() from} attribute.
     * @param from The value for from (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("from")
    public final Builder from(@Nullable Content from) {
      this.from = from;
      return this;
    }

    /**
     * Initializes the value for the {@link DiffResponse.DiffEntry#to() to} attribute.
     * @param to The value for to (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("to")
    public final Builder to(@Nullable Content to) {
      this.to = to;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDiffEntry ImmutableDiffEntry}.
     * @return An immutable instance of DiffEntry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDiffEntry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDiffEntry(key, from, to);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      return "Cannot build DiffEntry, some of required attributes are not set " + attributes;
    }
  }
}
