package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link IcebergTable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableIcebergTable.builder()}.
 */
@Generated(from = "IcebergTable", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableIcebergTable extends IcebergTable {
  private final String id;
  private final String metadataLocation;
  private final long snapshotId;
  private final int schemaId;
  private final int specId;
  private final int sortOrderId;

  private ImmutableIcebergTable(ImmutableIcebergTable.Builder builder) {
    this.metadataLocation = builder.metadataLocation;
    this.snapshotId = builder.snapshotId;
    this.schemaId = builder.schemaId;
    this.specId = builder.specId;
    this.sortOrderId = builder.sortOrderId;
    this.id = builder.id != null
        ? builder.id
        : Objects.requireNonNull(super.getId(), "id");
  }

  private ImmutableIcebergTable(
      String id,
      String metadataLocation,
      long snapshotId,
      int schemaId,
      int specId,
      int sortOrderId) {
    this.id = id;
    this.metadataLocation = metadataLocation;
    this.snapshotId = snapshotId;
    this.schemaId = schemaId;
    this.specId = specId;
    this.sortOrderId = sortOrderId;
  }

  /**
   * Unique id for this object.
   * <p>This id is unique for the entire lifetime of this Content object and persists across
   * renames. Two content objects with the same key will have different id.
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Location where Iceberg stored its {@code TableMetadata} file. The location depends on the
   * (implementation of) Iceberg's {@code FileIO} configured for the particular Iceberg table.
   */
  @JsonProperty("metadataLocation")
  @Override
  public String getMetadataLocation() {
    return metadataLocation;
  }

  /**
   * @return The value of the {@code snapshotId} attribute
   */
  @JsonProperty("snapshotId")
  @Override
  public long getSnapshotId() {
    return snapshotId;
  }

  /**
   * @return The value of the {@code schemaId} attribute
   */
  @JsonProperty("schemaId")
  @Override
  public int getSchemaId() {
    return schemaId;
  }

  /**
   * @return The value of the {@code specId} attribute
   */
  @JsonProperty("specId")
  @Override
  public int getSpecId() {
    return specId;
  }

  /**
   * @return The value of the {@code sortOrderId} attribute
   */
  @JsonProperty("sortOrderId")
  @Override
  public int getSortOrderId() {
    return sortOrderId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcebergTable#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIcebergTable withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableIcebergTable(newValue, this.metadataLocation, this.snapshotId, this.schemaId, this.specId, this.sortOrderId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcebergTable#getMetadataLocation() metadataLocation} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metadataLocation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIcebergTable withMetadataLocation(String value) {
    String newValue = Objects.requireNonNull(value, "metadataLocation");
    if (this.metadataLocation.equals(newValue)) return this;
    return new ImmutableIcebergTable(this.id, newValue, this.snapshotId, this.schemaId, this.specId, this.sortOrderId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcebergTable#getSnapshotId() snapshotId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for snapshotId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIcebergTable withSnapshotId(long value) {
    if (this.snapshotId == value) return this;
    return new ImmutableIcebergTable(this.id, this.metadataLocation, value, this.schemaId, this.specId, this.sortOrderId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcebergTable#getSchemaId() schemaId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schemaId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIcebergTable withSchemaId(int value) {
    if (this.schemaId == value) return this;
    return new ImmutableIcebergTable(this.id, this.metadataLocation, this.snapshotId, value, this.specId, this.sortOrderId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcebergTable#getSpecId() specId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for specId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIcebergTable withSpecId(int value) {
    if (this.specId == value) return this;
    return new ImmutableIcebergTable(this.id, this.metadataLocation, this.snapshotId, this.schemaId, value, this.sortOrderId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcebergTable#getSortOrderId() sortOrderId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sortOrderId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIcebergTable withSortOrderId(int value) {
    if (this.sortOrderId == value) return this;
    return new ImmutableIcebergTable(this.id, this.metadataLocation, this.snapshotId, this.schemaId, this.specId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIcebergTable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIcebergTable
        && equalTo((ImmutableIcebergTable) another);
  }

  private boolean equalTo(ImmutableIcebergTable another) {
    return id.equals(another.id)
        && metadataLocation.equals(another.metadataLocation)
        && snapshotId == another.snapshotId
        && schemaId == another.schemaId
        && specId == another.specId
        && sortOrderId == another.sortOrderId;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code metadataLocation}, {@code snapshotId}, {@code schemaId}, {@code specId}, {@code sortOrderId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + metadataLocation.hashCode();
    h += (h << 5) + Long.hashCode(snapshotId);
    h += (h << 5) + schemaId;
    h += (h << 5) + specId;
    h += (h << 5) + sortOrderId;
    return h;
  }

  /**
   * Prints the immutable value {@code IcebergTable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "IcebergTable{"
        + "id=" + id
        + ", metadataLocation=" + metadataLocation
        + ", snapshotId=" + snapshotId
        + ", schemaId=" + schemaId
        + ", specId=" + specId
        + ", sortOrderId=" + sortOrderId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "IcebergTable", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends IcebergTable {
    @Nullable String id;
    @Nullable String metadataLocation;
    long snapshotId;
    boolean snapshotIdIsSet;
    int schemaId;
    boolean schemaIdIsSet;
    int specId;
    boolean specIdIsSet;
    int sortOrderId;
    boolean sortOrderIdIsSet;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("metadataLocation")
    public void setMetadataLocation(String metadataLocation) {
      this.metadataLocation = metadataLocation;
    }
    @JsonProperty("snapshotId")
    public void setSnapshotId(long snapshotId) {
      this.snapshotId = snapshotId;
      this.snapshotIdIsSet = true;
    }
    @JsonProperty("schemaId")
    public void setSchemaId(int schemaId) {
      this.schemaId = schemaId;
      this.schemaIdIsSet = true;
    }
    @JsonProperty("specId")
    public void setSpecId(int specId) {
      this.specId = specId;
      this.specIdIsSet = true;
    }
    @JsonProperty("sortOrderId")
    public void setSortOrderId(int sortOrderId) {
      this.sortOrderId = sortOrderId;
      this.sortOrderIdIsSet = true;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getMetadataLocation() { throw new UnsupportedOperationException(); }
    @Override
    public long getSnapshotId() { throw new UnsupportedOperationException(); }
    @Override
    public int getSchemaId() { throw new UnsupportedOperationException(); }
    @Override
    public int getSpecId() { throw new UnsupportedOperationException(); }
    @Override
    public int getSortOrderId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableIcebergTable fromJson(Json json) {
    ImmutableIcebergTable.Builder builder = ImmutableIcebergTable.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.metadataLocation != null) {
      builder.metadataLocation(json.metadataLocation);
    }
    if (json.snapshotIdIsSet) {
      builder.snapshotId(json.snapshotId);
    }
    if (json.schemaIdIsSet) {
      builder.schemaId(json.schemaId);
    }
    if (json.specIdIsSet) {
      builder.specId(json.specId);
    }
    if (json.sortOrderIdIsSet) {
      builder.sortOrderId(json.sortOrderId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link IcebergTable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IcebergTable instance
   */
  public static ImmutableIcebergTable copyOf(IcebergTable instance) {
    if (instance instanceof ImmutableIcebergTable) {
      return (ImmutableIcebergTable) instance;
    }
    return ImmutableIcebergTable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableIcebergTable ImmutableIcebergTable}.
   * <pre>
   * ImmutableIcebergTable.builder()
   *    .id(String) // optional {@link IcebergTable#getId() id}
   *    .metadataLocation(String) // required {@link IcebergTable#getMetadataLocation() metadataLocation}
   *    .snapshotId(long) // required {@link IcebergTable#getSnapshotId() snapshotId}
   *    .schemaId(int) // required {@link IcebergTable#getSchemaId() schemaId}
   *    .specId(int) // required {@link IcebergTable#getSpecId() specId}
   *    .sortOrderId(int) // required {@link IcebergTable#getSortOrderId() sortOrderId}
   *    .build();
   * </pre>
   * @return A new ImmutableIcebergTable builder
   */
  public static ImmutableIcebergTable.Builder builder() {
    return new ImmutableIcebergTable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableIcebergTable ImmutableIcebergTable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IcebergTable", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_METADATA_LOCATION = 0x1L;
    private static final long INIT_BIT_SNAPSHOT_ID = 0x2L;
    private static final long INIT_BIT_SCHEMA_ID = 0x4L;
    private static final long INIT_BIT_SPEC_ID = 0x8L;
    private static final long INIT_BIT_SORT_ORDER_ID = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String id;
    private @Nullable String metadataLocation;
    private long snapshotId;
    private int schemaId;
    private int specId;
    private int sortOrderId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.IcebergTable} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(IcebergTable instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Content} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Content instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IcebergTable) {
        IcebergTable instance = (IcebergTable) object;
        specId(instance.getSpecId());
        sortOrderId(instance.getSortOrderId());
        metadataLocation(instance.getMetadataLocation());
        snapshotId(instance.getSnapshotId());
        schemaId(instance.getSchemaId());
      }
      if (object instanceof Content) {
        Content instance = (Content) object;
        id(instance.getId());
      }
    }

    /**
     * Initializes the value for the {@link IcebergTable#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IcebergTable#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the value for the {@link IcebergTable#getMetadataLocation() metadataLocation} attribute.
     * @param metadataLocation The value for metadataLocation 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("metadataLocation")
    public final Builder metadataLocation(String metadataLocation) {
      this.metadataLocation = Objects.requireNonNull(metadataLocation, "metadataLocation");
      initBits &= ~INIT_BIT_METADATA_LOCATION;
      return this;
    }

    /**
     * Initializes the value for the {@link IcebergTable#getSnapshotId() snapshotId} attribute.
     * @param snapshotId The value for snapshotId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("snapshotId")
    public final Builder snapshotId(long snapshotId) {
      this.snapshotId = snapshotId;
      initBits &= ~INIT_BIT_SNAPSHOT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link IcebergTable#getSchemaId() schemaId} attribute.
     * @param schemaId The value for schemaId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("schemaId")
    public final Builder schemaId(int schemaId) {
      this.schemaId = schemaId;
      initBits &= ~INIT_BIT_SCHEMA_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link IcebergTable#getSpecId() specId} attribute.
     * @param specId The value for specId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("specId")
    public final Builder specId(int specId) {
      this.specId = specId;
      initBits &= ~INIT_BIT_SPEC_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link IcebergTable#getSortOrderId() sortOrderId} attribute.
     * @param sortOrderId The value for sortOrderId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("sortOrderId")
    public final Builder sortOrderId(int sortOrderId) {
      this.sortOrderId = sortOrderId;
      initBits &= ~INIT_BIT_SORT_ORDER_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableIcebergTable ImmutableIcebergTable}.
     * @return An immutable instance of IcebergTable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableIcebergTable build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableIcebergTable(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_METADATA_LOCATION) != 0) attributes.add("metadataLocation");
      if ((initBits & INIT_BIT_SNAPSHOT_ID) != 0) attributes.add("snapshotId");
      if ((initBits & INIT_BIT_SCHEMA_ID) != 0) attributes.add("schemaId");
      if ((initBits & INIT_BIT_SPEC_ID) != 0) attributes.add("specId");
      if ((initBits & INIT_BIT_SORT_ORDER_ID) != 0) attributes.add("sortOrderId");
      return "Cannot build IcebergTable, some of required attributes are not set " + attributes;
    }
  }
}
