package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Namespace}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNamespace.builder()}.
 */
@Generated(from = "Namespace", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNamespace extends Namespace {
  private final String name;

  private ImmutableNamespace(String name) {
    this.name = name;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JsonValue
  @Override
  public String name() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Namespace#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNamespace withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableNamespace(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNamespace} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNamespace
        && equalTo((ImmutableNamespace) another);
  }

  private boolean equalTo(ImmutableNamespace another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Namespace} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Namespace{"
        + "name=" + name
        + "}";
  }

  /**
   * @param jsonValue to construct object from
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableNamespace fromJson(String jsonValue) {
    ImmutableNamespace.Builder builder = ImmutableNamespace.builder();
    builder.name(jsonValue);
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Namespace} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Namespace instance
   */
  public static ImmutableNamespace copyOf(Namespace instance) {
    if (instance instanceof ImmutableNamespace) {
      return (ImmutableNamespace) instance;
    }
    return ImmutableNamespace.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNamespace ImmutableNamespace}.
   * <pre>
   * ImmutableNamespace.builder()
   *    .name(String) // required {@link Namespace#name() name}
   *    .build();
   * </pre>
   * @return A new ImmutableNamespace builder
   */
  public static ImmutableNamespace.Builder builder() {
    return new ImmutableNamespace.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNamespace ImmutableNamespace}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Namespace", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Namespace} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Namespace instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      return this;
    }

    /**
     * Initializes the value for the {@link Namespace#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNamespace ImmutableNamespace}.
     * @return An immutable instance of Namespace
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNamespace build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNamespace(name);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Namespace, some of required attributes are not set " + attributes;
    }
  }
}
