/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.validation.constraints.Pattern;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.projectnessie.api.params.AbstractParams;

public class EntriesParams
extends AbstractParams {
    @Nullable
    @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes")
    @Parameter(description="a particular hash on the given ref", examples={@ExampleObject(ref="nullHash"), @ExampleObject(ref="hash")})
    @QueryParam(value="hashOnRef")
    private @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String hashOnRef;
    @Parameter(description="If set > 0 will filter the results to only return namespaces/tables to the depth of namespaceDepth. If not set or <=0 has no effect\nSetting this parameter > 0 will turn off paging.")
    @QueryParam(value="namespaceDepth")
    private Integer namespaceDepth;
    @Parameter(description="A Common Expression Language (CEL) expression. An intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\nUsable variables within the expression are 'entry.namespace' (string) & 'entry.contentType' (string)", examples={@ExampleObject(ref="expr_by_namespace"), @ExampleObject(ref="expr_by_contentType"), @ExampleObject(ref="expr_by_namespace_and_contentType")})
    @QueryParam(value="query_expression")
    private String queryExpression;

    public EntriesParams() {
    }

    private EntriesParams(String hashOnRef, Integer maxRecords, String pageToken, Integer namespaceDepth, String queryExpression) {
        super(maxRecords, pageToken);
        this.hashOnRef = hashOnRef;
        this.namespaceDepth = namespaceDepth;
        this.queryExpression = queryExpression;
    }

    private EntriesParams(Builder builder) {
        this(builder.hashOnRef, builder.maxRecords, builder.pageToken, builder.namespaceDepth, builder.queryExpression);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static EntriesParams empty() {
        return new Builder().build();
    }

    @Nullable
    public String hashOnRef() {
        return this.hashOnRef;
    }

    public String queryExpression() {
        return this.queryExpression;
    }

    public Integer namespaceDepth() {
        return this.namespaceDepth;
    }

    public String toString() {
        return new StringJoiner(", ", EntriesParams.class.getSimpleName() + "[", "]").add("hashOnRef='" + this.hashOnRef + "'").add("maxRecords=" + this.maxRecords()).add("pageToken='" + this.pageToken() + "'").add("queryExpression='" + this.queryExpression + "'").add("namespaceDepth='" + this.namespaceDepth + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntriesParams that = (EntriesParams)o;
        return Objects.equals(this.hashOnRef, that.hashOnRef) && Objects.equals(this.maxRecords(), that.maxRecords()) && Objects.equals(this.pageToken(), that.pageToken()) && Objects.equals(this.namespaceDepth, that.namespaceDepth) && Objects.equals(this.queryExpression, that.queryExpression);
    }

    public int hashCode() {
        return Objects.hash(this.hashOnRef, this.maxRecords(), this.pageToken(), this.namespaceDepth, this.queryExpression);
    }

    public static class Builder
    extends AbstractParams.Builder<Builder> {
        private String hashOnRef;
        private String queryExpression;
        private Integer namespaceDepth;

        private Builder() {
        }

        public Builder hashOnRef(String hashOnRef) {
            this.hashOnRef = hashOnRef;
            return this;
        }

        public Builder expression(String queryExpression) {
            this.queryExpression = queryExpression;
            return this;
        }

        public Builder namespaceDepth(Integer namespaceDepth) {
            this.namespaceDepth = namespaceDepth;
            return this;
        }

        public Builder from(EntriesParams params) {
            return ((Builder)((Builder)this.hashOnRef(params.hashOnRef).maxRecords(params.maxRecords())).pageToken(params.pageToken())).namespaceDepth(params.namespaceDepth).expression(params.queryExpression);
        }

        private void validate() {
        }

        public EntriesParams build() {
            this.validate();
            return new EntriesParams(this);
        }
    }
}

