/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ReferenceMetadata;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReferenceMetadata", generator="Immutables")
@Immutable
public final class ImmutableReferenceMetadata
implements ReferenceMetadata {
    @Nullable
    private final Integer numCommitsAhead;
    @Nullable
    private final Integer numCommitsBehind;
    @Nullable
    private final CommitMeta commitMetaOfHEAD;
    @Nullable
    private final String commonAncestorHash;
    @Nullable
    private final Long numTotalCommits;

    private ImmutableReferenceMetadata(@Nullable Integer numCommitsAhead, @Nullable Integer numCommitsBehind, @Nullable CommitMeta commitMetaOfHEAD, @Nullable String commonAncestorHash, @Nullable Long numTotalCommits) {
        this.numCommitsAhead = numCommitsAhead;
        this.numCommitsBehind = numCommitsBehind;
        this.commitMetaOfHEAD = commitMetaOfHEAD;
        this.commonAncestorHash = commonAncestorHash;
        this.numTotalCommits = numTotalCommits;
    }

    @Override
    @JsonProperty(value="numCommitsAhead")
    @Nullable
    public Integer numCommitsAhead() {
        return this.numCommitsAhead;
    }

    @Override
    @JsonProperty(value="numCommitsBehind")
    @Nullable
    public Integer numCommitsBehind() {
        return this.numCommitsBehind;
    }

    @Override
    @JsonProperty(value="commitMetaOfHEAD")
    @Nullable
    public CommitMeta commitMetaOfHEAD() {
        return this.commitMetaOfHEAD;
    }

    @Override
    @JsonProperty(value="commonAncestorHash")
    @Nullable
    public String commonAncestorHash() {
        return this.commonAncestorHash;
    }

    @Override
    @JsonProperty(value="numTotalCommits")
    @Nullable
    public Long numTotalCommits() {
        return this.numTotalCommits;
    }

    public final ImmutableReferenceMetadata withNumCommitsAhead(@Nullable Integer value) {
        if (Objects.equals(this.numCommitsAhead, value)) {
            return this;
        }
        return new ImmutableReferenceMetadata(value, this.numCommitsBehind, this.commitMetaOfHEAD, this.commonAncestorHash, this.numTotalCommits);
    }

    public final ImmutableReferenceMetadata withNumCommitsBehind(@Nullable Integer value) {
        if (Objects.equals(this.numCommitsBehind, value)) {
            return this;
        }
        return new ImmutableReferenceMetadata(this.numCommitsAhead, value, this.commitMetaOfHEAD, this.commonAncestorHash, this.numTotalCommits);
    }

    public final ImmutableReferenceMetadata withCommitMetaOfHEAD(@Nullable CommitMeta value) {
        if (this.commitMetaOfHEAD == value) {
            return this;
        }
        return new ImmutableReferenceMetadata(this.numCommitsAhead, this.numCommitsBehind, value, this.commonAncestorHash, this.numTotalCommits);
    }

    public final ImmutableReferenceMetadata withCommonAncestorHash(@Nullable String value) {
        if (Objects.equals(this.commonAncestorHash, value)) {
            return this;
        }
        return new ImmutableReferenceMetadata(this.numCommitsAhead, this.numCommitsBehind, this.commitMetaOfHEAD, value, this.numTotalCommits);
    }

    public final ImmutableReferenceMetadata withNumTotalCommits(@Nullable Long value) {
        if (Objects.equals(this.numTotalCommits, value)) {
            return this;
        }
        return new ImmutableReferenceMetadata(this.numCommitsAhead, this.numCommitsBehind, this.commitMetaOfHEAD, this.commonAncestorHash, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReferenceMetadata && this.equalTo((ImmutableReferenceMetadata)another);
    }

    private boolean equalTo(ImmutableReferenceMetadata another) {
        return Objects.equals(this.numCommitsAhead, another.numCommitsAhead) && Objects.equals(this.numCommitsBehind, another.numCommitsBehind) && Objects.equals(this.commitMetaOfHEAD, another.commitMetaOfHEAD) && Objects.equals(this.commonAncestorHash, another.commonAncestorHash) && Objects.equals(this.numTotalCommits, another.numTotalCommits);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.numCommitsAhead);
        h += (h << 5) + Objects.hashCode(this.numCommitsBehind);
        h += (h << 5) + Objects.hashCode(this.commitMetaOfHEAD);
        h += (h << 5) + Objects.hashCode(this.commonAncestorHash);
        h += (h << 5) + Objects.hashCode(this.numTotalCommits);
        return h;
    }

    public String toString() {
        return "ReferenceMetadata{numCommitsAhead=" + this.numCommitsAhead + ", numCommitsBehind=" + this.numCommitsBehind + ", commitMetaOfHEAD=" + this.commitMetaOfHEAD + ", commonAncestorHash=" + this.commonAncestorHash + ", numTotalCommits=" + this.numTotalCommits + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReferenceMetadata fromJson(Json json) {
        Builder builder = ImmutableReferenceMetadata.builder();
        if (json.numCommitsAhead != null) {
            builder.numCommitsAhead(json.numCommitsAhead);
        }
        if (json.numCommitsBehind != null) {
            builder.numCommitsBehind(json.numCommitsBehind);
        }
        if (json.commitMetaOfHEAD != null) {
            builder.commitMetaOfHEAD(json.commitMetaOfHEAD);
        }
        if (json.commonAncestorHash != null) {
            builder.commonAncestorHash(json.commonAncestorHash);
        }
        if (json.numTotalCommits != null) {
            builder.numTotalCommits(json.numTotalCommits);
        }
        return builder.build();
    }

    public static ImmutableReferenceMetadata copyOf(ReferenceMetadata instance) {
        if (instance instanceof ImmutableReferenceMetadata) {
            return (ImmutableReferenceMetadata)instance;
        }
        return ImmutableReferenceMetadata.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReferenceMetadata", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Integer numCommitsAhead;
        @Nullable
        private Integer numCommitsBehind;
        @Nullable
        private CommitMeta commitMetaOfHEAD;
        @Nullable
        private String commonAncestorHash;
        @Nullable
        private Long numTotalCommits;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReferenceMetadata instance) {
            Long numTotalCommitsValue;
            String commonAncestorHashValue;
            CommitMeta commitMetaOfHEADValue;
            Integer numCommitsBehindValue;
            Objects.requireNonNull(instance, "instance");
            Integer numCommitsAheadValue = instance.numCommitsAhead();
            if (numCommitsAheadValue != null) {
                this.numCommitsAhead(numCommitsAheadValue);
            }
            if ((numCommitsBehindValue = instance.numCommitsBehind()) != null) {
                this.numCommitsBehind(numCommitsBehindValue);
            }
            if ((commitMetaOfHEADValue = instance.commitMetaOfHEAD()) != null) {
                this.commitMetaOfHEAD(commitMetaOfHEADValue);
            }
            if ((commonAncestorHashValue = instance.commonAncestorHash()) != null) {
                this.commonAncestorHash(commonAncestorHashValue);
            }
            if ((numTotalCommitsValue = instance.numTotalCommits()) != null) {
                this.numTotalCommits(numTotalCommitsValue);
            }
            return this;
        }

        @JsonProperty(value="numCommitsAhead")
        @CanIgnoreReturnValue
        public final Builder numCommitsAhead(@Nullable Integer numCommitsAhead) {
            this.numCommitsAhead = numCommitsAhead;
            return this;
        }

        @JsonProperty(value="numCommitsBehind")
        @CanIgnoreReturnValue
        public final Builder numCommitsBehind(@Nullable Integer numCommitsBehind) {
            this.numCommitsBehind = numCommitsBehind;
            return this;
        }

        @JsonProperty(value="commitMetaOfHEAD")
        @CanIgnoreReturnValue
        public final Builder commitMetaOfHEAD(@Nullable CommitMeta commitMetaOfHEAD) {
            this.commitMetaOfHEAD = commitMetaOfHEAD;
            return this;
        }

        @JsonProperty(value="commonAncestorHash")
        @CanIgnoreReturnValue
        public final Builder commonAncestorHash(@Nullable String commonAncestorHash) {
            this.commonAncestorHash = commonAncestorHash;
            return this;
        }

        @JsonProperty(value="numTotalCommits")
        @CanIgnoreReturnValue
        public final Builder numTotalCommits(@Nullable Long numTotalCommits) {
            this.numTotalCommits = numTotalCommits;
            return this;
        }

        public ImmutableReferenceMetadata build() {
            return new ImmutableReferenceMetadata(this.numCommitsAhead, this.numCommitsBehind, this.commitMetaOfHEAD, this.commonAncestorHash, this.numTotalCommits);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReferenceMetadata", generator="Immutables")
    static final class Json
    implements ReferenceMetadata {
        @Nullable
        Integer numCommitsAhead;
        @Nullable
        Integer numCommitsBehind;
        @Nullable
        CommitMeta commitMetaOfHEAD;
        @Nullable
        String commonAncestorHash;
        @Nullable
        Long numTotalCommits;

        Json() {
        }

        @JsonProperty(value="numCommitsAhead")
        public void setNumCommitsAhead(@Nullable Integer numCommitsAhead) {
            this.numCommitsAhead = numCommitsAhead;
        }

        @JsonProperty(value="numCommitsBehind")
        public void setNumCommitsBehind(@Nullable Integer numCommitsBehind) {
            this.numCommitsBehind = numCommitsBehind;
        }

        @JsonProperty(value="commitMetaOfHEAD")
        public void setCommitMetaOfHEAD(@Nullable CommitMeta commitMetaOfHEAD) {
            this.commitMetaOfHEAD = commitMetaOfHEAD;
        }

        @JsonProperty(value="commonAncestorHash")
        public void setCommonAncestorHash(@Nullable String commonAncestorHash) {
            this.commonAncestorHash = commonAncestorHash;
        }

        @JsonProperty(value="numTotalCommits")
        public void setNumTotalCommits(@Nullable Long numTotalCommits) {
            this.numTotalCommits = numTotalCommits;
        }

        @Override
        public Integer numCommitsAhead() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer numCommitsBehind() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CommitMeta commitMetaOfHEAD() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String commonAncestorHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long numTotalCommits() {
            throw new UnsupportedOperationException();
        }
    }
}

