package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Operation.Put}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePut.builder()}.
 */
@Generated(from = "Operation.Put", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePut implements Operation.Put {
  private final ContentKey key;
  private final Content content;
  private final @Nullable Content expectedContent;

  private ImmutablePut(
      ContentKey key,
      Content content,
      @Nullable Content expectedContent) {
    this.key = key;
    this.content = content;
    this.expectedContent = expectedContent;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @JsonProperty("key")
  @Override
  public ContentKey getKey() {
    return key;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty("content")
  @Override
  public Content getContent() {
    return content;
  }

  /**
   * @return The value of the {@code expectedContent} attribute
   */
  @JsonProperty("expectedContent")
  @Override
  public @Nullable Content getExpectedContent() {
    return expectedContent;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Operation.Put#getKey() key} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePut withKey(ContentKey value) {
    if (this.key == value) return this;
    ContentKey newValue = Objects.requireNonNull(value, "key");
    return new ImmutablePut(newValue, this.content, this.expectedContent);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Operation.Put#getContent() content} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePut withContent(Content value) {
    if (this.content == value) return this;
    Content newValue = Objects.requireNonNull(value, "content");
    return new ImmutablePut(this.key, newValue, this.expectedContent);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Operation.Put#getExpectedContent() expectedContent} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expectedContent (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePut withExpectedContent(@Nullable Content value) {
    if (this.expectedContent == value) return this;
    return new ImmutablePut(this.key, this.content, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePut} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePut
        && equalTo((ImmutablePut) another);
  }

  private boolean equalTo(ImmutablePut another) {
    return key.equals(another.key)
        && content.equals(another.content)
        && Objects.equals(expectedContent, another.expectedContent);
  }

  /**
   * Computes a hash code from attributes: {@code key}, {@code content}, {@code expectedContent}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + key.hashCode();
    h += (h << 5) + content.hashCode();
    h += (h << 5) + Objects.hashCode(expectedContent);
    return h;
  }

  /**
   * Prints the immutable value {@code Put} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Put{"
        + "key=" + key
        + ", content=" + content
        + ", expectedContent=" + expectedContent
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Operation.Put", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Operation.Put {
    @Nullable ContentKey key;
    @Nullable Content content;
    @Nullable Content expectedContent;
    @JsonProperty("key")
    public void setKey(ContentKey key) {
      this.key = key;
    }
    @JsonProperty("content")
    public void setContent(Content content) {
      this.content = content;
    }
    @JsonProperty("expectedContent")
    public void setExpectedContent(@Nullable Content expectedContent) {
      this.expectedContent = expectedContent;
    }
    @Override
    public ContentKey getKey() { throw new UnsupportedOperationException(); }
    @Override
    public Content getContent() { throw new UnsupportedOperationException(); }
    @Override
    public Content getExpectedContent() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePut fromJson(Json json) {
    ImmutablePut.Builder builder = ImmutablePut.builder();
    if (json.key != null) {
      builder.key(json.key);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    if (json.expectedContent != null) {
      builder.expectedContent(json.expectedContent);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Operation.Put} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Put instance
   */
  public static ImmutablePut copyOf(Operation.Put instance) {
    if (instance instanceof ImmutablePut) {
      return (ImmutablePut) instance;
    }
    return ImmutablePut.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePut ImmutablePut}.
   * <pre>
   * ImmutablePut.builder()
   *    .key(org.projectnessie.model.ContentKey) // required {@link Operation.Put#getKey() key}
   *    .content(org.projectnessie.model.Content) // required {@link Operation.Put#getContent() content}
   *    .expectedContent(org.projectnessie.model.Content | null) // nullable {@link Operation.Put#getExpectedContent() expectedContent}
   *    .build();
   * </pre>
   * @return A new ImmutablePut builder
   */
  public static ImmutablePut.Builder builder() {
    return new ImmutablePut.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePut ImmutablePut}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Operation.Put", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private static final long INIT_BIT_CONTENT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ContentKey key;
    private @Nullable Content content;
    private @Nullable Content expectedContent;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Operation} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Operation instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Operation.Put} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Operation.Put instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Operation) {
        Operation instance = (Operation) object;
        key(instance.getKey());
      }
      if (object instanceof Operation.Put) {
        Operation.Put instance = (Operation.Put) object;
        content(instance.getContent());
        @Nullable Content expectedContentValue = instance.getExpectedContent();
        if (expectedContentValue != null) {
          expectedContent(expectedContentValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link Operation.Put#getKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("key")
    public final Builder key(ContentKey key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link Operation.Put#getContent() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content")
    public final Builder content(Content content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Initializes the value for the {@link Operation.Put#getExpectedContent() expectedContent} attribute.
     * @param expectedContent The value for expectedContent (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("expectedContent")
    public final Builder expectedContent(@Nullable Content expectedContent) {
      this.expectedContent = expectedContent;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePut ImmutablePut}.
     * @return An immutable instance of Put
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePut build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePut(key, content, expectedContent);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      return "Cannot build Put, some of required attributes are not set " + attributes;
    }
  }
}
