package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RefLogResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRefLogResponse.builder()}.
 */
@Generated(from = "RefLogResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRefLogResponse implements RefLogResponse {
  private final boolean isHasMore;
  private final @Nullable String token;
  private final List<RefLogResponse.RefLogResponseEntry> logEntries;

  private ImmutableRefLogResponse(ImmutableRefLogResponse.Builder builder) {
    this.token = builder.token;
    this.logEntries = createUnmodifiableList(true, builder.logEntries);
    this.isHasMore = builder.isHasMoreIsSet()
        ? builder.isHasMore
        : RefLogResponse.super.isHasMore();
  }

  private ImmutableRefLogResponse(
      boolean isHasMore,
      @Nullable String token,
      List<RefLogResponse.RefLogResponseEntry> logEntries) {
    this.isHasMore = isHasMore;
    this.token = token;
    this.logEntries = logEntries;
  }

  /**
   * Whether there are more result-items than returned by this response object.
   * <p>If there are more result-items, the value returned by {@link #getToken()} can be used in the
   * next invocation to get the next "page" of results.
   * @return {@code true}, if there are more result items.
   */
  @JsonProperty("hasMore")
  @Override
  public boolean isHasMore() {
    return isHasMore;
  }

  /**
   * Pass this value to the next invocation of the API function to get the next page of results.
   * <p>Paging tokens are opaque and the structure may change without prior notice even in patch
   * releases.
   * @return paging continuation token for the next invocation of an API function taking a subclass
   *     of {@link org.projectnessie.api.params.AbstractParams}, if {@link #isHasMore()} is {@code
   *     true}. Undefined, if {@link #isHasMore()} is {@code false}.
   */
  @JsonProperty("token")
  @Override
  public @Nullable String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code logEntries} attribute
   */
  @JsonProperty("logEntries")
  @Override
  public List<RefLogResponse.RefLogResponseEntry> getLogEntries() {
    return logEntries;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RefLogResponse#isHasMore() isHasMore} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isHasMore
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRefLogResponse withIsHasMore(boolean value) {
    if (this.isHasMore == value) return this;
    return new ImmutableRefLogResponse(value, this.token, this.logEntries);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RefLogResponse#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for token (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRefLogResponse withToken(@Nullable String value) {
    if (Objects.equals(this.token, value)) return this;
    return new ImmutableRefLogResponse(this.isHasMore, value, this.logEntries);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RefLogResponse#getLogEntries() logEntries}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRefLogResponse withLogEntries(RefLogResponse.RefLogResponseEntry... elements) {
    List<RefLogResponse.RefLogResponseEntry> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableRefLogResponse(this.isHasMore, this.token, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RefLogResponse#getLogEntries() logEntries}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of logEntries elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRefLogResponse withLogEntries(Iterable<? extends RefLogResponse.RefLogResponseEntry> elements) {
    if (this.logEntries == elements) return this;
    List<RefLogResponse.RefLogResponseEntry> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableRefLogResponse(this.isHasMore, this.token, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRefLogResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRefLogResponse
        && equalTo(0, (ImmutableRefLogResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableRefLogResponse another) {
    return isHasMore == another.isHasMore
        && Objects.equals(token, another.token)
        && logEntries.equals(another.logEntries);
  }

  /**
   * Computes a hash code from attributes: {@code isHasMore}, {@code token}, {@code logEntries}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Boolean.hashCode(isHasMore);
    h += (h << 5) + Objects.hashCode(token);
    h += (h << 5) + logEntries.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RefLogResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RefLogResponse{"
        + "isHasMore=" + isHasMore
        + ", token=" + token
        + ", logEntries=" + logEntries
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RefLogResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements RefLogResponse {
    boolean isHasMore;
    boolean isHasMoreIsSet;
    @Nullable String token;
    @Nullable List<RefLogResponse.RefLogResponseEntry> logEntries = Collections.emptyList();
    @JsonProperty("hasMore")
    public void setIsHasMore(boolean isHasMore) {
      this.isHasMore = isHasMore;
      this.isHasMoreIsSet = true;
    }
    @JsonProperty("token")
    public void setToken(@Nullable String token) {
      this.token = token;
    }
    @JsonProperty("logEntries")
    public void setLogEntries(List<RefLogResponse.RefLogResponseEntry> logEntries) {
      this.logEntries = logEntries;
    }
    @Override
    public boolean isHasMore() { throw new UnsupportedOperationException(); }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public List<RefLogResponse.RefLogResponseEntry> getLogEntries() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRefLogResponse fromJson(Json json) {
    ImmutableRefLogResponse.Builder builder = ImmutableRefLogResponse.builder();
    if (json.isHasMoreIsSet) {
      builder.isHasMore(json.isHasMore);
    }
    if (json.token != null) {
      builder.token(json.token);
    }
    if (json.logEntries != null) {
      builder.addAllLogEntries(json.logEntries);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RefLogResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RefLogResponse instance
   */
  public static ImmutableRefLogResponse copyOf(RefLogResponse instance) {
    if (instance instanceof ImmutableRefLogResponse) {
      return (ImmutableRefLogResponse) instance;
    }
    return ImmutableRefLogResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRefLogResponse ImmutableRefLogResponse}.
   * <pre>
   * ImmutableRefLogResponse.builder()
   *    .isHasMore(boolean) // optional {@link RefLogResponse#isHasMore() isHasMore}
   *    .token(String | null) // nullable {@link RefLogResponse#getToken() token}
   *    .addLogEntries|addAllLogEntries(org.projectnessie.model.RefLogResponse.RefLogResponseEntry) // {@link RefLogResponse#getLogEntries() logEntries} elements
   *    .build();
   * </pre>
   * @return A new ImmutableRefLogResponse builder
   */
  public static ImmutableRefLogResponse.Builder builder() {
    return new ImmutableRefLogResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRefLogResponse ImmutableRefLogResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RefLogResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_IS_HAS_MORE = 0x1L;
    private long optBits;

    private boolean isHasMore;
    private @Nullable String token;
    private List<RefLogResponse.RefLogResponseEntry> logEntries = new ArrayList<RefLogResponse.RefLogResponseEntry>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.PaginatedResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PaginatedResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.RefLogResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RefLogResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedResponse) {
        PaginatedResponse instance = (PaginatedResponse) object;
        isHasMore(instance.isHasMore());
        @Nullable String tokenValue = instance.getToken();
        if (tokenValue != null) {
          token(tokenValue);
        }
      }
      if (object instanceof RefLogResponse) {
        RefLogResponse instance = (RefLogResponse) object;
        addAllLogEntries(instance.getLogEntries());
      }
    }

    /**
     * Initializes the value for the {@link RefLogResponse#isHasMore() isHasMore} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link RefLogResponse#isHasMore() isHasMore}.</em>
     * @param isHasMore The value for isHasMore 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hasMore")
    public final Builder isHasMore(boolean isHasMore) {
      this.isHasMore = isHasMore;
      optBits |= OPT_BIT_IS_HAS_MORE;
      return this;
    }

    /**
     * Initializes the value for the {@link RefLogResponse#getToken() token} attribute.
     * @param token The value for token (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("token")
    public final Builder token(@Nullable String token) {
      this.token = token;
      return this;
    }

    /**
     * Adds one element to {@link RefLogResponse#getLogEntries() logEntries} list.
     * @param element A logEntries element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLogEntries(RefLogResponse.RefLogResponseEntry element) {
      this.logEntries.add(Objects.requireNonNull(element, "logEntries element"));
      return this;
    }

    /**
     * Adds elements to {@link RefLogResponse#getLogEntries() logEntries} list.
     * @param elements An array of logEntries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLogEntries(RefLogResponse.RefLogResponseEntry... elements) {
      for (RefLogResponse.RefLogResponseEntry element : elements) {
        this.logEntries.add(Objects.requireNonNull(element, "logEntries element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link RefLogResponse#getLogEntries() logEntries} list.
     * @param elements An iterable of logEntries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("logEntries")
    public final Builder logEntries(Iterable<? extends RefLogResponse.RefLogResponseEntry> elements) {
      this.logEntries.clear();
      return addAllLogEntries(elements);
    }

    /**
     * Adds elements to {@link RefLogResponse#getLogEntries() logEntries} list.
     * @param elements An iterable of logEntries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLogEntries(Iterable<? extends RefLogResponse.RefLogResponseEntry> elements) {
      for (RefLogResponse.RefLogResponseEntry element : elements) {
        this.logEntries.add(Objects.requireNonNull(element, "logEntries element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableRefLogResponse ImmutableRefLogResponse}.
     * @return An immutable instance of RefLogResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRefLogResponse build() {
      return new ImmutableRefLogResponse(this);
    }

    private boolean isHasMoreIsSet() {
      return (optBits & OPT_BIT_IS_HAS_MORE) != 0;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
