package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RefLogResponse.RefLogResponseEntry}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRefLogResponseEntry.builder()}.
 */
@Generated(from = "RefLogResponse.RefLogResponseEntry", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRefLogResponseEntry
    implements RefLogResponse.RefLogResponseEntry {
  private final String refLogId;
  private final String refName;
  private final String refType;
  private final String commitHash;
  private final String parentRefLogId;
  private final long operationTime;
  private final String operation;
  private final List<String> sourceHashes;

  private ImmutableRefLogResponseEntry(
      String refLogId,
      String refName,
      String refType,
      String commitHash,
      String parentRefLogId,
      long operationTime,
      String operation,
      List<String> sourceHashes) {
    this.refLogId = refLogId;
    this.refName = refName;
    this.refType = refType;
    this.commitHash = commitHash;
    this.parentRefLogId = parentRefLogId;
    this.operationTime = operationTime;
    this.operation = operation;
    this.sourceHashes = sourceHashes;
  }

  /**
   *Reflog id of the current entry. 
   */
  @JsonProperty("refLogId")
  @Override
  public String getRefLogId() {
    return refLogId;
  }

  /**
   *Reference on which current operation is executed. 
   */
  @JsonProperty("refName")
  @Override
  public String getRefName() {
    return refName;
  }

  /**
   *Reference type can be 'Branch' or 'Tag'. 
   */
  @JsonProperty("refType")
  @Override
  public String getRefType() {
    return refType;
  }

  /**
   *Output commit hash of the operation. 
   */
  @JsonProperty("commitHash")
  @Override
  public String getCommitHash() {
    return commitHash;
  }

  /**
   *Parent reflog id of the current entry. 
   */
  @JsonProperty("parentRefLogId")
  @Override
  public String getParentRefLogId() {
    return parentRefLogId;
  }

  /**
   *Time in microseconds since epoch. 
   */
  @JsonProperty("operationTime")
  @Override
  public long getOperationTime() {
    return operationTime;
  }

  /**
   *Operation String mapped to ENUM in {@code RefLogEntry.Operation} of 'persist.proto' file. 
   */
  @JsonProperty("operation")
  @Override
  public String getOperation() {
    return operation;
  }

  /**
   * Single hash in case of MERGE. One or more hashes in case of TRANSPLANT. Empty list for other
   * operations.
   */
  @JsonProperty("sourceHashes")
  @Override
  public List<String> getSourceHashes() {
    return sourceHashes;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RefLogResponse.RefLogResponseEntry#getRefLogId() refLogId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for refLogId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRefLogResponseEntry withRefLogId(String value) {
    String newValue = Objects.requireNonNull(value, "refLogId");
    if (this.refLogId.equals(newValue)) return this;
    return new ImmutableRefLogResponseEntry(
        newValue,
        this.refName,
        this.refType,
        this.commitHash,
        this.parentRefLogId,
        this.operationTime,
        this.operation,
        this.sourceHashes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RefLogResponse.RefLogResponseEntry#getRefName() refName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for refName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRefLogResponseEntry withRefName(String value) {
    String newValue = Objects.requireNonNull(value, "refName");
    if (this.refName.equals(newValue)) return this;
    return new ImmutableRefLogResponseEntry(
        this.refLogId,
        newValue,
        this.refType,
        this.commitHash,
        this.parentRefLogId,
        this.operationTime,
        this.operation,
        this.sourceHashes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RefLogResponse.RefLogResponseEntry#getRefType() refType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for refType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRefLogResponseEntry withRefType(String value) {
    String newValue = Objects.requireNonNull(value, "refType");
    if (this.refType.equals(newValue)) return this;
    return new ImmutableRefLogResponseEntry(
        this.refLogId,
        this.refName,
        newValue,
        this.commitHash,
        this.parentRefLogId,
        this.operationTime,
        this.operation,
        this.sourceHashes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RefLogResponse.RefLogResponseEntry#getCommitHash() commitHash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitHash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRefLogResponseEntry withCommitHash(String value) {
    String newValue = Objects.requireNonNull(value, "commitHash");
    if (this.commitHash.equals(newValue)) return this;
    return new ImmutableRefLogResponseEntry(
        this.refLogId,
        this.refName,
        this.refType,
        newValue,
        this.parentRefLogId,
        this.operationTime,
        this.operation,
        this.sourceHashes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RefLogResponse.RefLogResponseEntry#getParentRefLogId() parentRefLogId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for parentRefLogId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRefLogResponseEntry withParentRefLogId(String value) {
    String newValue = Objects.requireNonNull(value, "parentRefLogId");
    if (this.parentRefLogId.equals(newValue)) return this;
    return new ImmutableRefLogResponseEntry(
        this.refLogId,
        this.refName,
        this.refType,
        this.commitHash,
        newValue,
        this.operationTime,
        this.operation,
        this.sourceHashes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RefLogResponse.RefLogResponseEntry#getOperationTime() operationTime} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for operationTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRefLogResponseEntry withOperationTime(long value) {
    if (this.operationTime == value) return this;
    return new ImmutableRefLogResponseEntry(
        this.refLogId,
        this.refName,
        this.refType,
        this.commitHash,
        this.parentRefLogId,
        value,
        this.operation,
        this.sourceHashes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RefLogResponse.RefLogResponseEntry#getOperation() operation} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for operation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRefLogResponseEntry withOperation(String value) {
    String newValue = Objects.requireNonNull(value, "operation");
    if (this.operation.equals(newValue)) return this;
    return new ImmutableRefLogResponseEntry(
        this.refLogId,
        this.refName,
        this.refType,
        this.commitHash,
        this.parentRefLogId,
        this.operationTime,
        newValue,
        this.sourceHashes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RefLogResponse.RefLogResponseEntry#getSourceHashes() sourceHashes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRefLogResponseEntry withSourceHashes(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableRefLogResponseEntry(
        this.refLogId,
        this.refName,
        this.refType,
        this.commitHash,
        this.parentRefLogId,
        this.operationTime,
        this.operation,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RefLogResponse.RefLogResponseEntry#getSourceHashes() sourceHashes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sourceHashes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRefLogResponseEntry withSourceHashes(Iterable<String> elements) {
    if (this.sourceHashes == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableRefLogResponseEntry(
        this.refLogId,
        this.refName,
        this.refType,
        this.commitHash,
        this.parentRefLogId,
        this.operationTime,
        this.operation,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRefLogResponseEntry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRefLogResponseEntry
        && equalTo(0, (ImmutableRefLogResponseEntry) another);
  }

  private boolean equalTo(int synthetic, ImmutableRefLogResponseEntry another) {
    return refLogId.equals(another.refLogId)
        && refName.equals(another.refName)
        && refType.equals(another.refType)
        && commitHash.equals(another.commitHash)
        && parentRefLogId.equals(another.parentRefLogId)
        && operationTime == another.operationTime
        && operation.equals(another.operation)
        && sourceHashes.equals(another.sourceHashes);
  }

  /**
   * Computes a hash code from attributes: {@code refLogId}, {@code refName}, {@code refType}, {@code commitHash}, {@code parentRefLogId}, {@code operationTime}, {@code operation}, {@code sourceHashes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + refLogId.hashCode();
    h += (h << 5) + refName.hashCode();
    h += (h << 5) + refType.hashCode();
    h += (h << 5) + commitHash.hashCode();
    h += (h << 5) + parentRefLogId.hashCode();
    h += (h << 5) + Long.hashCode(operationTime);
    h += (h << 5) + operation.hashCode();
    h += (h << 5) + sourceHashes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RefLogResponseEntry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RefLogResponseEntry{"
        + "refLogId=" + refLogId
        + ", refName=" + refName
        + ", refType=" + refType
        + ", commitHash=" + commitHash
        + ", parentRefLogId=" + parentRefLogId
        + ", operationTime=" + operationTime
        + ", operation=" + operation
        + ", sourceHashes=" + sourceHashes
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RefLogResponse.RefLogResponseEntry", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements RefLogResponse.RefLogResponseEntry {
    @Nullable String refLogId;
    @Nullable String refName;
    @Nullable String refType;
    @Nullable String commitHash;
    @Nullable String parentRefLogId;
    long operationTime;
    boolean operationTimeIsSet;
    @Nullable String operation;
    @Nullable List<String> sourceHashes = Collections.emptyList();
    @JsonProperty("refLogId")
    public void setRefLogId(String refLogId) {
      this.refLogId = refLogId;
    }
    @JsonProperty("refName")
    public void setRefName(String refName) {
      this.refName = refName;
    }
    @JsonProperty("refType")
    public void setRefType(String refType) {
      this.refType = refType;
    }
    @JsonProperty("commitHash")
    public void setCommitHash(String commitHash) {
      this.commitHash = commitHash;
    }
    @JsonProperty("parentRefLogId")
    public void setParentRefLogId(String parentRefLogId) {
      this.parentRefLogId = parentRefLogId;
    }
    @JsonProperty("operationTime")
    public void setOperationTime(long operationTime) {
      this.operationTime = operationTime;
      this.operationTimeIsSet = true;
    }
    @JsonProperty("operation")
    public void setOperation(String operation) {
      this.operation = operation;
    }
    @JsonProperty("sourceHashes")
    public void setSourceHashes(List<String> sourceHashes) {
      this.sourceHashes = sourceHashes;
    }
    @Override
    public String getRefLogId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRefName() { throw new UnsupportedOperationException(); }
    @Override
    public String getRefType() { throw new UnsupportedOperationException(); }
    @Override
    public String getCommitHash() { throw new UnsupportedOperationException(); }
    @Override
    public String getParentRefLogId() { throw new UnsupportedOperationException(); }
    @Override
    public long getOperationTime() { throw new UnsupportedOperationException(); }
    @Override
    public String getOperation() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSourceHashes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRefLogResponseEntry fromJson(Json json) {
    ImmutableRefLogResponseEntry.Builder builder = ImmutableRefLogResponseEntry.builder();
    if (json.refLogId != null) {
      builder.refLogId(json.refLogId);
    }
    if (json.refName != null) {
      builder.refName(json.refName);
    }
    if (json.refType != null) {
      builder.refType(json.refType);
    }
    if (json.commitHash != null) {
      builder.commitHash(json.commitHash);
    }
    if (json.parentRefLogId != null) {
      builder.parentRefLogId(json.parentRefLogId);
    }
    if (json.operationTimeIsSet) {
      builder.operationTime(json.operationTime);
    }
    if (json.operation != null) {
      builder.operation(json.operation);
    }
    if (json.sourceHashes != null) {
      builder.addAllSourceHashes(json.sourceHashes);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RefLogResponse.RefLogResponseEntry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RefLogResponseEntry instance
   */
  public static ImmutableRefLogResponseEntry copyOf(RefLogResponse.RefLogResponseEntry instance) {
    if (instance instanceof ImmutableRefLogResponseEntry) {
      return (ImmutableRefLogResponseEntry) instance;
    }
    return ImmutableRefLogResponseEntry.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRefLogResponseEntry ImmutableRefLogResponseEntry}.
   * <pre>
   * ImmutableRefLogResponseEntry.builder()
   *    .refLogId(String) // required {@link RefLogResponse.RefLogResponseEntry#getRefLogId() refLogId}
   *    .refName(String) // required {@link RefLogResponse.RefLogResponseEntry#getRefName() refName}
   *    .refType(String) // required {@link RefLogResponse.RefLogResponseEntry#getRefType() refType}
   *    .commitHash(String) // required {@link RefLogResponse.RefLogResponseEntry#getCommitHash() commitHash}
   *    .parentRefLogId(String) // required {@link RefLogResponse.RefLogResponseEntry#getParentRefLogId() parentRefLogId}
   *    .operationTime(long) // required {@link RefLogResponse.RefLogResponseEntry#getOperationTime() operationTime}
   *    .operation(String) // required {@link RefLogResponse.RefLogResponseEntry#getOperation() operation}
   *    .addSourceHashes|addAllSourceHashes(String) // {@link RefLogResponse.RefLogResponseEntry#getSourceHashes() sourceHashes} elements
   *    .build();
   * </pre>
   * @return A new ImmutableRefLogResponseEntry builder
   */
  public static ImmutableRefLogResponseEntry.Builder builder() {
    return new ImmutableRefLogResponseEntry.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRefLogResponseEntry ImmutableRefLogResponseEntry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RefLogResponse.RefLogResponseEntry", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_REF_LOG_ID = 0x1L;
    private static final long INIT_BIT_REF_NAME = 0x2L;
    private static final long INIT_BIT_REF_TYPE = 0x4L;
    private static final long INIT_BIT_COMMIT_HASH = 0x8L;
    private static final long INIT_BIT_PARENT_REF_LOG_ID = 0x10L;
    private static final long INIT_BIT_OPERATION_TIME = 0x20L;
    private static final long INIT_BIT_OPERATION = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable String refLogId;
    private @Nullable String refName;
    private @Nullable String refType;
    private @Nullable String commitHash;
    private @Nullable String parentRefLogId;
    private long operationTime;
    private @Nullable String operation;
    private List<String> sourceHashes = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RefLogResponseEntry} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RefLogResponse.RefLogResponseEntry instance) {
      Objects.requireNonNull(instance, "instance");
      refLogId(instance.getRefLogId());
      refName(instance.getRefName());
      refType(instance.getRefType());
      commitHash(instance.getCommitHash());
      parentRefLogId(instance.getParentRefLogId());
      operationTime(instance.getOperationTime());
      operation(instance.getOperation());
      addAllSourceHashes(instance.getSourceHashes());
      return this;
    }

    /**
     * Initializes the value for the {@link RefLogResponse.RefLogResponseEntry#getRefLogId() refLogId} attribute.
     * @param refLogId The value for refLogId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("refLogId")
    public final Builder refLogId(String refLogId) {
      this.refLogId = Objects.requireNonNull(refLogId, "refLogId");
      initBits &= ~INIT_BIT_REF_LOG_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RefLogResponse.RefLogResponseEntry#getRefName() refName} attribute.
     * @param refName The value for refName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("refName")
    public final Builder refName(String refName) {
      this.refName = Objects.requireNonNull(refName, "refName");
      initBits &= ~INIT_BIT_REF_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link RefLogResponse.RefLogResponseEntry#getRefType() refType} attribute.
     * @param refType The value for refType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("refType")
    public final Builder refType(String refType) {
      this.refType = Objects.requireNonNull(refType, "refType");
      initBits &= ~INIT_BIT_REF_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link RefLogResponse.RefLogResponseEntry#getCommitHash() commitHash} attribute.
     * @param commitHash The value for commitHash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("commitHash")
    public final Builder commitHash(String commitHash) {
      this.commitHash = Objects.requireNonNull(commitHash, "commitHash");
      initBits &= ~INIT_BIT_COMMIT_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link RefLogResponse.RefLogResponseEntry#getParentRefLogId() parentRefLogId} attribute.
     * @param parentRefLogId The value for parentRefLogId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("parentRefLogId")
    public final Builder parentRefLogId(String parentRefLogId) {
      this.parentRefLogId = Objects.requireNonNull(parentRefLogId, "parentRefLogId");
      initBits &= ~INIT_BIT_PARENT_REF_LOG_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RefLogResponse.RefLogResponseEntry#getOperationTime() operationTime} attribute.
     * @param operationTime The value for operationTime 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("operationTime")
    public final Builder operationTime(long operationTime) {
      this.operationTime = operationTime;
      initBits &= ~INIT_BIT_OPERATION_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link RefLogResponse.RefLogResponseEntry#getOperation() operation} attribute.
     * @param operation The value for operation 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("operation")
    public final Builder operation(String operation) {
      this.operation = Objects.requireNonNull(operation, "operation");
      initBits &= ~INIT_BIT_OPERATION;
      return this;
    }

    /**
     * Adds one element to {@link RefLogResponse.RefLogResponseEntry#getSourceHashes() sourceHashes} list.
     * @param element A sourceHashes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSourceHashes(String element) {
      this.sourceHashes.add(Objects.requireNonNull(element, "sourceHashes element"));
      return this;
    }

    /**
     * Adds elements to {@link RefLogResponse.RefLogResponseEntry#getSourceHashes() sourceHashes} list.
     * @param elements An array of sourceHashes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSourceHashes(String... elements) {
      for (String element : elements) {
        this.sourceHashes.add(Objects.requireNonNull(element, "sourceHashes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link RefLogResponse.RefLogResponseEntry#getSourceHashes() sourceHashes} list.
     * @param elements An iterable of sourceHashes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("sourceHashes")
    public final Builder sourceHashes(Iterable<String> elements) {
      this.sourceHashes.clear();
      return addAllSourceHashes(elements);
    }

    /**
     * Adds elements to {@link RefLogResponse.RefLogResponseEntry#getSourceHashes() sourceHashes} list.
     * @param elements An iterable of sourceHashes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSourceHashes(Iterable<String> elements) {
      for (String element : elements) {
        this.sourceHashes.add(Objects.requireNonNull(element, "sourceHashes element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableRefLogResponseEntry ImmutableRefLogResponseEntry}.
     * @return An immutable instance of RefLogResponseEntry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRefLogResponseEntry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRefLogResponseEntry(
          refLogId,
          refName,
          refType,
          commitHash,
          parentRefLogId,
          operationTime,
          operation,
          createUnmodifiableList(true, sourceHashes));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REF_LOG_ID) != 0) attributes.add("refLogId");
      if ((initBits & INIT_BIT_REF_NAME) != 0) attributes.add("refName");
      if ((initBits & INIT_BIT_REF_TYPE) != 0) attributes.add("refType");
      if ((initBits & INIT_BIT_COMMIT_HASH) != 0) attributes.add("commitHash");
      if ((initBits & INIT_BIT_PARENT_REF_LOG_ID) != 0) attributes.add("parentRefLogId");
      if ((initBits & INIT_BIT_OPERATION_TIME) != 0) attributes.add("operationTime");
      if ((initBits & INIT_BIT_OPERATION) != 0) attributes.add("operation");
      return "Cannot build RefLogResponseEntry, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
