package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReferenceMetadata}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReferenceMetadata.builder()}.
 */
@Generated(from = "ReferenceMetadata", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableReferenceMetadata implements ReferenceMetadata {
  private final @Nullable Integer numCommitsAhead;
  private final @Nullable Integer numCommitsBehind;
  private final @Nullable CommitMeta commitMetaOfHEAD;
  private final @Nullable String commonAncestorHash;
  private final @Nullable Long numTotalCommits;

  private ImmutableReferenceMetadata(
      @Nullable Integer numCommitsAhead,
      @Nullable Integer numCommitsBehind,
      @Nullable CommitMeta commitMetaOfHEAD,
      @Nullable String commonAncestorHash,
      @Nullable Long numTotalCommits) {
    this.numCommitsAhead = numCommitsAhead;
    this.numCommitsBehind = numCommitsBehind;
    this.commitMetaOfHEAD = commitMetaOfHEAD;
    this.commonAncestorHash = commonAncestorHash;
    this.numTotalCommits = numTotalCommits;
  }

  /**
   * @return The value of the {@code numCommitsAhead} attribute
   */
  @JsonProperty("numCommitsAhead")
  @Override
  public @Nullable Integer getNumCommitsAhead() {
    return numCommitsAhead;
  }

  /**
   * @return The value of the {@code numCommitsBehind} attribute
   */
  @JsonProperty("numCommitsBehind")
  @Override
  public @Nullable Integer getNumCommitsBehind() {
    return numCommitsBehind;
  }

  /**
   * @return The value of the {@code commitMetaOfHEAD} attribute
   */
  @JsonProperty("commitMetaOfHEAD")
  @Override
  public @Nullable CommitMeta getCommitMetaOfHEAD() {
    return commitMetaOfHEAD;
  }

  /**
   * @return The value of the {@code commonAncestorHash} attribute
   */
  @JsonProperty("commonAncestorHash")
  @Override
  public @Nullable String getCommonAncestorHash() {
    return commonAncestorHash;
  }

  /**
   * @return The value of the {@code numTotalCommits} attribute
   */
  @JsonProperty("numTotalCommits")
  @Override
  public @Nullable Long getNumTotalCommits() {
    return numTotalCommits;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReferenceMetadata#getNumCommitsAhead() numCommitsAhead} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for numCommitsAhead (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReferenceMetadata withNumCommitsAhead(@Nullable Integer value) {
    if (Objects.equals(this.numCommitsAhead, value)) return this;
    return new ImmutableReferenceMetadata(
        value,
        this.numCommitsBehind,
        this.commitMetaOfHEAD,
        this.commonAncestorHash,
        this.numTotalCommits);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReferenceMetadata#getNumCommitsBehind() numCommitsBehind} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for numCommitsBehind (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReferenceMetadata withNumCommitsBehind(@Nullable Integer value) {
    if (Objects.equals(this.numCommitsBehind, value)) return this;
    return new ImmutableReferenceMetadata(
        this.numCommitsAhead,
        value,
        this.commitMetaOfHEAD,
        this.commonAncestorHash,
        this.numTotalCommits);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReferenceMetadata#getCommitMetaOfHEAD() commitMetaOfHEAD} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitMetaOfHEAD (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReferenceMetadata withCommitMetaOfHEAD(@Nullable CommitMeta value) {
    if (this.commitMetaOfHEAD == value) return this;
    return new ImmutableReferenceMetadata(
        this.numCommitsAhead,
        this.numCommitsBehind,
        value,
        this.commonAncestorHash,
        this.numTotalCommits);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReferenceMetadata#getCommonAncestorHash() commonAncestorHash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commonAncestorHash (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReferenceMetadata withCommonAncestorHash(@Nullable String value) {
    if (Objects.equals(this.commonAncestorHash, value)) return this;
    return new ImmutableReferenceMetadata(this.numCommitsAhead, this.numCommitsBehind, this.commitMetaOfHEAD, value, this.numTotalCommits);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReferenceMetadata#getNumTotalCommits() numTotalCommits} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for numTotalCommits (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReferenceMetadata withNumTotalCommits(@Nullable Long value) {
    if (Objects.equals(this.numTotalCommits, value)) return this;
    return new ImmutableReferenceMetadata(
        this.numCommitsAhead,
        this.numCommitsBehind,
        this.commitMetaOfHEAD,
        this.commonAncestorHash,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReferenceMetadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReferenceMetadata
        && equalTo(0, (ImmutableReferenceMetadata) another);
  }

  private boolean equalTo(int synthetic, ImmutableReferenceMetadata another) {
    return Objects.equals(numCommitsAhead, another.numCommitsAhead)
        && Objects.equals(numCommitsBehind, another.numCommitsBehind)
        && Objects.equals(commitMetaOfHEAD, another.commitMetaOfHEAD)
        && Objects.equals(commonAncestorHash, another.commonAncestorHash)
        && Objects.equals(numTotalCommits, another.numTotalCommits);
  }

  /**
   * Computes a hash code from attributes: {@code numCommitsAhead}, {@code numCommitsBehind}, {@code commitMetaOfHEAD}, {@code commonAncestorHash}, {@code numTotalCommits}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(numCommitsAhead);
    h += (h << 5) + Objects.hashCode(numCommitsBehind);
    h += (h << 5) + Objects.hashCode(commitMetaOfHEAD);
    h += (h << 5) + Objects.hashCode(commonAncestorHash);
    h += (h << 5) + Objects.hashCode(numTotalCommits);
    return h;
  }

  /**
   * Prints the immutable value {@code ReferenceMetadata} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReferenceMetadata{"
        + "numCommitsAhead=" + numCommitsAhead
        + ", numCommitsBehind=" + numCommitsBehind
        + ", commitMetaOfHEAD=" + commitMetaOfHEAD
        + ", commonAncestorHash=" + commonAncestorHash
        + ", numTotalCommits=" + numTotalCommits
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReferenceMetadata", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReferenceMetadata {
    @Nullable Integer numCommitsAhead;
    @Nullable Integer numCommitsBehind;
    @Nullable CommitMeta commitMetaOfHEAD;
    @Nullable String commonAncestorHash;
    @Nullable Long numTotalCommits;
    @JsonProperty("numCommitsAhead")
    public void setNumCommitsAhead(@Nullable Integer numCommitsAhead) {
      this.numCommitsAhead = numCommitsAhead;
    }
    @JsonProperty("numCommitsBehind")
    public void setNumCommitsBehind(@Nullable Integer numCommitsBehind) {
      this.numCommitsBehind = numCommitsBehind;
    }
    @JsonProperty("commitMetaOfHEAD")
    public void setCommitMetaOfHEAD(@Nullable CommitMeta commitMetaOfHEAD) {
      this.commitMetaOfHEAD = commitMetaOfHEAD;
    }
    @JsonProperty("commonAncestorHash")
    public void setCommonAncestorHash(@Nullable String commonAncestorHash) {
      this.commonAncestorHash = commonAncestorHash;
    }
    @JsonProperty("numTotalCommits")
    public void setNumTotalCommits(@Nullable Long numTotalCommits) {
      this.numTotalCommits = numTotalCommits;
    }
    @Override
    public Integer getNumCommitsAhead() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getNumCommitsBehind() { throw new UnsupportedOperationException(); }
    @Override
    public CommitMeta getCommitMetaOfHEAD() { throw new UnsupportedOperationException(); }
    @Override
    public String getCommonAncestorHash() { throw new UnsupportedOperationException(); }
    @Override
    public Long getNumTotalCommits() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableReferenceMetadata fromJson(Json json) {
    ImmutableReferenceMetadata.Builder builder = ImmutableReferenceMetadata.builder();
    if (json.numCommitsAhead != null) {
      builder.numCommitsAhead(json.numCommitsAhead);
    }
    if (json.numCommitsBehind != null) {
      builder.numCommitsBehind(json.numCommitsBehind);
    }
    if (json.commitMetaOfHEAD != null) {
      builder.commitMetaOfHEAD(json.commitMetaOfHEAD);
    }
    if (json.commonAncestorHash != null) {
      builder.commonAncestorHash(json.commonAncestorHash);
    }
    if (json.numTotalCommits != null) {
      builder.numTotalCommits(json.numTotalCommits);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReferenceMetadata} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ReferenceMetadata instance
   */
  public static ImmutableReferenceMetadata copyOf(ReferenceMetadata instance) {
    if (instance instanceof ImmutableReferenceMetadata) {
      return (ImmutableReferenceMetadata) instance;
    }
    return ImmutableReferenceMetadata.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReferenceMetadata ImmutableReferenceMetadata}.
   * <pre>
   * ImmutableReferenceMetadata.builder()
   *    .numCommitsAhead(Integer | null) // nullable {@link ReferenceMetadata#getNumCommitsAhead() numCommitsAhead}
   *    .numCommitsBehind(Integer | null) // nullable {@link ReferenceMetadata#getNumCommitsBehind() numCommitsBehind}
   *    .commitMetaOfHEAD(org.projectnessie.model.CommitMeta | null) // nullable {@link ReferenceMetadata#getCommitMetaOfHEAD() commitMetaOfHEAD}
   *    .commonAncestorHash(String | null) // nullable {@link ReferenceMetadata#getCommonAncestorHash() commonAncestorHash}
   *    .numTotalCommits(Long | null) // nullable {@link ReferenceMetadata#getNumTotalCommits() numTotalCommits}
   *    .build();
   * </pre>
   * @return A new ImmutableReferenceMetadata builder
   */
  public static ImmutableReferenceMetadata.Builder builder() {
    return new ImmutableReferenceMetadata.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableReferenceMetadata ImmutableReferenceMetadata}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReferenceMetadata", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Integer numCommitsAhead;
    private @Nullable Integer numCommitsBehind;
    private @Nullable CommitMeta commitMetaOfHEAD;
    private @Nullable String commonAncestorHash;
    private @Nullable Long numTotalCommits;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReferenceMetadata} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReferenceMetadata instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Integer numCommitsAheadValue = instance.getNumCommitsAhead();
      if (numCommitsAheadValue != null) {
        numCommitsAhead(numCommitsAheadValue);
      }
      @Nullable Integer numCommitsBehindValue = instance.getNumCommitsBehind();
      if (numCommitsBehindValue != null) {
        numCommitsBehind(numCommitsBehindValue);
      }
      @Nullable CommitMeta commitMetaOfHEADValue = instance.getCommitMetaOfHEAD();
      if (commitMetaOfHEADValue != null) {
        commitMetaOfHEAD(commitMetaOfHEADValue);
      }
      @Nullable String commonAncestorHashValue = instance.getCommonAncestorHash();
      if (commonAncestorHashValue != null) {
        commonAncestorHash(commonAncestorHashValue);
      }
      @Nullable Long numTotalCommitsValue = instance.getNumTotalCommits();
      if (numTotalCommitsValue != null) {
        numTotalCommits(numTotalCommitsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ReferenceMetadata#getNumCommitsAhead() numCommitsAhead} attribute.
     * @param numCommitsAhead The value for numCommitsAhead (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("numCommitsAhead")
    public final Builder numCommitsAhead(@Nullable Integer numCommitsAhead) {
      this.numCommitsAhead = numCommitsAhead;
      return this;
    }

    /**
     * Initializes the value for the {@link ReferenceMetadata#getNumCommitsBehind() numCommitsBehind} attribute.
     * @param numCommitsBehind The value for numCommitsBehind (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("numCommitsBehind")
    public final Builder numCommitsBehind(@Nullable Integer numCommitsBehind) {
      this.numCommitsBehind = numCommitsBehind;
      return this;
    }

    /**
     * Initializes the value for the {@link ReferenceMetadata#getCommitMetaOfHEAD() commitMetaOfHEAD} attribute.
     * @param commitMetaOfHEAD The value for commitMetaOfHEAD (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("commitMetaOfHEAD")
    public final Builder commitMetaOfHEAD(@Nullable CommitMeta commitMetaOfHEAD) {
      this.commitMetaOfHEAD = commitMetaOfHEAD;
      return this;
    }

    /**
     * Initializes the value for the {@link ReferenceMetadata#getCommonAncestorHash() commonAncestorHash} attribute.
     * @param commonAncestorHash The value for commonAncestorHash (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("commonAncestorHash")
    public final Builder commonAncestorHash(@Nullable String commonAncestorHash) {
      this.commonAncestorHash = commonAncestorHash;
      return this;
    }

    /**
     * Initializes the value for the {@link ReferenceMetadata#getNumTotalCommits() numTotalCommits} attribute.
     * @param numTotalCommits The value for numTotalCommits (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("numTotalCommits")
    public final Builder numTotalCommits(@Nullable Long numTotalCommits) {
      this.numTotalCommits = numTotalCommits;
      return this;
    }

    /**
     * Builds a new {@link ImmutableReferenceMetadata ImmutableReferenceMetadata}.
     * @return An immutable instance of ReferenceMetadata
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReferenceMetadata build() {
      return new ImmutableReferenceMetadata(numCommitsAhead, numCommitsBehind, commitMetaOfHEAD, commonAncestorHash, numTotalCommits);
    }
  }
}
