package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SqlView}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSqlView.builder()}.
 */
@Generated(from = "SqlView", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSqlView extends SqlView {
  private final String id;
  private final String sqlText;
  private final SqlView.Dialect dialect;

  private ImmutableSqlView(ImmutableSqlView.Builder builder) {
    this.sqlText = builder.sqlText;
    this.dialect = builder.dialect;
    this.id = builder.id != null
        ? builder.id
        : Objects.requireNonNull(super.getId(), "id");
  }

  private ImmutableSqlView(String id, String sqlText, SqlView.Dialect dialect) {
    this.id = id;
    this.sqlText = sqlText;
    this.dialect = dialect;
  }

  /**
   * Unique id for this object.
   * <p>This id is unique for the entire lifetime of this Content object and persists across
   * renames. Two content objects with the same key will have different id.
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code sqlText} attribute
   */
  @JsonProperty("sqlText")
  @Override
  public String getSqlText() {
    return sqlText;
  }

  /**
   * @return The value of the {@code dialect} attribute
   */
  @JsonProperty("dialect")
  @Override
  public SqlView.Dialect getDialect() {
    return dialect;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SqlView#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSqlView withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableSqlView(newValue, this.sqlText, this.dialect);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SqlView#getSqlText() sqlText} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sqlText
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSqlView withSqlText(String value) {
    String newValue = Objects.requireNonNull(value, "sqlText");
    if (this.sqlText.equals(newValue)) return this;
    return new ImmutableSqlView(this.id, newValue, this.dialect);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SqlView#getDialect() dialect} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dialect
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSqlView withDialect(SqlView.Dialect value) {
    SqlView.Dialect newValue = Objects.requireNonNull(value, "dialect");
    if (this.dialect == newValue) return this;
    return new ImmutableSqlView(this.id, this.sqlText, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSqlView} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSqlView
        && equalTo(0, (ImmutableSqlView) another);
  }

  private boolean equalTo(int synthetic, ImmutableSqlView another) {
    return id.equals(another.id)
        && sqlText.equals(another.sqlText)
        && dialect.equals(another.dialect);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code sqlText}, {@code dialect}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + sqlText.hashCode();
    h += (h << 5) + dialect.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SqlView} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SqlView{"
        + "id=" + id
        + ", sqlText=" + sqlText
        + ", dialect=" + dialect
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SqlView", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends SqlView {
    @Nullable String id;
    @Nullable String sqlText;
    @Nullable SqlView.Dialect dialect;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("sqlText")
    public void setSqlText(String sqlText) {
      this.sqlText = sqlText;
    }
    @JsonProperty("dialect")
    public void setDialect(SqlView.Dialect dialect) {
      this.dialect = dialect;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSqlText() { throw new UnsupportedOperationException(); }
    @Override
    public SqlView.Dialect getDialect() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSqlView fromJson(Json json) {
    ImmutableSqlView.Builder builder = ImmutableSqlView.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.sqlText != null) {
      builder.sqlText(json.sqlText);
    }
    if (json.dialect != null) {
      builder.dialect(json.dialect);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SqlView} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SqlView instance
   */
  public static ImmutableSqlView copyOf(SqlView instance) {
    if (instance instanceof ImmutableSqlView) {
      return (ImmutableSqlView) instance;
    }
    return ImmutableSqlView.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSqlView ImmutableSqlView}.
   * <pre>
   * ImmutableSqlView.builder()
   *    .id(String) // optional {@link SqlView#getId() id}
   *    .sqlText(String) // required {@link SqlView#getSqlText() sqlText}
   *    .dialect(org.projectnessie.model.SqlView.Dialect) // required {@link SqlView#getDialect() dialect}
   *    .build();
   * </pre>
   * @return A new ImmutableSqlView builder
   */
  public static ImmutableSqlView.Builder builder() {
    return new ImmutableSqlView.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSqlView ImmutableSqlView}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SqlView", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SQL_TEXT = 0x1L;
    private static final long INIT_BIT_DIALECT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable String sqlText;
    private @Nullable SqlView.Dialect dialect;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.SqlView} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SqlView instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Content} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Content instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SqlView) {
        SqlView instance = (SqlView) object;
        sqlText(instance.getSqlText());
        dialect(instance.getDialect());
      }
      if (object instanceof Content) {
        Content instance = (Content) object;
        id(instance.getId());
      }
    }

    /**
     * Initializes the value for the {@link SqlView#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SqlView#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the value for the {@link SqlView#getSqlText() sqlText} attribute.
     * @param sqlText The value for sqlText 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("sqlText")
    public final Builder sqlText(String sqlText) {
      this.sqlText = Objects.requireNonNull(sqlText, "sqlText");
      initBits &= ~INIT_BIT_SQL_TEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link SqlView#getDialect() dialect} attribute.
     * @param dialect The value for dialect 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("dialect")
    public final Builder dialect(SqlView.Dialect dialect) {
      this.dialect = Objects.requireNonNull(dialect, "dialect");
      initBits &= ~INIT_BIT_DIALECT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSqlView ImmutableSqlView}.
     * @return An immutable instance of SqlView
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSqlView build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSqlView(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SQL_TEXT) != 0) attributes.add("sqlText");
      if ((initBits & INIT_BIT_DIALECT) != 0) attributes.add("dialect");
      return "Cannot build SqlView, some of required attributes are not set " + attributes;
    }
  }
}
