package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Tag}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTag.builder()}.
 */
@Generated(from = "Tag", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTag implements Tag {
  private final String name;
  private final @Nullable String hash;
  private final @Nullable ReferenceMetadata metadata;

  private ImmutableTag(
      String name,
      @Nullable String hash,
      @Nullable ReferenceMetadata metadata) {
    this.name = name;
    this.hash = hash;
    this.metadata = metadata;
  }

  /**
   *Human-readable reference name. 
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   *backend system id. Usually the 32-byte hash of the commit this reference points to. 
   */
  @JsonProperty("hash")
  @Override
  public @Nullable String getHash() {
    return hash;
  }

  /**
   * Returns a {@link ReferenceMetadata} instance that contains additional metadata about this
   * reference. Note that this is <b>only added</b> by the server when <b>explicitly</b> requested
   * by the client.
   * @return A {@link ReferenceMetadata} instance that contains additional metadata about this
   *     reference. Note that this is <b>only added</b> by the server when <b>explicitly</b>
   *     requested by the client.
   */
  @JsonProperty("metadata")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  @Override
  public @Nullable ReferenceMetadata getMetadata() {
    return metadata;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Tag#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTag withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return validate(new ImmutableTag(newValue, this.hash, this.metadata));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Tag#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTag withHash(@Nullable String value) {
    if (Objects.equals(this.hash, value)) return this;
    return validate(new ImmutableTag(this.name, value, this.metadata));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Tag#getMetadata() metadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metadata (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTag withMetadata(@Nullable ReferenceMetadata value) {
    if (this.metadata == value) return this;
    return validate(new ImmutableTag(this.name, this.hash, value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTag} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTag
        && equalTo(0, (ImmutableTag) another);
  }

  private boolean equalTo(int synthetic, ImmutableTag another) {
    return name.equals(another.name)
        && Objects.equals(hash, another.hash)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code hash}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(hash);
    h += (h << 5) + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code Tag} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Tag{"
        + "name=" + name
        + ", hash=" + hash
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Tag", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Tag {
    @Nullable String name;
    @Nullable String hash;
    @Nullable ReferenceMetadata metadata;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("hash")
    public void setHash(@Nullable String hash) {
      this.hash = hash;
    }
    @JsonProperty("metadata")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public void setMetadata(@Nullable ReferenceMetadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
    @Override
    public ReferenceMetadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTag fromJson(Json json) {
    ImmutableTag.Builder builder = ImmutableTag.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  private static ImmutableTag validate(ImmutableTag instance) {
    instance.checkName();
    instance.checkHash();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Tag} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Tag instance
   */
  public static ImmutableTag copyOf(Tag instance) {
    if (instance instanceof ImmutableTag) {
      return (ImmutableTag) instance;
    }
    return ImmutableTag.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTag ImmutableTag}.
   * <pre>
   * ImmutableTag.builder()
   *    .name(String) // required {@link Tag#getName() name}
   *    .hash(String | null) // nullable {@link Tag#getHash() hash}
   *    .metadata(org.projectnessie.model.ReferenceMetadata | null) // nullable {@link Tag#getMetadata() metadata}
   *    .build();
   * </pre>
   * @return A new ImmutableTag builder
   */
  public static ImmutableTag.Builder builder() {
    return new ImmutableTag.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTag ImmutableTag}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Tag", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private @Nullable String hash;
    private @Nullable ReferenceMetadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Reference} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Reference instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Tag} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Tag instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Reference) {
        Reference instance = (Reference) object;
        name(instance.getName());
        @Nullable ReferenceMetadata metadataValue = instance.getMetadata();
        if (metadataValue != null) {
          metadata(metadataValue);
        }
        @Nullable String hashValue = instance.getHash();
        if (hashValue != null) {
          hash(hashValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link Tag#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Tag#getHash() hash} attribute.
     * @param hash The value for hash (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hash")
    public final Builder hash(@Nullable String hash) {
      this.hash = hash;
      return this;
    }

    /**
     * Initializes the value for the {@link Tag#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("metadata")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public final Builder metadata(@Nullable ReferenceMetadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTag ImmutableTag}.
     * @return An immutable instance of Tag
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTag build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableTag.validate(new ImmutableTag(name, hash, metadata));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Tag, some of required attributes are not set " + attributes;
    }
  }
}
