/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Branch", generator="Immutables")
@Immutable
public final class ImmutableBranch
implements Branch {
    private final String name;
    @Nullable
    private final String hash;
    @Nullable
    private final ReferenceMetadata metadata;

    private ImmutableBranch(String name, @Nullable String hash, @Nullable ReferenceMetadata metadata) {
        this.name = name;
        this.hash = hash;
        this.metadata = metadata;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="hash")
    @Nullable
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public ReferenceMetadata getMetadata() {
        return this.metadata;
    }

    public final ImmutableBranch withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return ImmutableBranch.validate(new ImmutableBranch(newValue, this.hash, this.metadata));
    }

    public final ImmutableBranch withHash(@Nullable String value) {
        if (Objects.equals(this.hash, value)) {
            return this;
        }
        return ImmutableBranch.validate(new ImmutableBranch(this.name, value, this.metadata));
    }

    public final ImmutableBranch withMetadata(@Nullable ReferenceMetadata value) {
        if (this.metadata == value) {
            return this;
        }
        return ImmutableBranch.validate(new ImmutableBranch(this.name, this.hash, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBranch && this.equalTo(0, (ImmutableBranch)another);
    }

    private boolean equalTo(int synthetic, ImmutableBranch another) {
        return this.name.equals(another.name) && Objects.equals(this.hash, another.hash) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.hash);
        h += (h << 5) + Objects.hashCode(this.metadata);
        return h;
    }

    public String toString() {
        return "Branch{name=" + this.name + ", hash=" + this.hash + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBranch fromJson(Json json) {
        Builder builder = ImmutableBranch.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        return builder.build();
    }

    private static ImmutableBranch validate(ImmutableBranch instance) {
        instance.checkName();
        instance.checkHash();
        return instance;
    }

    public static ImmutableBranch copyOf(Branch instance) {
        if (instance instanceof ImmutableBranch) {
            return (ImmutableBranch)instance;
        }
        return ImmutableBranch.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Branch", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        @Nullable
        private String hash;
        @Nullable
        private ReferenceMetadata metadata;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Reference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Branch instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof Reference) {
                String hashValue;
                Reference instance = (Reference)object;
                this.name(instance.getName());
                ReferenceMetadata metadataValue = instance.getMetadata();
                if (metadataValue != null) {
                    this.metadata(metadataValue);
                }
                if ((hashValue = instance.getHash()) != null) {
                    this.hash(hashValue);
                }
            }
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder hash(@Nullable String hash) {
            this.hash = hash;
            return this;
        }

        @JsonProperty(value="metadata")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @CanIgnoreReturnValue
        public final Builder metadata(@Nullable ReferenceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public ImmutableBranch build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableBranch.validate(new ImmutableBranch(this.name, this.hash, this.metadata));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Branch, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Branch", generator="Immutables")
    static final class Json
    implements Branch {
        @Nullable
        String name;
        @Nullable
        String hash;
        @Nullable
        ReferenceMetadata metadata;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="hash")
        public void setHash(@Nullable String hash) {
            this.hash = hash;
        }

        @JsonProperty(value="metadata")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setMetadata(@Nullable ReferenceMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceMetadata getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

