package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Operation.Delete}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDelete.builder()}.
 */
@Generated(from = "Operation.Delete", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDelete implements Operation.Delete {
  private final ContentKey key;

  private ImmutableDelete(ContentKey key) {
    this.key = key;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @JsonProperty("key")
  @Override
  public ContentKey getKey() {
    return key;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Operation.Delete#getKey() key} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDelete withKey(ContentKey value) {
    if (this.key == value) return this;
    ContentKey newValue = Objects.requireNonNull(value, "key");
    return new ImmutableDelete(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDelete} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDelete
        && equalTo(0, (ImmutableDelete) another);
  }

  private boolean equalTo(int synthetic, ImmutableDelete another) {
    return key.equals(another.key);
  }

  /**
   * Computes a hash code from attributes: {@code key}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + key.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Delete} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Delete{"
        + "key=" + key
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Operation.Delete", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Operation.Delete {
    @Nullable ContentKey key;
    @JsonProperty("key")
    public void setKey(ContentKey key) {
      this.key = key;
    }
    @Override
    public ContentKey getKey() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDelete fromJson(Json json) {
    ImmutableDelete.Builder builder = ImmutableDelete.builder();
    if (json.key != null) {
      builder.key(json.key);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Operation.Delete} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Delete instance
   */
  public static ImmutableDelete copyOf(Operation.Delete instance) {
    if (instance instanceof ImmutableDelete) {
      return (ImmutableDelete) instance;
    }
    return ImmutableDelete.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDelete ImmutableDelete}.
   * <pre>
   * ImmutableDelete.builder()
   *    .key(org.projectnessie.model.ContentKey) // required {@link Operation.Delete#getKey() key}
   *    .build();
   * </pre>
   * @return A new ImmutableDelete builder
   */
  public static ImmutableDelete.Builder builder() {
    return new ImmutableDelete.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDelete ImmutableDelete}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Operation.Delete", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ContentKey key;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Operation} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Operation instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Operation.Delete} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Operation.Delete instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof Operation) {
        Operation instance = (Operation) object;
        if ((bits & 0x1L) == 0) {
          key(instance.getKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof Operation.Delete) {
        Operation.Delete instance = (Operation.Delete) object;
        if ((bits & 0x1L) == 0) {
          key(instance.getKey());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Operation.Delete#getKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("key")
    public final Builder key(ContentKey key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDelete ImmutableDelete}.
     * @return An immutable instance of Delete
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDelete build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDelete(key);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      return "Cannot build Delete, some of required attributes are not set " + attributes;
    }
  }
}
