package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LogResponse.LogEntry}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLogEntry.builder()}.
 */
@Generated(from = "LogResponse.LogEntry", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLogEntry implements LogResponse.LogEntry {
  private final CommitMeta commitMeta;
  private final @Nullable String parentCommitHash;
  private final @Nullable List<Operation> operations;

  private ImmutableLogEntry(
      CommitMeta commitMeta,
      @Nullable String parentCommitHash,
      @Nullable List<Operation> operations) {
    this.commitMeta = commitMeta;
    this.parentCommitHash = parentCommitHash;
    this.operations = operations;
  }

  /**
   * @return The value of the {@code commitMeta} attribute
   */
  @JsonProperty("commitMeta")
  @Override
  public CommitMeta getCommitMeta() {
    return commitMeta;
  }

  /**
   * @return The value of the {@code parentCommitHash} attribute
   */
  @JsonProperty("parentCommitHash")
  @Override
  public @Nullable String getParentCommitHash() {
    return parentCommitHash;
  }

  /**
   * @return The value of the {@code operations} attribute
   */
  @JsonProperty("operations")
  @Override
  public @Nullable List<Operation> getOperations() {
    return operations;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LogResponse.LogEntry#getCommitMeta() commitMeta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitMeta
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLogEntry withCommitMeta(CommitMeta value) {
    if (this.commitMeta == value) return this;
    CommitMeta newValue = Objects.requireNonNull(value, "commitMeta");
    return new ImmutableLogEntry(newValue, this.parentCommitHash, this.operations);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LogResponse.LogEntry#getParentCommitHash() parentCommitHash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for parentCommitHash (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLogEntry withParentCommitHash(@Nullable String value) {
    if (Objects.equals(this.parentCommitHash, value)) return this;
    return new ImmutableLogEntry(this.commitMeta, value, this.operations);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LogResponse.LogEntry#getOperations() operations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLogEntry withOperations(@Nullable Operation... elements) {
    if (elements == null) {
      return new ImmutableLogEntry(this.commitMeta, this.parentCommitHash, null);
    }
    @Nullable List<Operation> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableLogEntry(this.commitMeta, this.parentCommitHash, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LogResponse.LogEntry#getOperations() operations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of operations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLogEntry withOperations(@Nullable Iterable<? extends Operation> elements) {
    if (this.operations == elements) return this;
    @Nullable List<Operation> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableLogEntry(this.commitMeta, this.parentCommitHash, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLogEntry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLogEntry
        && equalTo(0, (ImmutableLogEntry) another);
  }

  private boolean equalTo(int synthetic, ImmutableLogEntry another) {
    return commitMeta.equals(another.commitMeta)
        && Objects.equals(parentCommitHash, another.parentCommitHash)
        && Objects.equals(operations, another.operations);
  }

  /**
   * Computes a hash code from attributes: {@code commitMeta}, {@code parentCommitHash}, {@code operations}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + commitMeta.hashCode();
    h += (h << 5) + Objects.hashCode(parentCommitHash);
    h += (h << 5) + Objects.hashCode(operations);
    return h;
  }

  /**
   * Prints the immutable value {@code LogEntry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LogEntry{"
        + "commitMeta=" + commitMeta
        + ", parentCommitHash=" + parentCommitHash
        + ", operations=" + operations
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "LogResponse.LogEntry", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements LogResponse.LogEntry {
    @Nullable CommitMeta commitMeta;
    @Nullable String parentCommitHash;
    @Nullable List<Operation> operations = null;
    @JsonProperty("commitMeta")
    public void setCommitMeta(CommitMeta commitMeta) {
      this.commitMeta = commitMeta;
    }
    @JsonProperty("parentCommitHash")
    public void setParentCommitHash(@Nullable String parentCommitHash) {
      this.parentCommitHash = parentCommitHash;
    }
    @JsonProperty("operations")
    public void setOperations(@Nullable List<Operation> operations) {
      this.operations = operations;
    }
    @Override
    public CommitMeta getCommitMeta() { throw new UnsupportedOperationException(); }
    @Override
    public String getParentCommitHash() { throw new UnsupportedOperationException(); }
    @Override
    public List<Operation> getOperations() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLogEntry fromJson(Json json) {
    ImmutableLogEntry.Builder builder = ImmutableLogEntry.builder();
    if (json.commitMeta != null) {
      builder.commitMeta(json.commitMeta);
    }
    if (json.parentCommitHash != null) {
      builder.parentCommitHash(json.parentCommitHash);
    }
    if (json.operations != null) {
      builder.addAllOperations(json.operations);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link LogResponse.LogEntry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LogEntry instance
   */
  public static ImmutableLogEntry copyOf(LogResponse.LogEntry instance) {
    if (instance instanceof ImmutableLogEntry) {
      return (ImmutableLogEntry) instance;
    }
    return ImmutableLogEntry.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLogEntry ImmutableLogEntry}.
   * <pre>
   * ImmutableLogEntry.builder()
   *    .commitMeta(org.projectnessie.model.CommitMeta) // required {@link LogResponse.LogEntry#getCommitMeta() commitMeta}
   *    .parentCommitHash(String | null) // nullable {@link LogResponse.LogEntry#getParentCommitHash() parentCommitHash}
   *    .operations(List&amp;lt;org.projectnessie.model.Operation&amp;gt; | null) // nullable {@link LogResponse.LogEntry#getOperations() operations}
   *    .build();
   * </pre>
   * @return A new ImmutableLogEntry builder
   */
  public static ImmutableLogEntry.Builder builder() {
    return new ImmutableLogEntry.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLogEntry ImmutableLogEntry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LogResponse.LogEntry", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_COMMIT_META = 0x1L;
    private long initBits = 0x1L;

    private @Nullable CommitMeta commitMeta;
    private @Nullable String parentCommitHash;
    private List<Operation> operations = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LogEntry} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(LogResponse.LogEntry instance) {
      Objects.requireNonNull(instance, "instance");
      commitMeta(instance.getCommitMeta());
      @Nullable String parentCommitHashValue = instance.getParentCommitHash();
      if (parentCommitHashValue != null) {
        parentCommitHash(parentCommitHashValue);
      }
      @Nullable List<Operation> operationsValue = instance.getOperations();
      if (operationsValue != null) {
        addAllOperations(operationsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link LogResponse.LogEntry#getCommitMeta() commitMeta} attribute.
     * @param commitMeta The value for commitMeta 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("commitMeta")
    public final Builder commitMeta(CommitMeta commitMeta) {
      this.commitMeta = Objects.requireNonNull(commitMeta, "commitMeta");
      initBits &= ~INIT_BIT_COMMIT_META;
      return this;
    }

    /**
     * Initializes the value for the {@link LogResponse.LogEntry#getParentCommitHash() parentCommitHash} attribute.
     * @param parentCommitHash The value for parentCommitHash (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("parentCommitHash")
    public final Builder parentCommitHash(@Nullable String parentCommitHash) {
      this.parentCommitHash = parentCommitHash;
      return this;
    }

    /**
     * Adds one element to {@link LogResponse.LogEntry#getOperations() operations} list.
     * @param element A operations element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOperations(Operation element) {
      if (this.operations == null) {
        this.operations = new ArrayList<Operation>();
      }
      this.operations.add(Objects.requireNonNull(element, "operations element"));
      return this;
    }

    /**
     * Adds elements to {@link LogResponse.LogEntry#getOperations() operations} list.
     * @param elements An array of operations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOperations(Operation... elements) {
      if (this.operations == null) {
        this.operations = new ArrayList<Operation>();
      }
      for (Operation element : elements) {
        this.operations.add(Objects.requireNonNull(element, "operations element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LogResponse.LogEntry#getOperations() operations} list.
     * @param elements An iterable of operations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("operations")
    public final Builder operations(@Nullable Iterable<? extends Operation> elements) {
      if (elements == null) {
        this.operations = null;
        return this;
      }
      this.operations = new ArrayList<Operation>();
      return addAllOperations(elements);
    }

    /**
     * Adds elements to {@link LogResponse.LogEntry#getOperations() operations} list.
     * @param elements An iterable of operations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllOperations(Iterable<? extends Operation> elements) {
      Objects.requireNonNull(elements, "operations element");
      if (this.operations == null) {
        this.operations = new ArrayList<Operation>();
      }
      for (Operation element : elements) {
        this.operations.add(Objects.requireNonNull(element, "operations element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableLogEntry ImmutableLogEntry}.
     * @return An immutable instance of LogEntry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLogEntry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLogEntry(
          commitMeta,
          parentCommitHash,
          operations == null ? null : createUnmodifiableList(true, operations));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_COMMIT_META) != 0) attributes.add("commitMeta");
      return "Cannot build LogEntry, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
