/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.PathParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;

public class DiffParams {
    public static final String HASH_OPTIONAL_REGEX = "(^[0-9a-fA-F]{8,64}$)?";
    @NotNull
    @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    @Parameter(description="The 'from' reference to start the diff from", examples={@ExampleObject(ref="ref")})
    @PathParam(value="fromRef")
    private @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String fromRef;
    @Nullable
    @Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes")
    @Parameter(description="Optional hash on the 'from' reference to start the diff from", examples={@ExampleObject(ref="hash")})
    @PathParam(value="fromHashOnRef")
    private @Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes") String fromHashOnRef;
    @NotNull
    @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    @Parameter(description="The 'to' reference to end the diff at.", examples={@ExampleObject(ref="ref")})
    @PathParam(value="toRef")
    private @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String toRef;
    @Nullable
    @Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes")
    @Parameter(description="Optional hash on the 'to' reference to end the diff at.", examples={@ExampleObject(ref="hash")})
    @PathParam(value="toHashOnRef")
    private @Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes") String toHashOnRef;

    public DiffParams() {
    }

    private DiffParams(String fromRef, String fromHashOnRef, String toRef, String toHashOnRef) {
        this.fromRef = fromRef;
        this.fromHashOnRef = fromHashOnRef;
        this.toRef = toRef;
        this.toHashOnRef = toHashOnRef;
    }

    private DiffParams(Builder builder) {
        this(builder.fromRef, builder.fromHashOnRef, builder.toRef, builder.toHashOnRef);
    }

    public String getFromRef() {
        return this.fromRef;
    }

    public String getFromHashOnRef() {
        return DiffParams.emptyToNull(this.fromHashOnRef);
    }

    public String getToRef() {
        return this.toRef;
    }

    public String getToHashOnRef() {
        return DiffParams.emptyToNull(this.toHashOnRef);
    }

    private static String emptyToNull(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (s.charAt(0) == '*') {
            if (s.length() == 1) {
                return null;
            }
            return s.substring(1);
        }
        return s;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiffParams that = (DiffParams)o;
        return Objects.equals(this.fromRef, that.fromRef) && Objects.equals(this.fromHashOnRef, that.fromHashOnRef) && Objects.equals(this.toRef, that.toRef) && Objects.equals(this.toHashOnRef, that.toHashOnRef);
    }

    public int hashCode() {
        return Objects.hash(this.fromRef, this.fromHashOnRef, this.toRef, this.toHashOnRef);
    }

    public static class Builder {
        private String fromRef;
        private String fromHashOnRef;
        private String toRef;
        private String toHashOnRef;

        public Builder from(DiffParams params) {
            return this.fromRef(params.fromRef).fromHashOnRef(params.fromHashOnRef).toRef(params.toRef).toHashOnRef(params.toHashOnRef);
        }

        public Builder fromRef(String fromRef) {
            this.fromRef = fromRef;
            return this;
        }

        public Builder fromHashOnRef(String fromHashOnRef) {
            this.fromHashOnRef = fromHashOnRef;
            return this;
        }

        public Builder toRef(String toRef) {
            this.toRef = toRef;
            return this;
        }

        public Builder toHashOnRef(String toHashOnRef) {
            this.toHashOnRef = toHashOnRef;
            return this;
        }

        private void validate() {
            Objects.requireNonNull(this.fromRef, "fromRef must be non-null");
            Objects.requireNonNull(this.toRef, "toRef must be non-null");
        }

        public DiffParams build() {
            this.validate();
            return new DiffParams(this);
        }
    }
}

