/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.ImmutableIcebergView;

@JsonSerialize(as=ImmutableIcebergView.class)
@JsonDeserialize(as=ImmutableIcebergView.class)
@JsonTypeName(value="ICEBERG_VIEW")
@Value.Immutable
public abstract class IcebergView
extends Content {
    @NotNull
    @NotBlank
    public abstract String getMetadataLocation();

    public abstract int getVersionId();

    public abstract int getSchemaId();

    @NotBlank
    @NotNull
    public abstract String getSqlText();

    @NotNull
    @NotBlank
    public abstract String getDialect();

    @Override
    public Content.Type getType() {
        return Content.Type.ICEBERG_VIEW;
    }

    public static IcebergView of(String metadataLocation, int versionId, int schemaId, String dialect, String sqlText) {
        return ImmutableIcebergView.builder().metadataLocation(metadataLocation).versionId(versionId).schemaId(schemaId).dialect(dialect).sqlText(sqlText).build();
    }

    public static IcebergView of(String id, String metadataLocation, int versionId, int schemaId, String dialect, String sqlText) {
        return ImmutableIcebergView.builder().id(id).metadataLocation(metadataLocation).versionId(versionId).schemaId(schemaId).dialect(dialect).sqlText(sqlText).build();
    }
}

