package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NessieConfiguration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNessieConfiguration.builder()}.
 */
@Generated(from = "NessieConfiguration", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNessieConfiguration extends NessieConfiguration {
  private final @Nullable String defaultBranch;
  private final int maxSupportedApiVersion;

  private ImmutableNessieConfiguration(@Nullable String defaultBranch, int maxSupportedApiVersion) {
    this.defaultBranch = defaultBranch;
    this.maxSupportedApiVersion = maxSupportedApiVersion;
  }

  /**
   * The name of the default branch that the server will use unless an explicit branch was specified
   * as an API call parameter.
   */
  @JsonProperty("defaultBranch")
  @Override
  public @Nullable String getDefaultBranch() {
    return defaultBranch;
  }

  /**
   * The maximum API version supported by the server.
   * <p>API versions are numbered sequentially, as they are developed.
   */
  @JsonProperty("maxSupportedApiVersion")
  @Override
  public int getMaxSupportedApiVersion() {
    return maxSupportedApiVersion;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NessieConfiguration#getDefaultBranch() defaultBranch} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultBranch (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNessieConfiguration withDefaultBranch(@Nullable String value) {
    if (Objects.equals(this.defaultBranch, value)) return this;
    return new ImmutableNessieConfiguration(value, this.maxSupportedApiVersion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NessieConfiguration#getMaxSupportedApiVersion() maxSupportedApiVersion} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxSupportedApiVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNessieConfiguration withMaxSupportedApiVersion(int value) {
    if (this.maxSupportedApiVersion == value) return this;
    return new ImmutableNessieConfiguration(this.defaultBranch, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNessieConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNessieConfiguration
        && equalTo(0, (ImmutableNessieConfiguration) another);
  }

  private boolean equalTo(int synthetic, ImmutableNessieConfiguration another) {
    return Objects.equals(defaultBranch, another.defaultBranch)
        && maxSupportedApiVersion == another.maxSupportedApiVersion;
  }

  /**
   * Computes a hash code from attributes: {@code defaultBranch}, {@code maxSupportedApiVersion}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(defaultBranch);
    h += (h << 5) + maxSupportedApiVersion;
    return h;
  }

  /**
   * Prints the immutable value {@code NessieConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NessieConfiguration{"
        + "defaultBranch=" + defaultBranch
        + ", maxSupportedApiVersion=" + maxSupportedApiVersion
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "NessieConfiguration", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends NessieConfiguration {
    @Nullable String defaultBranch;
    int maxSupportedApiVersion;
    boolean maxSupportedApiVersionIsSet;
    @JsonProperty("defaultBranch")
    public void setDefaultBranch(@Nullable String defaultBranch) {
      this.defaultBranch = defaultBranch;
    }
    @JsonProperty("maxSupportedApiVersion")
    public void setMaxSupportedApiVersion(int maxSupportedApiVersion) {
      this.maxSupportedApiVersion = maxSupportedApiVersion;
      this.maxSupportedApiVersionIsSet = true;
    }
    @Override
    public String getDefaultBranch() { throw new UnsupportedOperationException(); }
    @Override
    public int getMaxSupportedApiVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableNessieConfiguration fromJson(Json json) {
    ImmutableNessieConfiguration.Builder builder = ImmutableNessieConfiguration.builder();
    if (json.defaultBranch != null) {
      builder.defaultBranch(json.defaultBranch);
    }
    if (json.maxSupportedApiVersionIsSet) {
      builder.maxSupportedApiVersion(json.maxSupportedApiVersion);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link NessieConfiguration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NessieConfiguration instance
   */
  public static ImmutableNessieConfiguration copyOf(NessieConfiguration instance) {
    if (instance instanceof ImmutableNessieConfiguration) {
      return (ImmutableNessieConfiguration) instance;
    }
    return ImmutableNessieConfiguration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNessieConfiguration ImmutableNessieConfiguration}.
   * <pre>
   * ImmutableNessieConfiguration.builder()
   *    .defaultBranch(String | null) // nullable {@link NessieConfiguration#getDefaultBranch() defaultBranch}
   *    .maxSupportedApiVersion(int) // required {@link NessieConfiguration#getMaxSupportedApiVersion() maxSupportedApiVersion}
   *    .build();
   * </pre>
   * @return A new ImmutableNessieConfiguration builder
   */
  public static ImmutableNessieConfiguration.Builder builder() {
    return new ImmutableNessieConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNessieConfiguration ImmutableNessieConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NessieConfiguration", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MAX_SUPPORTED_API_VERSION = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String defaultBranch;
    private int maxSupportedApiVersion;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NessieConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NessieConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String defaultBranchValue = instance.getDefaultBranch();
      if (defaultBranchValue != null) {
        defaultBranch(defaultBranchValue);
      }
      maxSupportedApiVersion(instance.getMaxSupportedApiVersion());
      return this;
    }

    /**
     * Initializes the value for the {@link NessieConfiguration#getDefaultBranch() defaultBranch} attribute.
     * @param defaultBranch The value for defaultBranch (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("defaultBranch")
    public final Builder defaultBranch(@Nullable String defaultBranch) {
      this.defaultBranch = defaultBranch;
      return this;
    }

    /**
     * Initializes the value for the {@link NessieConfiguration#getMaxSupportedApiVersion() maxSupportedApiVersion} attribute.
     * @param maxSupportedApiVersion The value for maxSupportedApiVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("maxSupportedApiVersion")
    public final Builder maxSupportedApiVersion(int maxSupportedApiVersion) {
      this.maxSupportedApiVersion = maxSupportedApiVersion;
      initBits &= ~INIT_BIT_MAX_SUPPORTED_API_VERSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNessieConfiguration ImmutableNessieConfiguration}.
     * @return An immutable instance of NessieConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNessieConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNessieConfiguration(defaultBranch, maxSupportedApiVersion);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MAX_SUPPORTED_API_VERSION) != 0) attributes.add("maxSupportedApiVersion");
      return "Cannot build NessieConfiguration, some of required attributes are not set " + attributes;
    }
  }
}
