/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Validation;

class TestValidation {
    TestValidation() {
    }

    @ParameterizedTest
    @ValueSource(strings={"a", "a_b-", "a_-c", "abc/def"})
    void validRefNames(String referenceName) {
        Validation.validateReferenceName((String)referenceName);
        Validation.validateReferenceNameOrHash((String)referenceName);
        Branch.of((String)referenceName, null);
        Tag.of((String)referenceName, null);
        AssertionsForClassTypes.assertThat((boolean)Validation.isForbiddenReferenceName((String)referenceName)).isFalse();
        AssertionsForClassTypes.assertThatNoException().isThrownBy(() -> Validation.validateForbiddenReferenceName((String)referenceName));
    }

    @ParameterizedTest
    @ValueSource(strings={"", "abc/", ".foo", "abc/def/../blah", "abc/de..blah", "abc/de@{blah"})
    void invalidRefNames(String referenceName) {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((Object)("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..' - but was: " + referenceName), (Object)((IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Validation.validateReferenceName((String)referenceName))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)("Reference must be either a reference name or hash, start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..' or consist of the hex representation of 4-32 bytes - but was: " + referenceName), (Object)((IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Validation.validateReferenceNameOrHash((String)referenceName))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..' - but was: " + referenceName), (Object)((IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Branch.of((String)referenceName, null))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..' - but was: " + referenceName), (Object)((IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Tag.of((String)referenceName, null))).getMessage())});
    }

    @Test
    void nullParam() {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> Validation.validateReferenceName(null)), () -> org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> Branch.of(null, null)), () -> org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> Tag.of(null, null))});
    }

    @ParameterizedTest
    @ValueSource(strings={"DETACHED", "HEAD", "detached", "head", "dEtAcHeD", "hEaD"})
    void forbiddenReferenceNames(String refName) {
        AssertionsForClassTypes.assertThat((boolean)Validation.isForbiddenReferenceName((String)refName)).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Validation.validateForbiddenReferenceName((String)refName)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Reference name mut not be HEAD, DETACHED or a potential commit ID representation.");
    }

    @ParameterizedTest
    @ValueSource(strings={"1122334455667788990011223344556677889900112233445566778899001122", "abcDEF4242424242424242424242BEEF00DEAD42112233445566778899001122", "0011223344556677", "11223344556677889900", "cafebabedeadbeef", "CAFEBABEDEADBEEF", "caffee20", "20caffee", "20caff22"})
    void validHashes(String hash) {
        Validation.validateHash((String)hash);
        Validation.validateReferenceNameOrHash((String)hash);
        AssertionsForClassTypes.assertThat((boolean)Validation.isForbiddenReferenceName((String)hash)).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Validation.validateForbiddenReferenceName((String)hash)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Reference name mut not be HEAD, DETACHED or a potential commit ID representation.");
    }

    @ParameterizedTest
    @ValueSource(strings={"", "abc/", ".foo", "abc/def/../blah", "abc/de..blah", "abc/de@{blah"})
    void invalidHashes(String hash) {
        String referenceName = "thisIsAValidName";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((Object)("Hash must consist of the hex representation of 4-32 bytes - but was: " + hash), (Object)((IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Validation.validateHash((String)hash))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)("Hash must consist of the hex representation of 4-32 bytes - but was: " + hash), (Object)((IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Branch.of((String)referenceName, (String)hash))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)("Hash must consist of the hex representation of 4-32 bytes - but was: " + hash), (Object)((IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Tag.of((String)referenceName, (String)hash))).getMessage())});
    }

    @ParameterizedTest
    @CsvSource(value={"a,112233445566778899001122abcDEF4242424242424242424242BEEF00DEAD42", "a,1122334455667788990011221122334455667788990011223344556677889900", "a_b-,112233445566778899001122abcDEF4242424242424242424242BEEF00DEAD42", "a_b-,1122334455667788990011221122334455667788990011223344556677889900", "a_-c,1122334455667788", "a_-c,112233445566778899001122", "abc/def,1122334455667788990011223344556677889900", "coffee20,1122334455667788990011223344556677889900", "coffee2go,1122334455667788990011223344556677889900"})
    void validNamesAndHashes(String referenceName, String hash) {
        Branch.of((String)referenceName, (String)hash);
        Tag.of((String)referenceName, (String)hash);
    }

    @ParameterizedTest
    @CsvSource(value={"a,abcDEF4242424242424242424242BEEF00DEADxy", "a,11", "a_b-,meep", "a_b-,0", "a_-c,##", "a_-c,123", "abc/def,nonono"})
    void validNamesAndInvalidHashes(String referenceName, String hash) {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((Object)("Hash must consist of the hex representation of 4-32 bytes - but was: " + hash), (Object)((IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Branch.of((String)referenceName, (String)hash))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)("Hash must consist of the hex representation of 4-32 bytes - but was: " + hash), (Object)((IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Tag.of((String)referenceName, (String)hash))).getMessage())});
    }
}

