package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link IcebergView}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableIcebergView.builder()}.
 */
@Generated(from = "IcebergView", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableIcebergView extends IcebergView {
  private final String id;
  private final String metadataLocation;
  private final int versionId;
  private final int schemaId;
  private final String sqlText;
  private final String dialect;

  private ImmutableIcebergView(ImmutableIcebergView.Builder builder) {
    this.metadataLocation = builder.metadataLocation;
    this.versionId = builder.versionId;
    this.schemaId = builder.schemaId;
    this.sqlText = builder.sqlText;
    this.dialect = builder.dialect;
    this.id = builder.id != null
        ? builder.id
        : Objects.requireNonNull(super.getId(), "id");
  }

  private ImmutableIcebergView(
      String id,
      String metadataLocation,
      int versionId,
      int schemaId,
      String sqlText,
      String dialect) {
    this.id = id;
    this.metadataLocation = metadataLocation;
    this.versionId = versionId;
    this.schemaId = schemaId;
    this.sqlText = sqlText;
    this.dialect = dialect;
  }

  /**
   * Unique id for this object.
   * <p>This id is unique for the entire lifetime of this Content object and persists across
   * renames. Two content objects with the same key will have different id.
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Location where Iceberg stored its {@code ViewMetadata} file. The location depends on the
   * (implementation of) Iceberg's {@code FileIO} configured for the particular Iceberg table.
   */
  @JsonProperty("metadataLocation")
  @Override
  public String getMetadataLocation() {
    return metadataLocation;
  }

  /**
   * @return The value of the {@code versionId} attribute
   */
  @JsonProperty("versionId")
  @Override
  public int getVersionId() {
    return versionId;
  }

  /**
   * @return The value of the {@code schemaId} attribute
   */
  @JsonProperty("schemaId")
  @Override
  public int getSchemaId() {
    return schemaId;
  }

  /**
   * @return The value of the {@code sqlText} attribute
   */
  @JsonProperty("sqlText")
  @Override
  public String getSqlText() {
    return sqlText;
  }

  /**
   * @return The value of the {@code dialect} attribute
   */
  @JsonProperty("dialect")
  @Override
  public String getDialect() {
    return dialect;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcebergView#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIcebergView withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableIcebergView(newValue, this.metadataLocation, this.versionId, this.schemaId, this.sqlText, this.dialect);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcebergView#getMetadataLocation() metadataLocation} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metadataLocation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIcebergView withMetadataLocation(String value) {
    String newValue = Objects.requireNonNull(value, "metadataLocation");
    if (this.metadataLocation.equals(newValue)) return this;
    return new ImmutableIcebergView(this.id, newValue, this.versionId, this.schemaId, this.sqlText, this.dialect);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcebergView#getVersionId() versionId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for versionId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIcebergView withVersionId(int value) {
    if (this.versionId == value) return this;
    return new ImmutableIcebergView(this.id, this.metadataLocation, value, this.schemaId, this.sqlText, this.dialect);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcebergView#getSchemaId() schemaId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schemaId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIcebergView withSchemaId(int value) {
    if (this.schemaId == value) return this;
    return new ImmutableIcebergView(this.id, this.metadataLocation, this.versionId, value, this.sqlText, this.dialect);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcebergView#getSqlText() sqlText} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sqlText
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIcebergView withSqlText(String value) {
    String newValue = Objects.requireNonNull(value, "sqlText");
    if (this.sqlText.equals(newValue)) return this;
    return new ImmutableIcebergView(this.id, this.metadataLocation, this.versionId, this.schemaId, newValue, this.dialect);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcebergView#getDialect() dialect} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dialect
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIcebergView withDialect(String value) {
    String newValue = Objects.requireNonNull(value, "dialect");
    if (this.dialect.equals(newValue)) return this;
    return new ImmutableIcebergView(this.id, this.metadataLocation, this.versionId, this.schemaId, this.sqlText, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIcebergView} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIcebergView
        && equalTo(0, (ImmutableIcebergView) another);
  }

  private boolean equalTo(int synthetic, ImmutableIcebergView another) {
    return id.equals(another.id)
        && metadataLocation.equals(another.metadataLocation)
        && versionId == another.versionId
        && schemaId == another.schemaId
        && sqlText.equals(another.sqlText)
        && dialect.equals(another.dialect);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code metadataLocation}, {@code versionId}, {@code schemaId}, {@code sqlText}, {@code dialect}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + metadataLocation.hashCode();
    h += (h << 5) + versionId;
    h += (h << 5) + schemaId;
    h += (h << 5) + sqlText.hashCode();
    h += (h << 5) + dialect.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IcebergView} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "IcebergView{"
        + "id=" + id
        + ", metadataLocation=" + metadataLocation
        + ", versionId=" + versionId
        + ", schemaId=" + schemaId
        + ", sqlText=" + sqlText
        + ", dialect=" + dialect
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "IcebergView", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends IcebergView {
    @Nullable String id;
    @Nullable String metadataLocation;
    int versionId;
    boolean versionIdIsSet;
    int schemaId;
    boolean schemaIdIsSet;
    @Nullable String sqlText;
    @Nullable String dialect;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("metadataLocation")
    public void setMetadataLocation(String metadataLocation) {
      this.metadataLocation = metadataLocation;
    }
    @JsonProperty("versionId")
    public void setVersionId(int versionId) {
      this.versionId = versionId;
      this.versionIdIsSet = true;
    }
    @JsonProperty("schemaId")
    public void setSchemaId(int schemaId) {
      this.schemaId = schemaId;
      this.schemaIdIsSet = true;
    }
    @JsonProperty("sqlText")
    public void setSqlText(String sqlText) {
      this.sqlText = sqlText;
    }
    @JsonProperty("dialect")
    public void setDialect(String dialect) {
      this.dialect = dialect;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getMetadataLocation() { throw new UnsupportedOperationException(); }
    @Override
    public int getVersionId() { throw new UnsupportedOperationException(); }
    @Override
    public int getSchemaId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSqlText() { throw new UnsupportedOperationException(); }
    @Override
    public String getDialect() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableIcebergView fromJson(Json json) {
    ImmutableIcebergView.Builder builder = ImmutableIcebergView.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.metadataLocation != null) {
      builder.metadataLocation(json.metadataLocation);
    }
    if (json.versionIdIsSet) {
      builder.versionId(json.versionId);
    }
    if (json.schemaIdIsSet) {
      builder.schemaId(json.schemaId);
    }
    if (json.sqlText != null) {
      builder.sqlText(json.sqlText);
    }
    if (json.dialect != null) {
      builder.dialect(json.dialect);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link IcebergView} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IcebergView instance
   */
  public static ImmutableIcebergView copyOf(IcebergView instance) {
    if (instance instanceof ImmutableIcebergView) {
      return (ImmutableIcebergView) instance;
    }
    return ImmutableIcebergView.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableIcebergView ImmutableIcebergView}.
   * <pre>
   * ImmutableIcebergView.builder()
   *    .id(String) // optional {@link IcebergView#getId() id}
   *    .metadataLocation(String) // required {@link IcebergView#getMetadataLocation() metadataLocation}
   *    .versionId(int) // required {@link IcebergView#getVersionId() versionId}
   *    .schemaId(int) // required {@link IcebergView#getSchemaId() schemaId}
   *    .sqlText(String) // required {@link IcebergView#getSqlText() sqlText}
   *    .dialect(String) // required {@link IcebergView#getDialect() dialect}
   *    .build();
   * </pre>
   * @return A new ImmutableIcebergView builder
   */
  public static ImmutableIcebergView.Builder builder() {
    return new ImmutableIcebergView.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableIcebergView ImmutableIcebergView}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IcebergView", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_METADATA_LOCATION = 0x1L;
    private static final long INIT_BIT_VERSION_ID = 0x2L;
    private static final long INIT_BIT_SCHEMA_ID = 0x4L;
    private static final long INIT_BIT_SQL_TEXT = 0x8L;
    private static final long INIT_BIT_DIALECT = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String id;
    private @Nullable String metadataLocation;
    private int versionId;
    private int schemaId;
    private @Nullable String sqlText;
    private @Nullable String dialect;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.IcebergView} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(IcebergView instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Content} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Content instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IcebergView) {
        IcebergView instance = (IcebergView) object;
        metadataLocation(instance.getMetadataLocation());
        versionId(instance.getVersionId());
        sqlText(instance.getSqlText());
        dialect(instance.getDialect());
        schemaId(instance.getSchemaId());
      }
      if (object instanceof Content) {
        Content instance = (Content) object;
        id(instance.getId());
      }
    }

    /**
     * Initializes the value for the {@link IcebergView#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IcebergView#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the value for the {@link IcebergView#getMetadataLocation() metadataLocation} attribute.
     * @param metadataLocation The value for metadataLocation 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("metadataLocation")
    public final Builder metadataLocation(String metadataLocation) {
      this.metadataLocation = Objects.requireNonNull(metadataLocation, "metadataLocation");
      initBits &= ~INIT_BIT_METADATA_LOCATION;
      return this;
    }

    /**
     * Initializes the value for the {@link IcebergView#getVersionId() versionId} attribute.
     * @param versionId The value for versionId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("versionId")
    public final Builder versionId(int versionId) {
      this.versionId = versionId;
      initBits &= ~INIT_BIT_VERSION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link IcebergView#getSchemaId() schemaId} attribute.
     * @param schemaId The value for schemaId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("schemaId")
    public final Builder schemaId(int schemaId) {
      this.schemaId = schemaId;
      initBits &= ~INIT_BIT_SCHEMA_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link IcebergView#getSqlText() sqlText} attribute.
     * @param sqlText The value for sqlText 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("sqlText")
    public final Builder sqlText(String sqlText) {
      this.sqlText = Objects.requireNonNull(sqlText, "sqlText");
      initBits &= ~INIT_BIT_SQL_TEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link IcebergView#getDialect() dialect} attribute.
     * @param dialect The value for dialect 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("dialect")
    public final Builder dialect(String dialect) {
      this.dialect = Objects.requireNonNull(dialect, "dialect");
      initBits &= ~INIT_BIT_DIALECT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableIcebergView ImmutableIcebergView}.
     * @return An immutable instance of IcebergView
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableIcebergView build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableIcebergView(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_METADATA_LOCATION) != 0) attributes.add("metadataLocation");
      if ((initBits & INIT_BIT_VERSION_ID) != 0) attributes.add("versionId");
      if ((initBits & INIT_BIT_SCHEMA_ID) != 0) attributes.add("schemaId");
      if ((initBits & INIT_BIT_SQL_TEXT) != 0) attributes.add("sqlText");
      if ((initBits & INIT_BIT_DIALECT) != 0) attributes.add("dialect");
      return "Cannot build IcebergView, some of required attributes are not set " + attributes;
    }
  }
}
