/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.function.Function;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.projectnessie.api.params.AbstractParams;
import org.projectnessie.api.params.CommitLogParams;
import org.projectnessie.api.params.FetchOption;

public class CommitLogParamsTest {
    @Test
    public void testBuilder() {
        Integer maxRecords = 23;
        String startHash = "1234567890123456";
        String endHash = "00000";
        String pageToken = "aabbcc";
        String filter = "some_expression";
        FetchOption fetchOption = FetchOption.ALL;
        Supplier<CommitLogParams> generator = () -> ((CommitLogParams.Builder)((CommitLogParams.Builder)CommitLogParams.builder().filter(filter).maxRecords(maxRecords)).pageToken(pageToken)).startHash(startHash).endHash(endHash).fetch(fetchOption).build();
        this.verify(maxRecords, startHash, endHash, pageToken, filter, fetchOption, generator);
    }

    @Test
    public void testEmpty() {
        this.verify(null, null, null, null, null, null, CommitLogParams::empty);
    }

    private void verify(Integer maxRecords, String startHash, String endHash, String pageToken, String filter, FetchOption fetchOption, Supplier<CommitLogParams> generator) {
        ((ObjectAssert)Assertions.assertThat((Object)generator.get()).isEqualTo((Object)generator.get())).extracting(new Function[]{AbstractParams::pageToken, AbstractParams::maxRecords, CommitLogParams::filter, CommitLogParams::startHash, CommitLogParams::endHash, CommitLogParams::fetchOption, CommitLogParams::hashCode}).containsExactly(new Object[]{pageToken, maxRecords, filter, startHash, endHash, fetchOption, generator.get().hashCode()});
    }
}

