/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.model.Namespace;

public class TestNamespace {
    @Test
    public void testNullAndEmpty() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])null)).isInstanceOf(NullPointerException.class)).hasMessage("elements must be non-null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((List)null)).isInstanceOf(NullPointerException.class)).hasMessage("elements must be non-null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.parse(null)).isInstanceOf(NullPointerException.class)).hasMessage("identifier must be non-null");
        Assertions.assertThat((String)Namespace.of((String[])new String[0]).name()).isEmpty();
        Assertions.assertThat((String)Namespace.parse((String)"").name()).isEmpty();
        Assertions.assertThat((Object)Namespace.of((String[])new String[]{""})).extracting(new Function[]{Namespace::name, Namespace::isEmpty}).containsExactly(new Object[]{"", true});
    }

    @Test
    public void testOneElement() {
        Namespace namespace = Namespace.of((String[])new String[]{"foo"});
        Assertions.assertThat((Object)namespace).extracting(new Function[]{Namespace::name, Namespace::isEmpty}).containsExactly(new Object[]{"foo", false});
    }

    @ParameterizedTest
    @MethodSource(value={"elementsProvider"})
    void testNamespaceFromElements(String[] elements, String expectedNamespace) {
        Namespace namespace = Namespace.of((String[])elements);
        Assertions.assertThat((String)namespace.name()).isEqualTo(expectedNamespace);
        Assertions.assertThat((boolean)namespace.isEmpty()).isFalse();
        namespace = Namespace.of(Arrays.asList(elements));
        Assertions.assertThat((String)namespace.name()).isEqualTo(expectedNamespace);
        Assertions.assertThat((boolean)namespace.isEmpty()).isFalse();
    }

    @ParameterizedTest
    @MethodSource(value={"identifierProvider"})
    void testNamespaceParsing(String identifier, String expectedNamespace) {
        Namespace namespace = Namespace.parse((String)identifier);
        Assertions.assertThat((String)namespace.name()).isEqualTo(expectedNamespace);
        Assertions.assertThat((boolean)namespace.isEmpty()).isFalse();
    }

    @ParameterizedTest
    @MethodSource(value={"invalidElementsProvider"})
    void testInvalidElements(String[] elements) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])elements)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("'%s' is not a valid namespace identifier (should not end with '.')", Arrays.toString(elements)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of(Arrays.asList(elements))).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("'%s' is not a valid namespace identifier (should not end with '.')", Arrays.toString(elements)));
    }

    @ParameterizedTest
    @ValueSource(strings={".", "a.", "a.b.c."})
    void testInvalidParsing(String identifier) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.parse((String)identifier)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("'%s' is not a valid namespace identifier (should not end with '.')", identifier));
    }

    private static Stream<Arguments> elementsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{new String[]{"a", "b"}, "a.b"}), Arguments.of((Object[])new Object[]{new String[]{"a", "b", "c"}, "a.b.c"}));
    }

    private static Stream<Arguments> identifierProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{"a", "a"}), Arguments.of((Object[])new Object[]{"a.b", "a.b"}), Arguments.of((Object[])new Object[]{"a.b.c", "a.b.c"}));
    }

    private static Stream<Arguments> invalidElementsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{new String[]{"."}, "x"}), Arguments.of((Object[])new Object[]{new String[]{"a", "."}, "x"}), Arguments.of((Object[])new Object[]{new String[]{"a", "b", "c", "."}, "x"}));
    }
}

