package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Detached}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDetached.builder()}.
 */
@Generated(from = "Detached", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDetached implements Detached {
  private final @Nullable ReferenceMetadata metadata;
  private final String hash;

  private ImmutableDetached(
      @Nullable ReferenceMetadata metadata,
      String hash) {
    this.metadata = metadata;
    this.hash = hash;
  }

  /**
   * Returns a {@link ReferenceMetadata} instance that contains additional metadata about this
   * reference. Note that this is <b>only added</b> by the server when <b>explicitly</b> requested
   * by the client.
   * @return A {@link ReferenceMetadata} instance that contains additional metadata about this
   *     reference. Note that this is <b>only added</b> by the server when <b>explicitly</b>
   *     requested by the client.
   */
  @JsonProperty("metadata")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  @Override
  public @Nullable ReferenceMetadata getMetadata() {
    return metadata;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty("hash")
  @Override
  public String getHash() {
    return hash;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Detached#getMetadata() metadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metadata (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDetached withMetadata(@Nullable ReferenceMetadata value) {
    if (this.metadata == value) return this;
    return validate(new ImmutableDetached(value, this.hash));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Detached#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDetached withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (this.hash.equals(newValue)) return this;
    return validate(new ImmutableDetached(this.metadata, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDetached} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDetached
        && equalTo(0, (ImmutableDetached) another);
  }

  private boolean equalTo(int synthetic, ImmutableDetached another) {
    return Objects.equals(metadata, another.metadata)
        && hash.equals(another.hash);
  }

  /**
   * Computes a hash code from attributes: {@code metadata}, {@code hash}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + hash.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Detached} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Detached{"
        + "metadata=" + metadata
        + ", hash=" + hash
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Detached", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Detached {
    @Nullable ReferenceMetadata metadata;
    @Nullable String hash;
    @JsonProperty("metadata")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public void setMetadata(@Nullable ReferenceMetadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("hash")
    public void setHash(String hash) {
      this.hash = hash;
    }
    @Override
    public ReferenceMetadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDetached fromJson(Json json) {
    ImmutableDetached.Builder builder = ImmutableDetached.builder();
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    return builder.build();
  }

  private static ImmutableDetached validate(ImmutableDetached instance) {
    instance.checkHash();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Detached} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Detached instance
   */
  public static ImmutableDetached copyOf(Detached instance) {
    if (instance instanceof ImmutableDetached) {
      return (ImmutableDetached) instance;
    }
    return ImmutableDetached.builder()
        .from(instance)
        .build();
  }

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link ImmutableDetached ImmutableDetached}.
   * <pre>
   * ImmutableDetached.builder()
   *    .metadata(org.projectnessie.model.ReferenceMetadata | null) // nullable {@link Detached#getMetadata() metadata}
   *    .hash(String) // required {@link Detached#getHash() hash}
   *    .build();
   * </pre>
   * @return A new ImmutableDetached builder
   */
  public static ImmutableDetached.Builder builder() {
    return new ImmutableDetached.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDetached ImmutableDetached}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Detached", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_HASH = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ReferenceMetadata metadata;
    private @Nullable String hash;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Detached} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Detached instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Reference} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Reference instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof Detached) {
        Detached instance = (Detached) object;
        if ((bits & 0x1L) == 0) {
          @Nullable ReferenceMetadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          hash(instance.getHash());
          bits |= 0x2L;
        }
      }
      if (object instanceof Reference) {
        Reference instance = (Reference) object;
        if ((bits & 0x1L) == 0) {
          @Nullable ReferenceMetadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          hash(instance.getHash());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Detached#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("metadata")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public final Builder metadata(@Nullable ReferenceMetadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link Detached#getHash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hash")
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDetached ImmutableDetached}.
     * @return An immutable instance of Detached
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDetached build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableDetached.validate(new ImmutableDetached(metadata, hash));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      return "Cannot build Detached, some of required attributes are not set " + attributes;
    }
  }
}
