package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Merge}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMerge.builder()}.
 */
@Generated(from = "Merge", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMerge implements Merge {
  private final String fromHash;
  private final String fromRefName;

  private ImmutableMerge(String fromHash, String fromRefName) {
    this.fromHash = fromHash;
    this.fromRefName = fromRefName;
  }

  /**
   * @return The value of the {@code fromHash} attribute
   */
  @JsonProperty("fromHash")
  @Override
  public String getFromHash() {
    return fromHash;
  }

  /**
   * @return The value of the {@code fromRefName} attribute
   */
  @JsonProperty("fromRefName")
  @Override
  public String getFromRefName() {
    return fromRefName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge#getFromHash() fromHash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fromHash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge withFromHash(String value) {
    String newValue = Objects.requireNonNull(value, "fromHash");
    if (this.fromHash.equals(newValue)) return this;
    return validate(new ImmutableMerge(newValue, this.fromRefName));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge#getFromRefName() fromRefName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fromRefName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge withFromRefName(String value) {
    String newValue = Objects.requireNonNull(value, "fromRefName");
    if (this.fromRefName.equals(newValue)) return this;
    return validate(new ImmutableMerge(this.fromHash, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMerge} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMerge
        && equalTo(0, (ImmutableMerge) another);
  }

  private boolean equalTo(int synthetic, ImmutableMerge another) {
    return fromHash.equals(another.fromHash)
        && fromRefName.equals(another.fromRefName);
  }

  /**
   * Computes a hash code from attributes: {@code fromHash}, {@code fromRefName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + fromHash.hashCode();
    h += (h << 5) + fromRefName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Merge} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Merge{"
        + "fromHash=" + fromHash
        + ", fromRefName=" + fromRefName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Merge", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Merge {
    @Nullable String fromHash;
    @Nullable String fromRefName;
    @JsonProperty("fromHash")
    public void setFromHash(String fromHash) {
      this.fromHash = fromHash;
    }
    @JsonProperty("fromRefName")
    public void setFromRefName(String fromRefName) {
      this.fromRefName = fromRefName;
    }
    @Override
    public String getFromHash() { throw new UnsupportedOperationException(); }
    @Override
    public String getFromRefName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMerge fromJson(Json json) {
    ImmutableMerge.Builder builder = ImmutableMerge.builder();
    if (json.fromHash != null) {
      builder.fromHash(json.fromHash);
    }
    if (json.fromRefName != null) {
      builder.fromRefName(json.fromRefName);
    }
    return builder.build();
  }

  private static ImmutableMerge validate(ImmutableMerge instance) {
    instance.checkHash();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Merge} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Merge instance
   */
  public static ImmutableMerge copyOf(Merge instance) {
    if (instance instanceof ImmutableMerge) {
      return (ImmutableMerge) instance;
    }
    return ImmutableMerge.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMerge ImmutableMerge}.
   * <pre>
   * ImmutableMerge.builder()
   *    .fromHash(String) // required {@link Merge#getFromHash() fromHash}
   *    .fromRefName(String) // required {@link Merge#getFromRefName() fromRefName}
   *    .build();
   * </pre>
   * @return A new ImmutableMerge builder
   */
  public static ImmutableMerge.Builder builder() {
    return new ImmutableMerge.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMerge ImmutableMerge}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Merge", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FROM_HASH = 0x1L;
    private static final long INIT_BIT_FROM_REF_NAME = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String fromHash;
    private @Nullable String fromRefName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Merge} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Merge instance) {
      Objects.requireNonNull(instance, "instance");
      fromHash(instance.getFromHash());
      fromRefName(instance.getFromRefName());
      return this;
    }

    /**
     * Initializes the value for the {@link Merge#getFromHash() fromHash} attribute.
     * @param fromHash The value for fromHash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("fromHash")
    public final Builder fromHash(String fromHash) {
      this.fromHash = Objects.requireNonNull(fromHash, "fromHash");
      initBits &= ~INIT_BIT_FROM_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link Merge#getFromRefName() fromRefName} attribute.
     * @param fromRefName The value for fromRefName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("fromRefName")
    public final Builder fromRefName(String fromRefName) {
      this.fromRefName = Objects.requireNonNull(fromRefName, "fromRefName");
      initBits &= ~INIT_BIT_FROM_REF_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMerge ImmutableMerge}.
     * @return An immutable instance of Merge
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMerge build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableMerge.validate(new ImmutableMerge(fromHash, fromRefName));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FROM_HASH) != 0) attributes.add("fromHash");
      if ((initBits & INIT_BIT_FROM_REF_NAME) != 0) attributes.add("fromRefName");
      return "Cannot build Merge, some of required attributes are not set " + attributes;
    }
  }
}
