package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Transplant}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTransplant.builder()}.
 */
@Generated(from = "Transplant", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTransplant implements Transplant {
  private final List<String> hashesToTransplant;
  private final String fromRefName;

  private ImmutableTransplant(List<String> hashesToTransplant, String fromRefName) {
    this.hashesToTransplant = hashesToTransplant;
    this.fromRefName = fromRefName;
  }

  /**
   * @return The value of the {@code hashesToTransplant} attribute
   */
  @JsonProperty("hashesToTransplant")
  @Override
  public List<String> getHashesToTransplant() {
    return hashesToTransplant;
  }

  /**
   * @return The value of the {@code fromRefName} attribute
   */
  @JsonProperty("fromRefName")
  @Override
  public String getFromRefName() {
    return fromRefName;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Transplant#getHashesToTransplant() hashesToTransplant}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransplant withHashesToTransplant(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableTransplant(newValue, this.fromRefName));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Transplant#getHashesToTransplant() hashesToTransplant}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of hashesToTransplant elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransplant withHashesToTransplant(Iterable<String> elements) {
    if (this.hashesToTransplant == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableTransplant(newValue, this.fromRefName));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Transplant#getFromRefName() fromRefName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fromRefName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransplant withFromRefName(String value) {
    String newValue = Objects.requireNonNull(value, "fromRefName");
    if (this.fromRefName.equals(newValue)) return this;
    return validate(new ImmutableTransplant(this.hashesToTransplant, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTransplant} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTransplant
        && equalTo(0, (ImmutableTransplant) another);
  }

  private boolean equalTo(int synthetic, ImmutableTransplant another) {
    return hashesToTransplant.equals(another.hashesToTransplant)
        && fromRefName.equals(another.fromRefName);
  }

  /**
   * Computes a hash code from attributes: {@code hashesToTransplant}, {@code fromRefName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + hashesToTransplant.hashCode();
    h += (h << 5) + fromRefName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Transplant} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Transplant{"
        + "hashesToTransplant=" + hashesToTransplant
        + ", fromRefName=" + fromRefName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Transplant", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Transplant {
    @Nullable List<String> hashesToTransplant = Collections.emptyList();
    @Nullable String fromRefName;
    @JsonProperty("hashesToTransplant")
    public void setHashesToTransplant(List<String> hashesToTransplant) {
      this.hashesToTransplant = hashesToTransplant;
    }
    @JsonProperty("fromRefName")
    public void setFromRefName(String fromRefName) {
      this.fromRefName = fromRefName;
    }
    @Override
    public List<String> getHashesToTransplant() { throw new UnsupportedOperationException(); }
    @Override
    public String getFromRefName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTransplant fromJson(Json json) {
    ImmutableTransplant.Builder builder = ImmutableTransplant.builder();
    if (json.hashesToTransplant != null) {
      builder.addAllHashesToTransplant(json.hashesToTransplant);
    }
    if (json.fromRefName != null) {
      builder.fromRefName(json.fromRefName);
    }
    return builder.build();
  }

  private static ImmutableTransplant validate(ImmutableTransplant instance) {
    instance.checkHashes();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Transplant} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Transplant instance
   */
  public static ImmutableTransplant copyOf(Transplant instance) {
    if (instance instanceof ImmutableTransplant) {
      return (ImmutableTransplant) instance;
    }
    return ImmutableTransplant.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTransplant ImmutableTransplant}.
   * <pre>
   * ImmutableTransplant.builder()
   *    .addHashesToTransplant|addAllHashesToTransplant(String) // {@link Transplant#getHashesToTransplant() hashesToTransplant} elements
   *    .fromRefName(String) // required {@link Transplant#getFromRefName() fromRefName}
   *    .build();
   * </pre>
   * @return A new ImmutableTransplant builder
   */
  public static ImmutableTransplant.Builder builder() {
    return new ImmutableTransplant.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTransplant ImmutableTransplant}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Transplant", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FROM_REF_NAME = 0x1L;
    private long initBits = 0x1L;

    private List<String> hashesToTransplant = new ArrayList<String>();
    private @Nullable String fromRefName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Transplant} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Transplant instance) {
      Objects.requireNonNull(instance, "instance");
      addAllHashesToTransplant(instance.getHashesToTransplant());
      fromRefName(instance.getFromRefName());
      return this;
    }

    /**
     * Adds one element to {@link Transplant#getHashesToTransplant() hashesToTransplant} list.
     * @param element A hashesToTransplant element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addHashesToTransplant(String element) {
      this.hashesToTransplant.add(Objects.requireNonNull(element, "hashesToTransplant element"));
      return this;
    }

    /**
     * Adds elements to {@link Transplant#getHashesToTransplant() hashesToTransplant} list.
     * @param elements An array of hashesToTransplant elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addHashesToTransplant(String... elements) {
      for (String element : elements) {
        this.hashesToTransplant.add(Objects.requireNonNull(element, "hashesToTransplant element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Transplant#getHashesToTransplant() hashesToTransplant} list.
     * @param elements An iterable of hashesToTransplant elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hashesToTransplant")
    public final Builder hashesToTransplant(Iterable<String> elements) {
      this.hashesToTransplant.clear();
      return addAllHashesToTransplant(elements);
    }

    /**
     * Adds elements to {@link Transplant#getHashesToTransplant() hashesToTransplant} list.
     * @param elements An iterable of hashesToTransplant elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllHashesToTransplant(Iterable<String> elements) {
      for (String element : elements) {
        this.hashesToTransplant.add(Objects.requireNonNull(element, "hashesToTransplant element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Transplant#getFromRefName() fromRefName} attribute.
     * @param fromRefName The value for fromRefName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("fromRefName")
    public final Builder fromRefName(String fromRefName) {
      this.fromRefName = Objects.requireNonNull(fromRefName, "fromRefName");
      initBits &= ~INIT_BIT_FROM_REF_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTransplant ImmutableTransplant}.
     * @return An immutable instance of Transplant
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTransplant build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableTransplant.validate(new ImmutableTransplant(createUnmodifiableList(true, hashesToTransplant), fromRefName));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FROM_REF_NAME) != 0) attributes.add("fromRefName");
      return "Cannot build Transplant, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
