/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableContentKey;
import org.projectnessie.model.Namespace;

@JsonSerialize(as=ImmutableContentKey.class)
@JsonDeserialize(as=ImmutableContentKey.class)
@Value.Immutable(lazyhash=true)
public abstract class ContentKey
implements Serializable {
    private static final char ZERO_BYTE = '\u0000';
    private static final String ZERO_BYTE_STRING = Character.toString('\u0000');

    @NotNull
    @Size(min=1)
    public abstract @NotNull @Size(min=1) List<String> getElements();

    @JsonIgnore
    @Value.Redacted
    public Namespace getNamespace() {
        return Namespace.of(this.getElements().subList(0, this.getElements().size() - 1));
    }

    @JsonIgnore
    @Value.Redacted
    public String getName() {
        return this.getElements().get(this.getElements().size() - 1);
    }

    public static ContentKey of(Namespace namespace, String name) {
        ImmutableContentKey.Builder b = ImmutableContentKey.builder();
        if (namespace != null && !namespace.isEmpty()) {
            b.addElements(namespace.getElements());
        }
        return b.addElements(name).build();
    }

    public static ContentKey of(String ... elements) {
        Objects.requireNonNull(elements, "Elements array must not be null");
        return ImmutableContentKey.builder().elements(Arrays.asList(elements)).build();
    }

    @JsonCreator
    public static ContentKey of(@JsonProperty(value="elements") List<String> elements) {
        Objects.requireNonNull(elements);
        return ImmutableContentKey.builder().elements(elements).build();
    }

    @Value.Check
    protected void validate() {
        List<String> elements = this.getElements();
        for (String e : elements) {
            if (e == null) {
                throw new IllegalArgumentException("An object key must not contain a null element.");
            }
            if (!e.contains(ZERO_BYTE_STRING)) continue;
            throw new IllegalArgumentException("An object key must not contain a zero byte.");
        }
        if (elements.get(elements.size() - 1).isEmpty()) {
            throw new IllegalArgumentException("An object key must not contain an empty name (last element).");
        }
    }

    public static ContentKey fromPathString(String encoded) {
        List<String> elements = Arrays.stream(encoded.split("\\.")).map(x -> x.replace('\u0000', '.')).collect(Collectors.toList());
        return ContentKey.of(elements);
    }

    public String toPathString() {
        return this.getElements().stream().map(x -> x.replace('.', '\u0000')).collect(Collectors.joining("."));
    }

    public String toString() {
        return String.join((CharSequence)".", this.getElements());
    }
}

