/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.ContentKey;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ContentKey", generator="Immutables")
@Immutable
public final class ImmutableContentKey
extends ContentKey {
    private final List<String> elements;
    private int hashCode;

    private ImmutableContentKey(List<String> elements) {
        this.elements = elements;
    }

    @Override
    @JsonProperty(value="elements")
    public List<String> getElements() {
        return this.elements;
    }

    public final ImmutableContentKey withElements(String ... elements) {
        List<String> newValue = ImmutableContentKey.createUnmodifiableList(false, ImmutableContentKey.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableContentKey.validate(new ImmutableContentKey(newValue));
    }

    public final ImmutableContentKey withElements(Iterable<String> elements) {
        if (this.elements == elements) {
            return this;
        }
        List<String> newValue = ImmutableContentKey.createUnmodifiableList(false, ImmutableContentKey.createSafeList(elements, true, false));
        return ImmutableContentKey.validate(new ImmutableContentKey(newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentKey && this.equalTo(0, (ImmutableContentKey)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentKey another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.elements.equals(another.elements);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.elements.hashCode();
        return h;
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableContentKey fromJson(Json json) {
        Builder builder = ImmutableContentKey.builder();
        if (json.elements != null) {
            builder.addAllElements(json.elements);
        }
        return builder.build();
    }

    private static ImmutableContentKey validate(ImmutableContentKey instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableContentKey copyOf(ContentKey instance) {
        if (instance instanceof ImmutableContentKey) {
            return (ImmutableContentKey)instance;
        }
        return ImmutableContentKey.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableContentKey.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ContentKey", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<String> elements = new ArrayList<String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ContentKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllElements(instance.getElements());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addElements(String element) {
            this.elements.add(Objects.requireNonNull(element, "elements element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addElements(String ... elements) {
            for (String element : elements) {
                this.elements.add(Objects.requireNonNull(element, "elements element"));
            }
            return this;
        }

        @JsonProperty(value="elements")
        @CanIgnoreReturnValue
        public final Builder elements(Iterable<String> elements) {
            this.elements.clear();
            return this.addAllElements(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllElements(Iterable<String> elements) {
            for (String element : elements) {
                this.elements.add(Objects.requireNonNull(element, "elements element"));
            }
            return this;
        }

        public ImmutableContentKey build() {
            return ImmutableContentKey.validate(new ImmutableContentKey(ImmutableContentKey.createUnmodifiableList(true, this.elements)));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ContentKey", generator="Immutables")
    static final class Json
    extends ContentKey {
        @Nullable
        List<String> elements = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="elements")
        public void setElements(List<String> elements) {
            this.elements = elements;
        }

        @Override
        public List<String> getElements() {
            throw new UnsupportedOperationException();
        }
    }
}

