/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableTransplant;
import org.projectnessie.model.Validation;

@Schema(type=SchemaType.OBJECT, title="Transplant", properties={@SchemaProperty(name="fromRefName", pattern="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$"), @SchemaProperty(name="hashesToTransplant", uniqueItems=true)})
@JsonSerialize(as=ImmutableTransplant.class)
@JsonDeserialize(as=ImmutableTransplant.class)
@Value.Immutable
public interface Transplant {
    @NotNull
    @Size(min=1)
    public @NotNull @Size(min=1) List<String> getHashesToTransplant();

    @NotBlank
    @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    public @NotBlank @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String getFromRefName();

    @Value.Check
    default public void checkHashes() {
        List<String> hashes = this.getHashesToTransplant();
        if (hashes != null) {
            for (String hash : hashes) {
                Validation.validateHash(hash);
            }
        }
    }
}

