package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ContentKey}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContentKey.builder()}.
 */
@Generated(from = "ContentKey", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableContentKey extends ContentKey {
  private final List<String> elements;

  private ImmutableContentKey(List<String> elements) {
    this.elements = elements;
  }

  /**
   * @return The value of the {@code elements} attribute
   */
  @JsonProperty("elements")
  @Override
  public List<String> getElements() {
    return elements;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ContentKey#getElements() elements}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableContentKey withElements(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableContentKey(newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ContentKey#getElements() elements}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of elements elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableContentKey withElements(Iterable<String> elements) {
    if (this.elements == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableContentKey(newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContentKey} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContentKey
        && equalTo(0, (ImmutableContentKey) another);
  }

  private boolean equalTo(int synthetic, ImmutableContentKey another) {
    return elements.equals(another.elements);
  }

  /**
   * Computes a hash code from attributes: {@code elements}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + elements.hashCode();
    return h;
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ContentKey", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends ContentKey {
    @Nullable List<String> elements = Collections.emptyList();
    @JsonProperty("elements")
    public void setElements(List<String> elements) {
      this.elements = elements;
    }
    @Override
    public List<String> getElements() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableContentKey fromJson(Json json) {
    ImmutableContentKey.Builder builder = ImmutableContentKey.builder();
    if (json.elements != null) {
      builder.addAllElements(json.elements);
    }
    return builder.build();
  }

  private static ImmutableContentKey validate(ImmutableContentKey instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ContentKey} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ContentKey instance
   */
  public static ImmutableContentKey copyOf(ContentKey instance) {
    if (instance instanceof ImmutableContentKey) {
      return (ImmutableContentKey) instance;
    }
    return ImmutableContentKey.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContentKey ImmutableContentKey}.
   * <pre>
   * ImmutableContentKey.builder()
   *    .addElements|addAllElements(String) // {@link ContentKey#getElements() elements} elements
   *    .build();
   * </pre>
   * @return A new ImmutableContentKey builder
   */
  public static ImmutableContentKey.Builder builder() {
    return new ImmutableContentKey.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContentKey ImmutableContentKey}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ContentKey", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<String> elements = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContentKey} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ContentKey instance) {
      Objects.requireNonNull(instance, "instance");
      addAllElements(instance.getElements());
      return this;
    }

    /**
     * Adds one element to {@link ContentKey#getElements() elements} list.
     * @param element A elements element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addElements(String element) {
      this.elements.add(Objects.requireNonNull(element, "elements element"));
      return this;
    }

    /**
     * Adds elements to {@link ContentKey#getElements() elements} list.
     * @param elements An array of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addElements(String... elements) {
      for (String element : elements) {
        this.elements.add(Objects.requireNonNull(element, "elements element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ContentKey#getElements() elements} list.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("elements")
    public final Builder elements(Iterable<String> elements) {
      this.elements.clear();
      return addAllElements(elements);
    }

    /**
     * Adds elements to {@link ContentKey#getElements() elements} list.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllElements(Iterable<String> elements) {
      for (String element : elements) {
        this.elements.add(Objects.requireNonNull(element, "elements element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableContentKey ImmutableContentKey}.
     * @return An immutable instance of ContentKey
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContentKey build() {
      return ImmutableContentKey.validate(new ImmutableContentKey(createUnmodifiableList(true, elements)));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
