package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GetMultipleContentsResponse.ContentWithKey}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContentWithKey.builder()}.
 */
@Generated(from = "GetMultipleContentsResponse.ContentWithKey", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableContentWithKey
    implements GetMultipleContentsResponse.ContentWithKey {
  private final ContentKey key;
  private final Content content;

  private ImmutableContentWithKey(ContentKey key, Content content) {
    this.key = key;
    this.content = content;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @JsonProperty("key")
  @Override
  public ContentKey getKey() {
    return key;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty("content")
  @Override
  public Content getContent() {
    return content;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GetMultipleContentsResponse.ContentWithKey#getKey() key} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContentWithKey withKey(ContentKey value) {
    if (this.key == value) return this;
    ContentKey newValue = Objects.requireNonNull(value, "key");
    return new ImmutableContentWithKey(newValue, this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GetMultipleContentsResponse.ContentWithKey#getContent() content} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContentWithKey withContent(Content value) {
    if (this.content == value) return this;
    Content newValue = Objects.requireNonNull(value, "content");
    return new ImmutableContentWithKey(this.key, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContentWithKey} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContentWithKey
        && equalTo(0, (ImmutableContentWithKey) another);
  }

  private boolean equalTo(int synthetic, ImmutableContentWithKey another) {
    return key.equals(another.key)
        && content.equals(another.content);
  }

  /**
   * Computes a hash code from attributes: {@code key}, {@code content}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + key.hashCode();
    h += (h << 5) + content.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ContentWithKey} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ContentWithKey{"
        + "key=" + key
        + ", content=" + content
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "GetMultipleContentsResponse.ContentWithKey", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements GetMultipleContentsResponse.ContentWithKey {
    @Nullable ContentKey key;
    @Nullable Content content;
    @JsonProperty("key")
    public void setKey(ContentKey key) {
      this.key = key;
    }
    @JsonProperty("content")
    public void setContent(Content content) {
      this.content = content;
    }
    @Override
    public ContentKey getKey() { throw new UnsupportedOperationException(); }
    @Override
    public Content getContent() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableContentWithKey fromJson(Json json) {
    ImmutableContentWithKey.Builder builder = ImmutableContentWithKey.builder();
    if (json.key != null) {
      builder.key(json.key);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link GetMultipleContentsResponse.ContentWithKey} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ContentWithKey instance
   */
  public static ImmutableContentWithKey copyOf(GetMultipleContentsResponse.ContentWithKey instance) {
    if (instance instanceof ImmutableContentWithKey) {
      return (ImmutableContentWithKey) instance;
    }
    return ImmutableContentWithKey.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContentWithKey ImmutableContentWithKey}.
   * <pre>
   * ImmutableContentWithKey.builder()
   *    .key(org.projectnessie.model.ContentKey) // required {@link GetMultipleContentsResponse.ContentWithKey#getKey() key}
   *    .content(org.projectnessie.model.Content) // required {@link GetMultipleContentsResponse.ContentWithKey#getContent() content}
   *    .build();
   * </pre>
   * @return A new ImmutableContentWithKey builder
   */
  public static ImmutableContentWithKey.Builder builder() {
    return new ImmutableContentWithKey.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContentWithKey ImmutableContentWithKey}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GetMultipleContentsResponse.ContentWithKey", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private static final long INIT_BIT_CONTENT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ContentKey key;
    private @Nullable Content content;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContentWithKey} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GetMultipleContentsResponse.ContentWithKey instance) {
      Objects.requireNonNull(instance, "instance");
      key(instance.getKey());
      content(instance.getContent());
      return this;
    }

    /**
     * Initializes the value for the {@link GetMultipleContentsResponse.ContentWithKey#getKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("key")
    public final Builder key(ContentKey key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link GetMultipleContentsResponse.ContentWithKey#getContent() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content")
    public final Builder content(Content content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContentWithKey ImmutableContentWithKey}.
     * @return An immutable instance of ContentWithKey
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContentWithKey build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableContentWithKey(key, content);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      return "Cannot build ContentWithKey, some of required attributes are not set " + attributes;
    }
  }
}
