/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.error;

import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ErrorCodeAware;
import org.projectnessie.error.ImmutableNessieError;
import org.projectnessie.error.NessieError;

class TestErrorCode {
    TestErrorCode() {
    }

    private Optional<Exception> ex(ErrorCode errorCode) {
        ImmutableNessieError error = ImmutableNessieError.builder().reason("test").status(1).errorCode(errorCode).build();
        return ErrorCode.asException((NessieError)error);
    }

    @Test
    void testUnknown() {
        Assertions.assertThat(this.ex(ErrorCode.UNKNOWN)).isNotPresent();
    }

    @ParameterizedTest
    @EnumSource(value=ErrorCode.class, mode=EnumSource.Mode.EXCLUDE, names={"UNKNOWN"})
    public void testConversion(ErrorCode errorCode) {
        Optional<Exception> ex = this.ex(errorCode);
        Assertions.assertThat(ex).isPresent();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)ex.get()).isInstanceOf(ErrorCodeAware.class)).extracting(e -> ((ErrorCodeAware)e).getErrorCode()).isEqualTo((Object)errorCode);
    }
}

