package org.projectnessie.api.params;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code CommitLogParamsBuilder} collects parameters and invokes the static factory method:
 * {@code new org.projectnessie.api.params.CommitLogParams(..)}.
 * Call the {@link #build()} method to get a result of type {@code org.projectnessie.api.params.CommitLogParams}.
 * <p><em>{@code CommitLogParamsBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "org.projectnessie.api.params.CommitLogParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class CommitLogParamsBuilder {
  private @Nullable String startHash;
  private @Nullable String endHash;
  private @Nullable Integer maxRecords;
  private @Nullable String pageToken;
  private @Nullable String filter;
  private @Nullable FetchOption fetchOption;

  /**
   * Creates a {@code CommitLogParamsBuilder} factory builder.
   * <pre>
   * new CommitLogParamsBuilder()
   *    .startHash(String | null) // nullable {@code startHash}
   *    .endHash(String | null) // nullable {@code endHash}
   *    .maxRecords(Integer | null) // nullable {@code maxRecords}
   *    .pageToken(String | null) // nullable {@code pageToken}
   *    .filter(String | null) // nullable {@code filter}
   *    .fetchOption(org.projectnessie.api.params.FetchOption | null) // nullable {@code fetchOption}
   *    .build();
   * </pre>
   */
  public CommitLogParamsBuilder() {
  }

  /**
   * Initializes the value for the {@code startHash} attribute.
   * @param startHash The value for startHash (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final CommitLogParamsBuilder startHash(@Nullable String startHash) {
    this.startHash = startHash;
    return this;
  }

  /**
   * Initializes the value for the {@code endHash} attribute.
   * @param endHash The value for endHash (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final CommitLogParamsBuilder endHash(@Nullable String endHash) {
    this.endHash = endHash;
    return this;
  }

  /**
   * Initializes the value for the {@code maxRecords} attribute.
   * @param maxRecords The value for maxRecords (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final CommitLogParamsBuilder maxRecords(@Nullable Integer maxRecords) {
    this.maxRecords = maxRecords;
    return this;
  }

  /**
   * Initializes the value for the {@code pageToken} attribute.
   * @param pageToken The value for pageToken (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final CommitLogParamsBuilder pageToken(@Nullable String pageToken) {
    this.pageToken = pageToken;
    return this;
  }

  /**
   * Initializes the value for the {@code filter} attribute.
   * @param filter The value for filter (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final CommitLogParamsBuilder filter(@Nullable String filter) {
    this.filter = filter;
    return this;
  }

  /**
   * Initializes the value for the {@code fetchOption} attribute.
   * @param fetchOption The value for fetchOption (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final CommitLogParamsBuilder fetchOption(@Nullable FetchOption fetchOption) {
    this.fetchOption = fetchOption;
    return this;
  }

  /**
   * Invokes {@code new org.projectnessie.api.params.CommitLogParams(..)} using the collected parameters and returns the result of the invocation
   * @return A result of type {@code org.projectnessie.api.params.CommitLogParams}
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public CommitLogParams build() {
    return new CommitLogParams(startHash, endHash, maxRecords, pageToken, filter, fetchOption);
  }
}
