package org.projectnessie.api.params;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code DiffParamsBuilder} collects parameters and invokes the static factory method:
 * {@code new org.projectnessie.api.params.DiffParams(..)}.
 * Call the {@link #build()} method to get a result of type {@code org.projectnessie.api.params.DiffParams}.
 * <p><em>{@code DiffParamsBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "org.projectnessie.api.params.DiffParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class DiffParamsBuilder {
  private static final long INIT_BIT_FROM_REF = 0x1L;
  private static final long INIT_BIT_TO_REF = 0x2L;
  private long initBits = 0x3L;

  private @Nullable String fromRef;
  private @Nullable String fromHashOnRef;
  private @Nullable String toRef;
  private @Nullable String toHashOnRef;

  /**
   * Creates a {@code DiffParamsBuilder} factory builder.
   * <pre>
   * new DiffParamsBuilder()
   *    .fromRef(String) // required {@code fromRef}
   *    .fromHashOnRef(String | null) // nullable {@code fromHashOnRef}
   *    .toRef(String) // required {@code toRef}
   *    .toHashOnRef(String | null) // nullable {@code toHashOnRef}
   *    .build();
   * </pre>
   */
  public DiffParamsBuilder() {
  }

  /**
   * Initializes the value for the {@code fromRef} attribute.
   * @param fromRef The value for fromRef 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final DiffParamsBuilder fromRef(String fromRef) {
    this.fromRef = Objects.requireNonNull(fromRef, "fromRef");
    initBits &= ~INIT_BIT_FROM_REF;
    return this;
  }

  /**
   * Initializes the value for the {@code fromHashOnRef} attribute.
   * @param fromHashOnRef The value for fromHashOnRef (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final DiffParamsBuilder fromHashOnRef(@Nullable String fromHashOnRef) {
    this.fromHashOnRef = fromHashOnRef;
    return this;
  }

  /**
   * Initializes the value for the {@code toRef} attribute.
   * @param toRef The value for toRef 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final DiffParamsBuilder toRef(String toRef) {
    this.toRef = Objects.requireNonNull(toRef, "toRef");
    initBits &= ~INIT_BIT_TO_REF;
    return this;
  }

  /**
   * Initializes the value for the {@code toHashOnRef} attribute.
   * @param toHashOnRef The value for toHashOnRef (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final DiffParamsBuilder toHashOnRef(@Nullable String toHashOnRef) {
    this.toHashOnRef = toHashOnRef;
    return this;
  }

  /**
   * Invokes {@code new org.projectnessie.api.params.DiffParams(..)} using the collected parameters and returns the result of the invocation
   * @return A result of type {@code org.projectnessie.api.params.DiffParams}
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public DiffParams build() {
    checkRequiredAttributes();
    return new DiffParams(fromRef, fromHashOnRef, toRef, toHashOnRef);
  }

  private boolean fromRefIsSet() {
    return (initBits & INIT_BIT_FROM_REF) == 0;
  }

  private boolean toRefIsSet() {
    return (initBits & INIT_BIT_TO_REF) == 0;
  }

  private void checkRequiredAttributes() {
    if (initBits != 0) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!fromRefIsSet()) attributes.add("fromRef");
    if (!toRefIsSet()) attributes.add("toRef");
    return "Cannot build DiffParams, some of required attributes are not set " + attributes;
  }
}
