package org.projectnessie.api.params;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code GetReferenceParamsBuilder} collects parameters and invokes the static factory method:
 * {@code new org.projectnessie.api.params.GetReferenceParams(..)}.
 * Call the {@link #build()} method to get a result of type {@code org.projectnessie.api.params.GetReferenceParams}.
 * <p><em>{@code GetReferenceParamsBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "org.projectnessie.api.params.GetReferenceParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class GetReferenceParamsBuilder {
  private static final long INIT_BIT_REF_NAME = 0x1L;
  private long initBits = 0x1L;

  private @Nullable String refName;
  private @Nullable FetchOption fetchOption;

  /**
   * Creates a {@code GetReferenceParamsBuilder} factory builder.
   * <pre>
   * new GetReferenceParamsBuilder()
   *    .refName(String) // required {@code refName}
   *    .fetchOption(org.projectnessie.api.params.FetchOption | null) // nullable {@code fetchOption}
   *    .build();
   * </pre>
   */
  public GetReferenceParamsBuilder() {
  }

  /**
   * Initializes the value for the {@code refName} attribute.
   * @param refName The value for refName 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final GetReferenceParamsBuilder refName(String refName) {
    this.refName = Objects.requireNonNull(refName, "refName");
    initBits &= ~INIT_BIT_REF_NAME;
    return this;
  }

  /**
   * Initializes the value for the {@code fetchOption} attribute.
   * @param fetchOption The value for fetchOption (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final GetReferenceParamsBuilder fetchOption(@Nullable FetchOption fetchOption) {
    this.fetchOption = fetchOption;
    return this;
  }

  /**
   * Invokes {@code new org.projectnessie.api.params.GetReferenceParams(..)} using the collected parameters and returns the result of the invocation
   * @return A result of type {@code org.projectnessie.api.params.GetReferenceParams}
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public GetReferenceParams build() {
    checkRequiredAttributes();
    return new GetReferenceParams(refName, fetchOption);
  }

  private boolean refNameIsSet() {
    return (initBits & INIT_BIT_REF_NAME) == 0;
  }

  private void checkRequiredAttributes() {
    if (initBits != 0) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!refNameIsSet()) attributes.add("refName");
    return "Cannot build GetReferenceParams, some of required attributes are not set " + attributes;
  }
}
