package org.projectnessie.api.params;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code RefLogParamsBuilder} collects parameters and invokes the static factory method:
 * {@code new org.projectnessie.api.params.RefLogParams(..)}.
 * Call the {@link #build()} method to get a result of type {@code org.projectnessie.api.params.RefLogParams}.
 * <p><em>{@code RefLogParamsBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "org.projectnessie.api.params.RefLogParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class RefLogParamsBuilder {
  private @Nullable String startHash;
  private @Nullable String endHash;
  private @Nullable Integer maxRecords;
  private @Nullable String pageToken;
  private @Nullable String filter;

  /**
   * Creates a {@code RefLogParamsBuilder} factory builder.
   * <pre>
   * new RefLogParamsBuilder()
   *    .startHash(String | null) // nullable {@code startHash}
   *    .endHash(String | null) // nullable {@code endHash}
   *    .maxRecords(Integer | null) // nullable {@code maxRecords}
   *    .pageToken(String | null) // nullable {@code pageToken}
   *    .filter(String | null) // nullable {@code filter}
   *    .build();
   * </pre>
   */
  public RefLogParamsBuilder() {
  }

  /**
   * Initializes the value for the {@code startHash} attribute.
   * @param startHash The value for startHash (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final RefLogParamsBuilder startHash(@Nullable String startHash) {
    this.startHash = startHash;
    return this;
  }

  /**
   * Initializes the value for the {@code endHash} attribute.
   * @param endHash The value for endHash (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final RefLogParamsBuilder endHash(@Nullable String endHash) {
    this.endHash = endHash;
    return this;
  }

  /**
   * Initializes the value for the {@code maxRecords} attribute.
   * @param maxRecords The value for maxRecords (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final RefLogParamsBuilder maxRecords(@Nullable Integer maxRecords) {
    this.maxRecords = maxRecords;
    return this;
  }

  /**
   * Initializes the value for the {@code pageToken} attribute.
   * @param pageToken The value for pageToken (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final RefLogParamsBuilder pageToken(@Nullable String pageToken) {
    this.pageToken = pageToken;
    return this;
  }

  /**
   * Initializes the value for the {@code filter} attribute.
   * @param filter The value for filter (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final RefLogParamsBuilder filter(@Nullable String filter) {
    this.filter = filter;
    return this;
  }

  /**
   * Invokes {@code new org.projectnessie.api.params.RefLogParams(..)} using the collected parameters and returns the result of the invocation
   * @return A result of type {@code org.projectnessie.api.params.RefLogParams}
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public RefLogParams build() {
    return new RefLogParams(startHash, endHash, maxRecords, pageToken, filter);
  }
}
