package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GetNamespacesResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGetNamespacesResponse.builder()}.
 */
@Generated(from = "GetNamespacesResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGetNamespacesResponse implements GetNamespacesResponse {
  private final List<Namespace> namespaces;

  private ImmutableGetNamespacesResponse(List<Namespace> namespaces) {
    this.namespaces = namespaces;
  }

  /**
   * @return The value of the {@code namespaces} attribute
   */
  @JsonProperty("namespaces")
  @Override
  public List<Namespace> getNamespaces() {
    return namespaces;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GetNamespacesResponse#getNamespaces() namespaces}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetNamespacesResponse withNamespaces(Namespace... elements) {
    List<Namespace> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableGetNamespacesResponse(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GetNamespacesResponse#getNamespaces() namespaces}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of namespaces elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetNamespacesResponse withNamespaces(Iterable<? extends Namespace> elements) {
    if (this.namespaces == elements) return this;
    List<Namespace> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableGetNamespacesResponse(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGetNamespacesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGetNamespacesResponse
        && equalTo(0, (ImmutableGetNamespacesResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableGetNamespacesResponse another) {
    return namespaces.equals(another.namespaces);
  }

  /**
   * Computes a hash code from attributes: {@code namespaces}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + namespaces.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetNamespacesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetNamespacesResponse{"
        + "namespaces=" + namespaces
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "GetNamespacesResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements GetNamespacesResponse {
    @Nullable List<Namespace> namespaces = Collections.emptyList();
    @JsonProperty("namespaces")
    public void setNamespaces(List<Namespace> namespaces) {
      this.namespaces = namespaces;
    }
    @Override
    public List<Namespace> getNamespaces() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableGetNamespacesResponse fromJson(Json json) {
    ImmutableGetNamespacesResponse.Builder builder = ImmutableGetNamespacesResponse.builder();
    if (json.namespaces != null) {
      builder.addAllNamespaces(json.namespaces);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link GetNamespacesResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GetNamespacesResponse instance
   */
  public static ImmutableGetNamespacesResponse copyOf(GetNamespacesResponse instance) {
    if (instance instanceof ImmutableGetNamespacesResponse) {
      return (ImmutableGetNamespacesResponse) instance;
    }
    return ImmutableGetNamespacesResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGetNamespacesResponse ImmutableGetNamespacesResponse}.
   * <pre>
   * ImmutableGetNamespacesResponse.builder()
   *    .addNamespaces|addAllNamespaces(org.projectnessie.model.Namespace) // {@link GetNamespacesResponse#getNamespaces() namespaces} elements
   *    .build();
   * </pre>
   * @return A new ImmutableGetNamespacesResponse builder
   */
  public static ImmutableGetNamespacesResponse.Builder builder() {
    return new ImmutableGetNamespacesResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGetNamespacesResponse ImmutableGetNamespacesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GetNamespacesResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Namespace> namespaces = new ArrayList<Namespace>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetNamespacesResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GetNamespacesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllNamespaces(instance.getNamespaces());
      return this;
    }

    /**
     * Adds one element to {@link GetNamespacesResponse#getNamespaces() namespaces} list.
     * @param element A namespaces element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNamespaces(Namespace element) {
      this.namespaces.add(Objects.requireNonNull(element, "namespaces element"));
      return this;
    }

    /**
     * Adds elements to {@link GetNamespacesResponse#getNamespaces() namespaces} list.
     * @param elements An array of namespaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNamespaces(Namespace... elements) {
      for (Namespace element : elements) {
        this.namespaces.add(Objects.requireNonNull(element, "namespaces element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetNamespacesResponse#getNamespaces() namespaces} list.
     * @param elements An iterable of namespaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("namespaces")
    public final Builder namespaces(Iterable<? extends Namespace> elements) {
      this.namespaces.clear();
      return addAllNamespaces(elements);
    }

    /**
     * Adds elements to {@link GetNamespacesResponse#getNamespaces() namespaces} list.
     * @param elements An iterable of namespaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNamespaces(Iterable<? extends Namespace> elements) {
      for (Namespace element : elements) {
        this.namespaces.add(Objects.requireNonNull(element, "namespaces element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableGetNamespacesResponse ImmutableGetNamespacesResponse}.
     * @return An immutable instance of GetNamespacesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGetNamespacesResponse build() {
      return new ImmutableGetNamespacesResponse(createUnmodifiableList(true, namespaces));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
