/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Namespace;

class TestContentKey {
    TestContentKey() {
    }

    @ParameterizedTest
    @MethodSource(value={"contentKeyOfAndParseCases"})
    void contentKeyOfAndParse(ContentKeyOfParse testCase) {
        Assertions.assertThat((Object)testCase.key).extracting(new Function[]{ContentKey::getElements, ContentKey::getName, ContentKey::getNamespace, ContentKey::toString, ContentKey::toPathString}).containsExactly(new Object[]{testCase.elements, testCase.name, testCase.namespace, testCase.string, testCase.pathString});
    }

    static List<ContentKeyOfParse> contentKeyOfAndParseCases() {
        return Arrays.asList(new ContentKeyOfParse(ContentKey.fromPathString((String)"a.table"), Arrays.asList("a", "table"), "table", Namespace.of((String[])new String[]{"a"}), "a.table", "a.table"), new ContentKeyOfParse(ContentKey.of((String[])new String[]{"a", "table"}), Arrays.asList("a", "table"), "table", Namespace.of((String[])new String[]{"a"}), "a.table", "a.table"), new ContentKeyOfParse(ContentKey.of(Arrays.asList("a", "table")), Arrays.asList("a", "table"), "table", Namespace.of((String[])new String[]{"a"}), "a.table", "a.table"), new ContentKeyOfParse(ContentKey.of((Namespace)Namespace.of((String[])new String[]{"a"}), (String)"table"), Arrays.asList("a", "table"), "table", Namespace.of((String[])new String[]{"a"}), "a.table", "a.table"), new ContentKeyOfParse(ContentKey.of((Namespace)Namespace.of(Collections.singletonList("a")), (String)"table"), Arrays.asList("a", "table"), "table", Namespace.of((String[])new String[]{"a"}), "a.table", "a.table"), new ContentKeyOfParse(ContentKey.of((Namespace)Namespace.parse((String)"a"), (String)"table"), Arrays.asList("a", "table"), "table", Namespace.of((String[])new String[]{"a"}), "a.table", "a.table"), new ContentKeyOfParse(ContentKey.fromPathString((String)"a.b.table"), Arrays.asList("a", "b", "table"), "table", Namespace.of((String[])new String[]{"a", "b"}), "a.b.table", "a.b.table"), new ContentKeyOfParse(ContentKey.of((String[])new String[]{"a", "b", "table"}), Arrays.asList("a", "b", "table"), "table", Namespace.of((String[])new String[]{"a", "b"}), "a.b.table", "a.b.table"), new ContentKeyOfParse(ContentKey.of(Arrays.asList("a", "b", "table")), Arrays.asList("a", "b", "table"), "table", Namespace.of((String[])new String[]{"a", "b"}), "a.b.table", "a.b.table"), new ContentKeyOfParse(ContentKey.of((Namespace)Namespace.of((String[])new String[]{"a", "b"}), (String)"table"), Arrays.asList("a", "b", "table"), "table", Namespace.of((String[])new String[]{"a", "b"}), "a.b.table", "a.b.table"), new ContentKeyOfParse(ContentKey.of((Namespace)Namespace.of(Arrays.asList("a", "b")), (String)"table"), Arrays.asList("a", "b", "table"), "table", Namespace.of((String[])new String[]{"a", "b"}), "a.b.table", "a.b.table"), new ContentKeyOfParse(ContentKey.of((Namespace)Namespace.parse((String)"a.b"), (String)"table"), Arrays.asList("a", "b", "table"), "table", Namespace.of((String[])new String[]{"a", "b"}), "a.b.table", "a.b.table"), new ContentKeyOfParse(ContentKey.of((Namespace)Namespace.EMPTY, (String)"table"), Collections.singletonList("table"), "table", Namespace.parse((String)""), "table", "table"), new ContentKeyOfParse(ContentKey.of((String[])new String[]{"table"}), Collections.singletonList("table"), "table", Namespace.parse((String)""), "table", "table"), new ContentKeyOfParse(ContentKey.of(Collections.singletonList("table")), Collections.singletonList("table"), "table", Namespace.parse((String)""), "table", "table"), new ContentKeyOfParse(ContentKey.fromPathString((String)"table"), Collections.singletonList("table"), "table", Namespace.parse((String)""), "table", "table"));
    }

    @Test
    void namespaceNotIncluded() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Namespace namespace = Namespace.parse((String)"a.b.c");
        Assertions.assertThat((String)namespace.name()).isEqualTo("a.b.c");
        Assertions.assertThat((List)namespace.getElements()).containsExactly((Object[])new String[]{"a", "b", "c"});
        ContentKey key = ContentKey.of((String[])new String[]{"a", "b", "c", "tableName"});
        Assertions.assertThat((Object)key.getNamespace()).isEqualTo((Object)namespace);
        String serializedKey = mapper.writeValueAsString((Object)key);
        ((AbstractStringAssert)Assertions.assertThat((String)serializedKey).contains(new CharSequence[]{"elements"})).doesNotContain(new CharSequence[]{"namespace"});
        ContentKey deserialized = (ContentKey)mapper.readValue(serializedKey, ContentKey.class);
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)key);
        Assertions.assertThat((Object)deserialized.getNamespace()).isEqualTo((Object)namespace);
    }

    @Test
    public void validation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContentKey.of((String[])new String[]{"a", "b", "\u0000", "c", "d"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Content key '[a, b, \u0000, c, d]' must not contain a zero byte.");
    }

    @Test
    public void construction() {
        CharSequence[] elements = new String[]{"a", "b", "c", "d"};
        ContentKey key = ContentKey.of((String[])elements);
        Assertions.assertThat((List)key.getElements()).containsExactlyElementsOf(Arrays.asList(elements));
        Assertions.assertThat((String)key.toPathString()).isEqualTo(String.join((CharSequence)".", elements));
        Assertions.assertThat((Object)ContentKey.fromPathString((String)"a.b.c.d")).isEqualTo((Object)key);
    }

    @Test
    void singleByte() {
        this.assertRoundTrip("a.b", "c.d");
    }

    @Test
    void strangeCharacters() {
        this.assertRoundTrip("/%", "#&&");
    }

    @Test
    void doubleByte() {
        this.assertRoundTrip("/%\u56fd", "\u56fd.\u56fd");
    }

    @Test
    void blockZeroByteUsage() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ContentKey.of((String[])new String[]{"\u0000"}));
    }

    @Test
    void npe() {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThatThrownBy(() -> ContentKey.of((String[])null)).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> ContentKey.of(null, null)).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> ContentKey.of((String[])new String[]{"a", null})).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> ContentKey.of((List)null)).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> ContentKey.of(Collections.singletonList(null))).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> ContentKey.of(Arrays.asList("a", null))).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> ContentKey.of(Arrays.asList(null, "a"))).isInstanceOf(NullPointerException.class)});
    }

    @Test
    void empty() {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContentKey.of(null, (String)"")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Content key '[]' must not contain an empty element."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContentKey.of((String[])new String[]{"a", ""})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Content key '[a, ]' must not contain an empty element."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContentKey.of(Collections.singletonList(""))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Content key '[]' must not contain an empty element."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContentKey.of(Arrays.asList("a", ""))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Content key '[a, ]' must not contain an empty element."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContentKey.of((String[])new String[]{"", "something"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Content key '[, something]' must not contain an empty element."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContentKey.of((String[])new String[]{"", "something", "x"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Content key '[, something, x]' must not contain an empty element.")});
    }

    private void assertRoundTrip(String ... elements) {
        ContentKey k = ContentKey.of((String[])elements);
        ContentKey k2 = ContentKey.fromPathString((String)k.toPathString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)k, (Object)k2);
    }

    static class ContentKeyOfParse {
        final ContentKey key;
        final List<String> elements;
        final String name;
        final Namespace namespace;
        final String string;
        final String pathString;

        ContentKeyOfParse(ContentKey key, List<String> elements, String name, Namespace namespace, String string, String pathString) {
            this.key = key;
            this.elements = elements;
            this.name = name;
            this.namespace = namespace;
            this.string = string;
            this.pathString = pathString;
        }

        public String toString() {
            return "key=" + this.key + ", elements=" + this.elements + ", namespace=" + this.namespace + ", string='" + this.string + '\'' + ", pathString='" + this.pathString + '\'';
        }
    }
}

