/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.UriUtil;

public class TestNamespace {
    @Test
    public void testNullAndEmpty() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])null)).isInstanceOf(NullPointerException.class)).hasMessage("elements must be non-null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((List)null)).isInstanceOf(NullPointerException.class)).hasMessage("elements must be non-null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.parse(null)).isInstanceOf(NullPointerException.class)).hasMessage("identifier must be non-null");
        Assertions.assertThat((String)Namespace.of((String[])new String[0]).name()).isEmpty();
        Assertions.assertThat((String)Namespace.parse((String)"").name()).isEmpty();
        Assertions.assertThat((Object)Namespace.of((String[])new String[]{""})).extracting(new Function[]{Namespace::name, Namespace::isEmpty}).containsExactly(new Object[]{"", true});
        Assertions.assertThat((Object)Namespace.of((String[])new String[]{""})).isEqualTo((Object)Namespace.EMPTY);
        Assertions.assertThat((Object)Namespace.of(Collections.emptyList())).isEqualTo((Object)Namespace.EMPTY);
        Assertions.assertThat((Object)Namespace.of(Collections.singletonList(""))).isEqualTo((Object)Namespace.EMPTY);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])new String[]{"", "something"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Namespace '[, something]' must not contain an empty element.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])new String[]{"", "something", "x"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Namespace '[, something, x]' must not contain an empty element.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])new String[]{"something", "", "x"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Namespace '[something, , x]' must not contain an empty element.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])new String[]{"something", "x", ""})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Namespace '[something, x, ]' must not contain an empty element.");
    }

    @Test
    public void testOneElement() {
        Namespace namespace = Namespace.of((String[])new String[]{"foo"});
        Assertions.assertThat((Object)namespace).extracting(new Function[]{Namespace::name, Namespace::isEmpty}).containsExactly(new Object[]{"foo", false});
    }

    @Test
    public void testRoundTrip() {
        List<String> elements = Arrays.asList("a", "b.c", "namespace");
        String pathString = UriUtil.toPathString(elements);
        String expectedPathString = "a.b\u0000c.namespace";
        Assertions.assertThat((String)pathString).isEqualTo(expectedPathString);
        Namespace namespace = Namespace.parse((String)pathString);
        Assertions.assertThat((String)namespace.name()).isEqualTo(pathString);
        Assertions.assertThat((List)namespace.getElements()).isEqualTo(elements);
        Assertions.assertThat((String)namespace.toString()).isEqualTo(pathString);
        Assertions.assertThat((String)namespace.toPathString()).isEqualTo(pathString);
        Assertions.assertThat((String)namespace.name()).startsWith((CharSequence)"a.b");
        Assertions.assertThat((String)namespace.name()).startsWith((CharSequence)"a.b\u0000");
        Assertions.assertThat((String)namespace.name()).startsWith((CharSequence)"a.b\u0000c");
        Assertions.assertThat((String)namespace.name()).startsWith((CharSequence)"a.b\u0000c.namespa");
        Assertions.assertThat((String)namespace.name()).doesNotStartWith((CharSequence)"a.b.c");
        Assertions.assertThat((String)Namespace.parse((String)"a.b.c").name()).doesNotStartWith((CharSequence)"a.b\u0000");
    }

    @ParameterizedTest
    @MethodSource(value={"elementsProvider"})
    void testNamespaceFromElements(String[] elements, String expectedNamespace) {
        Namespace namespace = Namespace.of((String[])elements);
        Assertions.assertThat((String)namespace.name()).isEqualTo(expectedNamespace);
        Assertions.assertThat((boolean)namespace.isEmpty()).isFalse();
        Assertions.assertThat((List)namespace.getElements()).containsExactly((Object[])elements);
        namespace = Namespace.of(Arrays.asList(elements));
        Assertions.assertThat((String)namespace.name()).isEqualTo(expectedNamespace);
        Assertions.assertThat((boolean)namespace.isEmpty()).isFalse();
        Assertions.assertThat((List)namespace.getElements()).isEqualTo(Arrays.asList(elements));
    }

    @ParameterizedTest
    @MethodSource(value={"identifierProvider"})
    void testNamespaceParsing(String identifier, String expectedNamespace) {
        Namespace namespace = Namespace.parse((String)identifier);
        Assertions.assertThat((String)namespace.name()).isEqualTo(expectedNamespace);
        Assertions.assertThat((boolean)namespace.isEmpty()).isFalse();
    }

    @ParameterizedTest
    @MethodSource(value={"invalidElementsProvider"})
    void testInvalidElements(String[] elements) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])elements)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("'%s' is not a valid namespace identifier (should not end with '.')", Arrays.toString(elements)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of(Arrays.asList(elements))).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("'%s' is not a valid namespace identifier (should not end with '.')", Arrays.toString(elements)));
    }

    @ParameterizedTest
    @ValueSource(strings={".", "a.", "a.b.c."})
    void testInvalidParsing(String identifier) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.parse((String)identifier)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("'%s' is not a valid namespace identifier (should not end with '.')", identifier));
    }

    @ParameterizedTest
    @ValueSource(strings={"\u0000", "a.\u0000", "a.b.c.\u0000"})
    void testZeroByteUsage(String identifier) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])new String[]{identifier})).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("Namespace '%s' must not contain a zero byte.", Collections.singletonList(identifier)));
    }

    @ParameterizedTest
    @MethodSource(value={"invalidElementsWithNullsProvider"})
    void testNullsInElements(String[] elements) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])elements)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("Namespace '%s' must not contain a null element.", Arrays.toString(elements)));
    }

    private static Stream<Arguments> elementsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{new String[]{"a", "b"}, "a.b"}), Arguments.of((Object[])new Object[]{new String[]{"a", "b", "c"}, "a.b.c"}), Arguments.of((Object[])new Object[]{new String[]{"a", "b.c", "d"}, "a.b\u0000c.d"}), Arguments.of((Object[])new Object[]{new String[]{"a", "b_c", "d.e"}, "a.b_c.d\u0000e"}), Arguments.of((Object[])new Object[]{new String[]{"a.c", "b.d"}, "a\u0000c.b\u0000d"}));
    }

    private static Stream<Arguments> identifierProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{"a", "a"}), Arguments.of((Object[])new Object[]{"a.b", "a.b"}), Arguments.of((Object[])new Object[]{"a.b.c", "a.b.c"}));
    }

    private static Stream<Arguments> invalidElementsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{new String[]{"."}, "x"}), Arguments.of((Object[])new Object[]{new String[]{"a", "."}, "x"}), Arguments.of((Object[])new Object[]{new String[]{"a", "b", "c", "."}, "x"}));
    }

    private static Stream<Arguments> invalidElementsWithNullsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{new String[]{null}, "x"}), Arguments.of((Object[])new Object[]{new String[]{"a", ".", null}, "x"}), Arguments.of((Object[])new Object[]{new String[]{"a", "b", "c", ".", null}, "x"}));
    }

    @ParameterizedTest
    @MethodSource(value={"namespaceOfAndParseCases"})
    void namespaceOfAndParse(NamespaceOfParse testCase) {
        Assertions.assertThat((Object)testCase.namespace).extracting(new Function[]{Namespace::getElements, Namespace::name, Namespace::toString, Namespace::toPathString}).containsExactly(new Object[]{testCase.elements, testCase.name, testCase.name, testCase.name});
    }

    static List<NamespaceOfParse> namespaceOfAndParseCases() {
        return Arrays.asList(new NamespaceOfParse(Namespace.fromPathString((String)UriUtil.toPathString(Arrays.asList("a", "b.c", "namespace"))), Arrays.asList("a", "b.c", "namespace"), UriUtil.toPathString(Arrays.asList("a", "b.c", "namespace"))), new NamespaceOfParse(Namespace.fromPathString((String)UriUtil.toPathString(Arrays.asList("a", "b.c", "d.e.f.namespace"))), Arrays.asList("a", "b.c", "d.e.f.namespace"), UriUtil.toPathString(Arrays.asList("a", "b.c", "d.e.f.namespace"))), new NamespaceOfParse(Namespace.fromPathString((String)"a.namespace"), Arrays.asList("a", "namespace"), "a.namespace"), new NamespaceOfParse(Namespace.of((String[])new String[]{"a", "namespace"}), Arrays.asList("a", "namespace"), "a.namespace"), new NamespaceOfParse(Namespace.of(Arrays.asList("a", "namespace")), Arrays.asList("a", "namespace"), "a.namespace"), new NamespaceOfParse(Namespace.fromPathString((String)"a.b.namespace"), Arrays.asList("a", "b", "namespace"), "a.b.namespace"), new NamespaceOfParse(Namespace.of((String[])new String[]{"a", "b", "namespace"}), Arrays.asList("a", "b", "namespace"), "a.b.namespace"), new NamespaceOfParse(Namespace.of(Arrays.asList("a", "b", "namespace")), Arrays.asList("a", "b", "namespace"), "a.b.namespace"), new NamespaceOfParse(Namespace.EMPTY, Collections.emptyList(), ""), new NamespaceOfParse(Namespace.of(Collections.singletonList("namespace")), Collections.singletonList("namespace"), "namespace"), new NamespaceOfParse(Namespace.fromPathString((String)"namespace"), Collections.singletonList("namespace"), "namespace"));
    }

    static class NamespaceOfParse {
        final Namespace namespace;
        final List<String> elements;
        final String name;

        NamespaceOfParse(Namespace namespace, List<String> elements, String name) {
            this.namespace = namespace;
            this.elements = elements;
            this.name = name;
        }

        public String toString() {
            return new StringJoiner(", ", NamespaceOfParse.class.getSimpleName() + "[", "]").add("namespace=" + this.namespace).add("elements=" + this.elements).add("name='" + this.name + "'").toString();
        }
    }
}

